/*
 * Decompiled with CFR 0.152.
 */
package ec3.integration.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ec3.api.DemonTrade;
import ec3.common.block.BlocksCore;
import ec3.common.item.ItemGenericEC3;
import ec3.common.item.ItemsCore;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;

public class DemonRecipeHandler
extends TemplateRecipeHandler {
    public static final Random rnd = new Random();

    public String getRecipeName() {
        return "Demon Trade";
    }

    public String getGuiTexture() {
        return "essentialcraft:textures/gui/demon.png";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        ItemStack stk;
        if (results.length > 0 && results != null && results[0] instanceof ItemStack && (stk = (ItemStack)ItemStack.class.cast(results[0])) != null && stk.func_77973_b() instanceof ItemGenericEC3 && stk.func_77960_j() == 52) {
            this.arecipes.add(new DemonCraftingPair(DemonTrade.trades.get(rnd.nextInt(DemonTrade.trades.size()))));
        }
    }

    public void drawExtras(int recipe) {
        if (this.cycleticks % 20 == 0) {
            this.arecipes.remove(0);
            this.arecipes.add(new DemonCraftingPair(DemonTrade.trades.get(rnd.nextInt(DemonTrade.trades.size()))));
        }
        super.drawExtras(recipe);
    }

    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public class DemonCraftingPair
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        PositionedStack[] ingred;
        PositionedStack result;

        public DemonCraftingPair(DemonTrade recipe) {
            super((TemplateRecipeHandler)DemonRecipeHandler.this);
            this.ingred = new PositionedStack[2];
            ItemStack craftMatrix = recipe.desiredItem;
            if (craftMatrix == null) {
                craftMatrix = new ItemStack(ItemsCore.soul, 1, DemonTrade.allMobs.indexOf(recipe.entityType));
            }
            this.ingred[0] = new PositionedStack((Object)craftMatrix, 92, 6);
            this.result = new PositionedStack((Object)new ItemStack(ItemsCore.genericItem, 1, 52), 75, 1);
            this.ingredients = new ArrayList();
            this.setIngredients(craftMatrix, 1);
        }

        public void setIngredients(ItemStack items, int size) {
            ArrayList<ItemStack> possibleStacks = new ArrayList<ItemStack>();
            possibleStacks.add(items);
            PositionedStack stack = new PositionedStack(possibleStacks, 75, 19, false);
            PositionedStack rune = new PositionedStack((Object)new ItemStack(BlocksCore.demonicPentacle), 75, 37, false);
            this.ingredients.add(stack);
            this.ingredients.add(rune);
            possibleStacks.clear();
            possibleStacks = null;
        }

        public List<PositionedStack> getIngredients() {
            return this.ingredients;
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }
}

