/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.world.structure;

import ec3.common.block.BlocksCore;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraftforge.common.ChestGenHooks;

public class StructureModernShaftPieces {
    public static final WeightedRandomChestContent[] mineshaftChestContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.field_151042_j, 0, 1, 5, 10), new WeightedRandomChestContent(Items.field_151043_k, 0, 1, 3, 5), new WeightedRandomChestContent(Items.field_151137_ax, 0, 4, 9, 5), new WeightedRandomChestContent(Items.field_151100_aR, 4, 4, 9, 5), new WeightedRandomChestContent(Items.field_151045_i, 0, 1, 2, 3), new WeightedRandomChestContent(Items.field_151044_h, 0, 3, 8, 10), new WeightedRandomChestContent(Items.field_151025_P, 0, 1, 3, 15), new WeightedRandomChestContent(Items.field_151035_b, 0, 1, 1, 1), new WeightedRandomChestContent(Item.func_150898_a((Block)Blocks.field_150448_aq), 0, 4, 8, 1), new WeightedRandomChestContent(Items.field_151081_bc, 0, 2, 4, 10), new WeightedRandomChestContent(Items.field_151080_bb, 0, 2, 4, 10), new WeightedRandomChestContent(Items.field_151141_av, 0, 1, 1, 3), new WeightedRandomChestContent(Items.field_151138_bX, 0, 1, 1, 1)};

    public static void registerStructurePieces() {
        MapGenStructureIO.func_143031_a(Corridor.class, (String)"MMSCorridor");
        MapGenStructureIO.func_143031_a(Cross.class, (String)"MMSCrossing");
        MapGenStructureIO.func_143031_a(Room.class, (String)"MMSRoom");
        MapGenStructureIO.func_143031_a(Stairs.class, (String)"MMSStairs");
    }

    private static StructureComponent getRandomComponent(List p_78815_0_, Random p_78815_1_, int p_78815_2_, int p_78815_3_, int p_78815_4_, int p_78815_5_, int p_78815_6_) {
        int j1 = p_78815_1_.nextInt(100);
        if (j1 >= 80) {
            StructureBoundingBox structureboundingbox = Cross.findValidPlacement(p_78815_0_, p_78815_1_, p_78815_2_, p_78815_3_, p_78815_4_, p_78815_5_);
            if (structureboundingbox != null) {
                return new Cross(p_78815_6_, p_78815_1_, structureboundingbox, p_78815_5_);
            }
        } else if (j1 >= 70) {
            StructureBoundingBox structureboundingbox = Stairs.findValidPlacement(p_78815_0_, p_78815_1_, p_78815_2_, p_78815_3_, p_78815_4_, p_78815_5_);
            if (structureboundingbox != null) {
                return new Stairs(p_78815_6_, p_78815_1_, structureboundingbox, p_78815_5_);
            }
        } else {
            StructureBoundingBox structureboundingbox = Corridor.findValidPlacement(p_78815_0_, p_78815_1_, p_78815_2_, p_78815_3_, p_78815_4_, p_78815_5_);
            if (structureboundingbox != null) {
                return new Corridor(p_78815_6_, p_78815_1_, structureboundingbox, p_78815_5_);
            }
        }
        return null;
    }

    private static StructureComponent getNextMineShaftComponent(StructureComponent p_78817_0_, List p_78817_1_, Random p_78817_2_, int p_78817_3_, int p_78817_4_, int p_78817_5_, int p_78817_6_, int p_78817_7_) {
        if (p_78817_7_ > 8) {
            return null;
        }
        if (Math.abs(p_78817_3_ - p_78817_0_.func_74874_b().field_78897_a) <= 80 && Math.abs(p_78817_5_ - p_78817_0_.func_74874_b().field_78896_c) <= 80) {
            StructureComponent structurecomponent1 = StructureModernShaftPieces.getRandomComponent(p_78817_1_, p_78817_2_, p_78817_3_, p_78817_4_, p_78817_5_, p_78817_6_, p_78817_7_ + 1);
            if (structurecomponent1 != null) {
                p_78817_1_.add(structurecomponent1);
                structurecomponent1.func_74861_a(p_78817_0_, p_78817_1_, p_78817_2_);
            }
            return structurecomponent1;
        }
        return null;
    }

    public static class Stairs
    extends StructureComponent {
        public Stairs() {
        }

        public Stairs(int p_i2038_1_, Random p_i2038_2_, StructureBoundingBox p_i2038_3_, int p_i2038_4_) {
            super(p_i2038_1_);
            this.field_74885_f = p_i2038_4_;
            this.field_74887_e = p_i2038_3_;
        }

        protected void func_143012_a(NBTTagCompound p_143012_1_) {
        }

        protected void func_143011_b(NBTTagCompound p_143011_1_) {
        }

        public static StructureBoundingBox findValidPlacement(List p_74950_0_, Random p_74950_1_, int p_74950_2_, int p_74950_3_, int p_74950_4_, int p_74950_5_) {
            StructureBoundingBox structureboundingbox = new StructureBoundingBox(p_74950_2_, p_74950_3_ - 5, p_74950_4_, p_74950_2_, p_74950_3_ + 2, p_74950_4_);
            switch (p_74950_5_) {
                case 0: {
                    structureboundingbox.field_78893_d = p_74950_2_ + 2;
                    structureboundingbox.field_78892_f = p_74950_4_ + 8;
                    break;
                }
                case 1: {
                    structureboundingbox.field_78897_a = p_74950_2_ - 8;
                    structureboundingbox.field_78892_f = p_74950_4_ + 2;
                    break;
                }
                case 2: {
                    structureboundingbox.field_78893_d = p_74950_2_ + 2;
                    structureboundingbox.field_78896_c = p_74950_4_ - 8;
                    break;
                }
                case 3: {
                    structureboundingbox.field_78893_d = p_74950_2_ + 8;
                    structureboundingbox.field_78892_f = p_74950_4_ + 2;
                }
            }
            return StructureComponent.func_74883_a((List)p_74950_0_, (StructureBoundingBox)structureboundingbox) != null ? null : structureboundingbox;
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            int i = this.func_74877_c();
            switch (this.field_74885_f) {
                case 0: {
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, 0, i);
                    break;
                }
                case 1: {
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, 1, i);
                    break;
                }
                case 2: {
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, 2, i);
                    break;
                }
                case 3: {
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, 3, i);
                }
            }
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (this.func_74860_a(p_74875_1_, p_74875_3_)) {
                return false;
            }
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 5, 0, 2, 7, 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 0, 7, 2, 2, 8, Blocks.field_150350_a, Blocks.field_150350_a, false);
            for (int i = -20; i < 5; ++i) {
                this.func_151549_a(p_74875_1_, p_74875_3_, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            return true;
        }
    }

    public static class Room
    extends StructureComponent {
        private List roomsLinkedToTheRoom = new LinkedList();

        public Room() {
        }

        public Room(int p_i2037_1_, Random p_i2037_2_, int p_i2037_3_, int p_i2037_4_) {
            super(p_i2037_1_);
            this.field_74887_e = new StructureBoundingBox(p_i2037_3_, 50, p_i2037_4_, p_i2037_3_ + 7 + p_i2037_2_.nextInt(6), 54 + p_i2037_2_.nextInt(6), p_i2037_4_ + 7 + p_i2037_2_.nextInt(6));
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            StructureBoundingBox structureboundingbox;
            StructureComponent structurecomponent1;
            int j;
            int i = this.func_74877_c();
            int k = this.field_74887_e.func_78882_c() - 3 - 1;
            if (k <= 0) {
                k = 1;
            }
            for (j = 0; j < this.field_74887_e.func_78883_b() && (j += p_74861_3_.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); j += 4) {
                structurecomponent1 = StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a + j, this.field_74887_e.field_78895_b + p_74861_3_.nextInt(k) + 1, this.field_74887_e.field_78896_c - 1, 2, i);
                if (structurecomponent1 == null) continue;
                structureboundingbox = structurecomponent1.func_74874_b();
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(structureboundingbox.field_78897_a, structureboundingbox.field_78895_b, this.field_74887_e.field_78896_c, structureboundingbox.field_78893_d, structureboundingbox.field_78894_e, this.field_74887_e.field_78896_c + 1));
            }
            for (j = 0; j < this.field_74887_e.func_78883_b() && (j += p_74861_3_.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); j += 4) {
                structurecomponent1 = StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a + j, this.field_74887_e.field_78895_b + p_74861_3_.nextInt(k) + 1, this.field_74887_e.field_78892_f + 1, 0, i);
                if (structurecomponent1 == null) continue;
                structureboundingbox = structurecomponent1.func_74874_b();
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(structureboundingbox.field_78897_a, structureboundingbox.field_78895_b, this.field_74887_e.field_78892_f - 1, structureboundingbox.field_78893_d, structureboundingbox.field_78894_e, this.field_74887_e.field_78892_f));
            }
            for (j = 0; j < this.field_74887_e.func_78880_d() && (j += p_74861_3_.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); j += 4) {
                structurecomponent1 = StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + p_74861_3_.nextInt(k) + 1, this.field_74887_e.field_78896_c + j, 1, i);
                if (structurecomponent1 == null) continue;
                structureboundingbox = structurecomponent1.func_74874_b();
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(this.field_74887_e.field_78897_a, structureboundingbox.field_78895_b, structureboundingbox.field_78896_c, this.field_74887_e.field_78897_a + 1, structureboundingbox.field_78894_e, structureboundingbox.field_78892_f));
            }
            for (j = 0; j < this.field_74887_e.func_78880_d() && (j += p_74861_3_.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); j += 4) {
                structurecomponent1 = StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + p_74861_3_.nextInt(k) + 1, this.field_74887_e.field_78896_c + j, 3, i);
                if (structurecomponent1 == null) continue;
                structureboundingbox = structurecomponent1.func_74874_b();
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(this.field_74887_e.field_78893_d - 1, structureboundingbox.field_78895_b, structureboundingbox.field_78896_c, this.field_74887_e.field_78893_d, structureboundingbox.field_78894_e, structureboundingbox.field_78892_f));
            }
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (this.func_74860_a(p_74875_1_, p_74875_3_)) {
                return false;
            }
            this.func_151549_a(p_74875_1_, p_74875_3_, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, Blocks.field_150346_d, Blocks.field_150350_a, true);
            this.func_151549_a(p_74875_1_, p_74875_3_, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, Math.min(this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78894_e), this.field_74887_e.field_78892_f, Blocks.field_150350_a, Blocks.field_150350_a, false);
            for (StructureBoundingBox structureboundingbox1 : this.roomsLinkedToTheRoom) {
                this.func_151549_a(p_74875_1_, p_74875_3_, structureboundingbox1.field_78897_a, structureboundingbox1.field_78894_e - 2, structureboundingbox1.field_78896_c, structureboundingbox1.field_78893_d, structureboundingbox1.field_78894_e, structureboundingbox1.field_78892_f, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            this.func_151547_a(p_74875_1_, p_74875_3_, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, Blocks.field_150350_a, false);
            return true;
        }

        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            NBTTagList nbttaglist = new NBTTagList();
            for (StructureBoundingBox structureboundingbox : this.roomsLinkedToTheRoom) {
                nbttaglist.func_74742_a((NBTBase)structureboundingbox.func_151535_h());
            }
            p_143012_1_.func_74782_a("Entrances", (NBTBase)nbttaglist);
        }

        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            NBTTagList nbttaglist = p_143011_1_.func_150295_c("Entrances", 11);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(nbttaglist.func_150306_c(i)));
            }
        }
    }

    public static class Cross
    extends StructureComponent {
        private int corridorDirection;
        private boolean isMultipleFloors;

        public Cross() {
        }

        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            p_143012_1_.func_74757_a("tf", this.isMultipleFloors);
            p_143012_1_.func_74768_a("D", this.corridorDirection);
        }

        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            this.isMultipleFloors = p_143011_1_.func_74767_n("tf");
            this.corridorDirection = p_143011_1_.func_74762_e("D");
        }

        public Cross(int p_i2036_1_, Random p_i2036_2_, StructureBoundingBox p_i2036_3_, int p_i2036_4_) {
            super(p_i2036_1_);
            this.corridorDirection = p_i2036_4_;
            this.field_74887_e = p_i2036_3_;
            this.isMultipleFloors = p_i2036_3_.func_78882_c() > 3;
        }

        public static StructureBoundingBox findValidPlacement(List p_74951_0_, Random p_74951_1_, int p_74951_2_, int p_74951_3_, int p_74951_4_, int p_74951_5_) {
            StructureBoundingBox structureboundingbox = new StructureBoundingBox(p_74951_2_, p_74951_3_, p_74951_4_, p_74951_2_, p_74951_3_ + 2, p_74951_4_);
            if (p_74951_1_.nextInt(4) == 0) {
                structureboundingbox.field_78894_e += 4;
            }
            switch (p_74951_5_) {
                case 0: {
                    structureboundingbox.field_78897_a = p_74951_2_ - 1;
                    structureboundingbox.field_78893_d = p_74951_2_ + 3;
                    structureboundingbox.field_78892_f = p_74951_4_ + 4;
                    break;
                }
                case 1: {
                    structureboundingbox.field_78897_a = p_74951_2_ - 4;
                    structureboundingbox.field_78896_c = p_74951_4_ - 1;
                    structureboundingbox.field_78892_f = p_74951_4_ + 3;
                    break;
                }
                case 2: {
                    structureboundingbox.field_78897_a = p_74951_2_ - 1;
                    structureboundingbox.field_78893_d = p_74951_2_ + 3;
                    structureboundingbox.field_78896_c = p_74951_4_ - 4;
                    break;
                }
                case 3: {
                    structureboundingbox.field_78893_d = p_74951_2_ + 4;
                    structureboundingbox.field_78896_c = p_74951_4_ - 1;
                    structureboundingbox.field_78892_f = p_74951_4_ + 3;
                }
            }
            return StructureComponent.func_74883_a((List)p_74951_0_, (StructureBoundingBox)structureboundingbox) != null ? null : structureboundingbox;
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            int i = this.func_74877_c();
            switch (this.corridorDirection) {
                case 0: {
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, 0, i);
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, 1, i);
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, 3, i);
                    break;
                }
                case 1: {
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, 2, i);
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, 0, i);
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, 1, i);
                    break;
                }
                case 2: {
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, 2, i);
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, 1, i);
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, 3, i);
                    break;
                }
                case 3: {
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, 2, i);
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, 0, i);
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, 3, i);
                }
            }
            if (this.isMultipleFloors) {
                if (p_74861_3_.nextBoolean()) {
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c - 1, 2, i);
                }
                if (p_74861_3_.nextBoolean()) {
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, 1, i);
                }
                if (p_74861_3_.nextBoolean()) {
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, 3, i);
                }
                if (p_74861_3_.nextBoolean()) {
                    StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78892_f + 1, 0, i);
                }
            }
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            if (this.func_74860_a(p_74875_1_, p_74875_3_)) {
                return false;
            }
            if (this.isMultipleFloors) {
                this.func_151549_a(p_74875_1_, p_74875_3_, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f, Blocks.field_150350_a, Blocks.field_150350_a, false);
                this.func_151549_a(p_74875_1_, p_74875_3_, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
                this.func_151549_a(p_74875_1_, p_74875_3_, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, Blocks.field_150350_a, Blocks.field_150350_a, false);
                this.func_151549_a(p_74875_1_, p_74875_3_, this.field_74887_e.field_78897_a, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
                this.func_151549_a(p_74875_1_, p_74875_3_, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
            } else {
                this.func_151549_a(p_74875_1_, p_74875_3_, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, Blocks.field_150350_a, Blocks.field_150350_a, false);
                this.func_151549_a(p_74875_1_, p_74875_3_, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            this.func_151549_a(p_74875_1_, p_74875_3_, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78896_c + 1, BlocksCore.voidStone, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, BlocksCore.voidStone, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78896_c + 1, BlocksCore.voidStone, Blocks.field_150350_a, false);
            this.func_151549_a(p_74875_1_, p_74875_3_, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, BlocksCore.voidStone, Blocks.field_150350_a, false);
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    if (this.func_151548_a(p_74875_1_, i, this.field_74887_e.field_78895_b - 1, j, p_74875_3_).func_149688_o() != Material.field_151579_a) continue;
                    this.func_151550_a(p_74875_1_, BlocksCore.voidStone, 0, i, this.field_74887_e.field_78895_b - 1, j, p_74875_3_);
                }
            }
            return true;
        }
    }

    public static class Corridor
    extends StructureComponent {
        private boolean hasRails;
        private boolean hasSpiders;
        private boolean spawnerPlaced;
        private int sectionCount;

        public Corridor() {
        }

        protected void func_143012_a(NBTTagCompound p_143012_1_) {
            p_143012_1_.func_74757_a("hr", this.hasRails);
            p_143012_1_.func_74757_a("sc", this.hasSpiders);
            p_143012_1_.func_74757_a("hps", this.spawnerPlaced);
            p_143012_1_.func_74768_a("Num", this.sectionCount);
        }

        protected void func_143011_b(NBTTagCompound p_143011_1_) {
            this.hasRails = p_143011_1_.func_74767_n("hr");
            this.hasSpiders = p_143011_1_.func_74767_n("sc");
            this.spawnerPlaced = p_143011_1_.func_74767_n("hps");
            this.sectionCount = p_143011_1_.func_74762_e("Num");
        }

        public Corridor(int p_i2035_1_, Random p_i2035_2_, StructureBoundingBox p_i2035_3_, int p_i2035_4_) {
            super(p_i2035_1_);
            this.field_74885_f = p_i2035_4_;
            this.field_74887_e = p_i2035_3_;
            this.hasRails = p_i2035_2_.nextInt(3) == 0;
            this.hasSpiders = !this.hasRails && p_i2035_2_.nextInt(23) == 0;
            this.sectionCount = this.field_74885_f != 2 && this.field_74885_f != 0 ? p_i2035_3_.func_78883_b() / 5 : p_i2035_3_.func_78880_d() / 5;
        }

        public static StructureBoundingBox findValidPlacement(List p_74954_0_, Random p_74954_1_, int p_74954_2_, int p_74954_3_, int p_74954_4_, int p_74954_5_) {
            int i1;
            StructureBoundingBox structureboundingbox = new StructureBoundingBox(p_74954_2_, p_74954_3_, p_74954_4_, p_74954_2_, p_74954_3_ + 2, p_74954_4_);
            for (i1 = p_74954_1_.nextInt(3) + 2; i1 > 0; --i1) {
                int j1 = i1 * 5;
                switch (p_74954_5_) {
                    case 0: {
                        structureboundingbox.field_78893_d = p_74954_2_ + 2;
                        structureboundingbox.field_78892_f = p_74954_4_ + (j1 - 1);
                        break;
                    }
                    case 1: {
                        structureboundingbox.field_78897_a = p_74954_2_ - (j1 - 1);
                        structureboundingbox.field_78892_f = p_74954_4_ + 2;
                        break;
                    }
                    case 2: {
                        structureboundingbox.field_78893_d = p_74954_2_ + 2;
                        structureboundingbox.field_78896_c = p_74954_4_ - (j1 - 1);
                        break;
                    }
                    case 3: {
                        structureboundingbox.field_78893_d = p_74954_2_ + (j1 - 1);
                        structureboundingbox.field_78892_f = p_74954_4_ + 2;
                    }
                }
                if (StructureComponent.func_74883_a((List)p_74954_0_, (StructureBoundingBox)structureboundingbox) == null) break;
            }
            return i1 > 0 ? structureboundingbox : null;
        }

        public void func_74861_a(StructureComponent p_74861_1_, List p_74861_2_, Random p_74861_3_) {
            block24: {
                int i = this.func_74877_c();
                int j = p_74861_3_.nextInt(4);
                switch (this.field_74885_f) {
                    case 0: {
                        if (j <= 1) {
                            StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + p_74861_3_.nextInt(3), this.field_74887_e.field_78892_f + 1, this.field_74885_f, i);
                            break;
                        }
                        if (j == 2) {
                            StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + p_74861_3_.nextInt(3), this.field_74887_e.field_78892_f - 3, 1, i);
                            break;
                        }
                        StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + p_74861_3_.nextInt(3), this.field_74887_e.field_78892_f - 3, 3, i);
                        break;
                    }
                    case 1: {
                        if (j <= 1) {
                            StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + p_74861_3_.nextInt(3), this.field_74887_e.field_78896_c, this.field_74885_f, i);
                            break;
                        }
                        if (j == 2) {
                            StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + p_74861_3_.nextInt(3), this.field_74887_e.field_78896_c - 1, 2, i);
                            break;
                        }
                        StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + p_74861_3_.nextInt(3), this.field_74887_e.field_78892_f + 1, 0, i);
                        break;
                    }
                    case 2: {
                        if (j <= 1) {
                            StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + p_74861_3_.nextInt(3), this.field_74887_e.field_78896_c - 1, this.field_74885_f, i);
                            break;
                        }
                        if (j == 2) {
                            StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + p_74861_3_.nextInt(3), this.field_74887_e.field_78896_c, 1, i);
                            break;
                        }
                        StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + p_74861_3_.nextInt(3), this.field_74887_e.field_78896_c, 3, i);
                        break;
                    }
                    case 3: {
                        if (j <= 1) {
                            StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + p_74861_3_.nextInt(3), this.field_74887_e.field_78896_c, this.field_74885_f, i);
                            break;
                        }
                        if (j == 2) {
                            StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + p_74861_3_.nextInt(3), this.field_74887_e.field_78896_c - 1, 2, i);
                            break;
                        }
                        StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + p_74861_3_.nextInt(3), this.field_74887_e.field_78892_f + 1, 0, i);
                    }
                }
                if (i >= 8) break block24;
                if (this.field_74885_f != 2 && this.field_74885_f != 0) {
                    int k = this.field_74887_e.field_78897_a + 3;
                    while (k + 3 <= this.field_74887_e.field_78893_d) {
                        int l = p_74861_3_.nextInt(5);
                        if (l == 0) {
                            StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, k, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, 2, i + 1);
                        } else if (l == 1) {
                            StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, k, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, 0, i + 1);
                        }
                        k += 5;
                    }
                } else {
                    int k = this.field_74887_e.field_78896_c + 3;
                    while (k + 3 <= this.field_74887_e.field_78892_f) {
                        int l = p_74861_3_.nextInt(5);
                        if (l == 0) {
                            StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, k, 1, i + 1);
                        } else if (l == 1) {
                            StructureModernShaftPieces.getNextMineShaftComponent(p_74861_1_, p_74861_2_, p_74861_3_, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, k, 3, i + 1);
                        }
                        k += 5;
                    }
                }
            }
        }

        protected boolean func_74879_a(World p_74879_1_, StructureBoundingBox p_74879_2_, Random p_74879_3_, int p_74879_4_, int p_74879_5_, int p_74879_6_, WeightedRandomChestContent[] p_74879_7_, int p_74879_8_) {
            int k1;
            int j1;
            int i1 = this.func_74865_a(p_74879_4_, p_74879_6_);
            if (p_74879_2_.func_78890_b(i1, j1 = this.func_74862_a(p_74879_5_), k1 = this.func_74873_b(p_74879_4_, p_74879_6_)) && p_74879_1_.func_147439_a(i1, j1, k1).func_149688_o() == Material.field_151579_a) {
                int l1 = p_74879_3_.nextBoolean() ? 1 : 0;
                p_74879_1_.func_147465_d(i1, j1, k1, Blocks.field_150448_aq, this.func_151555_a(Blocks.field_150448_aq, l1), 2);
                p_74879_1_.func_147465_d(i1, j1 - 1, k1, BlocksCore.voidStone, 0, 2);
                EntityMinecartChest entityminecartchest = new EntityMinecartChest(p_74879_1_, (double)((float)i1 + 0.5f), (double)((float)j1 + 0.5f), (double)((float)k1 + 0.5f));
                WeightedRandomChestContent.func_76293_a((Random)p_74879_3_, (WeightedRandomChestContent[])p_74879_7_, (IInventory)entityminecartchest, (int)p_74879_8_);
                p_74879_1_.func_72838_d((Entity)entityminecartchest);
                return true;
            }
            return false;
        }

        public boolean func_74875_a(World p_74875_1_, Random p_74875_2_, StructureBoundingBox p_74875_3_) {
            int k;
            int j;
            if (this.func_74860_a(p_74875_1_, p_74875_3_)) {
                return false;
            }
            int i = this.sectionCount * 5 - 1;
            this.func_151549_a(p_74875_1_, p_74875_3_, 0, 0, 0, 2, 1, i, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151551_a(p_74875_1_, p_74875_3_, p_74875_2_, 0.8f, 0, 2, 0, 2, 2, i, Blocks.field_150350_a, Blocks.field_150350_a, false);
            if (this.hasSpiders) {
                this.func_151551_a(p_74875_1_, p_74875_3_, p_74875_2_, 0.6f, 0, 0, 0, 2, 1, i, Blocks.field_150321_G, Blocks.field_150350_a, false);
            }
            for (j = 0; j < this.sectionCount; ++j) {
                k = 2 + j * 5;
                if (p_74875_2_.nextInt(4) == 0) {
                    this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, k, 0, 2, k, BlocksCore.voidStone, BlocksCore.voidStone, false);
                    this.func_151549_a(p_74875_1_, p_74875_3_, 2, 2, k, 2, 2, k, BlocksCore.voidStone, BlocksCore.voidStone, false);
                } else {
                    this.func_151549_a(p_74875_1_, p_74875_3_, 0, 2, k, 2, 2, k, BlocksCore.voidStone, Blocks.field_150350_a, false);
                }
                this.func_151552_a(p_74875_1_, p_74875_3_, p_74875_2_, 0.1f, 0, 2, k - 1, Blocks.field_150321_G, 0);
                this.func_151552_a(p_74875_1_, p_74875_3_, p_74875_2_, 0.1f, 2, 2, k - 1, Blocks.field_150321_G, 0);
                this.func_151552_a(p_74875_1_, p_74875_3_, p_74875_2_, 0.1f, 0, 2, k + 1, Blocks.field_150321_G, 0);
                this.func_151552_a(p_74875_1_, p_74875_3_, p_74875_2_, 0.1f, 2, 2, k + 1, Blocks.field_150321_G, 0);
                this.func_151552_a(p_74875_1_, p_74875_3_, p_74875_2_, 0.05f, 0, 2, k - 2, Blocks.field_150321_G, 0);
                this.func_151552_a(p_74875_1_, p_74875_3_, p_74875_2_, 0.05f, 2, 2, k - 2, Blocks.field_150321_G, 0);
                this.func_151552_a(p_74875_1_, p_74875_3_, p_74875_2_, 0.05f, 0, 2, k + 2, Blocks.field_150321_G, 0);
                this.func_151552_a(p_74875_1_, p_74875_3_, p_74875_2_, 0.05f, 2, 2, k + 2, Blocks.field_150321_G, 0);
                this.func_151552_a(p_74875_1_, p_74875_3_, p_74875_2_, 0.05f, 1, 2, k - 1, Blocks.field_150478_aa, 0);
                this.func_151552_a(p_74875_1_, p_74875_3_, p_74875_2_, 0.05f, 1, 2, k + 1, Blocks.field_150478_aa, 0);
                ChestGenHooks info = ChestGenHooks.getInfo((String)"mineshaftCorridor");
                if (p_74875_2_.nextInt(100) == 0) {
                    this.func_74879_a(p_74875_1_, p_74875_3_, p_74875_2_, 2, 0, k - 1, info.getItems(p_74875_2_), info.getCount(p_74875_2_));
                }
                if (p_74875_2_.nextInt(100) == 0) {
                    this.func_74879_a(p_74875_1_, p_74875_3_, p_74875_2_, 0, 0, k + 1, info.getItems(p_74875_2_), info.getCount(p_74875_2_));
                }
                if (!this.hasSpiders || this.spawnerPlaced) continue;
                int l = this.func_74862_a(0);
                int i1 = k - 1 + p_74875_2_.nextInt(3);
                int j1 = this.func_74865_a(1, i1);
                if (!p_74875_3_.func_78890_b(j1, l, i1 = this.func_74873_b(1, i1))) continue;
                this.spawnerPlaced = true;
                p_74875_1_.func_147465_d(j1, l, i1, Blocks.field_150474_ac, 0, 2);
                TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)p_74875_1_.func_147438_o(j1, l, i1);
                if (tileentitymobspawner == null) continue;
                tileentitymobspawner.func_145881_a().func_98272_a("CaveSpider");
            }
            for (j = 0; j <= 2; ++j) {
                for (k = 0; k <= i; ++k) {
                    int b0 = -1;
                    Block block1 = this.func_151548_a(p_74875_1_, j, b0, k, p_74875_3_);
                    if (block1.func_149688_o() != Material.field_151579_a) continue;
                    int b1 = -1;
                    this.func_151550_a(p_74875_1_, BlocksCore.voidStone, 0, j, b1, k, p_74875_3_);
                }
            }
            if (this.hasRails) {
                for (j = 0; j <= i; ++j) {
                    this.func_151548_a(p_74875_1_, 1, -1, j, p_74875_3_);
                    this.func_151552_a(p_74875_1_, p_74875_3_, p_74875_2_, 0.7f, 1, 0, j, Blocks.field_150448_aq, this.func_151555_a(Blocks.field_150448_aq, 0));
                    this.func_151552_a(p_74875_1_, p_74875_3_, p_74875_2_, 0.7f, 0, -1, j, BlocksCore.voidStone, 0);
                    this.func_151552_a(p_74875_1_, p_74875_3_, p_74875_2_, 0.7f, 1, -1, j, BlocksCore.voidStone, 0);
                    this.func_151552_a(p_74875_1_, p_74875_3_, p_74875_2_, 0.7f, -1, -1, j, BlocksCore.voidStone, 0);
                }
            }
            return true;
        }
    }
}

