/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.Coord3D;
import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import DummyCore.Utils.DummyDistance;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ec3.common.tile.TileMRUGeneric;
import ec3.utils.common.ECUtils;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.config.Configuration;

public class TileMonsterHolder
extends TileMRUGeneric {
    public static float rad = 12.0f;
    public static float cfgMaxMRU = 5000.0f;
    public static boolean generatesCorruption = false;
    public static int genCorruption = 1;
    public static int mruUsage = 1;

    public TileMonsterHolder() {
        this.maxMRU = (int)cfgMaxMRU;
        this.setSlotsNum(1);
    }

    @Override
    public void func_145845_h() {
        List lst;
        super.func_145845_h();
        ECUtils.manage(this, 0);
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) && !(lst = this.func_145831_w().func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 32), (double)(this.field_145848_d - 32), (double)(this.field_145849_e - 32), (double)(this.field_145851_c + 32), (double)(this.field_145848_d + 32), (double)(this.field_145849_e + 32)))).isEmpty()) {
            for (int i = 0; i < lst.size(); ++i) {
                EntityLivingBase e = (EntityLivingBase)lst.get(i);
                if (e instanceof EntityPlayer || this.getMRU() <= mruUsage) continue;
                Coord3D tilePos = new Coord3D((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                Coord3D mobPosition = new Coord3D(e.field_70165_t, e.field_70163_u, e.field_70161_v);
                DummyDistance dist = new DummyDistance(tilePos, mobPosition);
                if (dist.getDistance() < rad && dist.getDistance() >= rad - 3.0f) {
                    Vec3 posVector = Vec3.func_72443_a((double)(tilePos.x - mobPosition.x), (double)(tilePos.y - mobPosition.y), (double)(tilePos.z - mobPosition.z));
                    e.func_70080_a((double)tilePos.x - posVector.field_72450_a / 1.1, (double)tilePos.y - posVector.field_72448_b / 1.1, (double)tilePos.z - posVector.field_72449_c / 1.1, e.field_70177_z, e.field_70125_A);
                }
                if (this.field_145850_b.field_72995_K) continue;
                this.setMRU(this.getMRU() - mruUsage);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        return bb;
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("MonsterHolderSettings", "tileentities", new String[]{"Max MRU:5000.0", "MRU Usage Per Mob:1", "Can this device actually generate corruption:false", "The amount of corruption generated each tick(do not set to 0!):1", "Radius to hold mobs within:12.0"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            mruUsage = Integer.parseInt(data[1].fieldValue);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            generatesCorruption = Boolean.parseBoolean(data[2].fieldValue);
            genCorruption = Integer.parseInt(data[3].fieldValue);
            rad = Float.parseFloat(data[4].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{0};
    }
}

