/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import DummyCore.Utils.MiscUtils;
import ec3.common.tile.TileMRUGeneric;
import ec3.utils.common.ECUtils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.FakePlayer;

public class TileMonsterHarvester
extends TileMRUGeneric {
    public static float rad = 12.0f;
    public float rotation = 0.0f;
    public int destrTick;
    public static float cfgMaxMRU = 5000.0f;
    public static boolean generatesCorruption = false;
    public static int genCorruption = 10;
    public static int mruUsage = 100;
    public static int mobDestructionTimer = 1440;
    public static boolean allowBossDuplication = false;
    public static boolean clearCopyInventory = true;

    public TileMonsterHarvester() {
        this.maxMRU = (int)cfgMaxMRU;
        this.setSlotsNum(6);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        ECUtils.manage(this, 0);
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            ++this.destrTick;
            if (this.destrTick >= mobDestructionTimer) {
                this.destrTick = 0;
                List lst = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 16), (double)(this.field_145848_d - 16), (double)(this.field_145849_e - 16), (double)(this.field_145851_c + 16), (double)(this.field_145848_d + 16), (double)(this.field_145849_e + 16)));
                if (!lst.isEmpty() && !this.field_145850_b.field_72995_K) {
                    for (int i = 0; i < lst.size(); ++i) {
                        EntityLivingBase e = (EntityLivingBase)lst.get(i);
                        if (e instanceof EntityPlayer || this.getMRU() <= mruUsage) continue;
                        if (e instanceof IBossDisplayData && !allowBossDuplication) {
                            return;
                        }
                        EntityLivingBase copy = (EntityLivingBase)MiscUtils.cloneEntity((Entity)e);
                        this.field_145850_b.func_72838_d((Entity)copy);
                        if (clearCopyInventory) {
                            copy.func_70062_b(0, null);
                            copy.func_70062_b(1, null);
                            copy.func_70062_b(2, null);
                            copy.func_70062_b(3, null);
                            copy.func_70062_b(4, null);
                        }
                        FakePlayer player = new FakePlayer((WorldServer)e.field_70170_p, ECUtils.EC3FakePlayerProfile);
                        ItemStack stk = this.func_70301_a(2);
                        if (stk != null) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stk.func_77946_l());
                        }
                        copy.func_70606_j(0.1f);
                        player.func_71059_n((Entity)copy);
                        player.func_70106_y();
                        this.setMRU(this.getMRU() - mruUsage);
                        if (copy.func_110143_aJ() > 0.0f) {
                            copy.func_70106_y();
                        }
                        if (!generatesCorruption) continue;
                        ECUtils.increaseCorruptionAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(genCorruption));
                    }
                }
            }
        }
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("MonsterDuplicatorSettings", "tileentities", new String[]{"Max MRU:5000.0", "MRU Usage Per Mob:100", "Can this device actually generate corruption:false", "The amount of corruption generated each tick(do not set to 0!):10", "Radius to duplicate mobs within:12.0", "Ticks required to duplicate mobs:1440", "Allow duplication of bosses:false", "Remove inventory of a duplicate before killing it:true"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            mruUsage = Integer.parseInt(data[1].fieldValue);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            generatesCorruption = Boolean.parseBoolean(data[2].fieldValue);
            genCorruption = Integer.parseInt(data[3].fieldValue);
            rad = Float.parseFloat(data[4].fieldValue);
            mobDestructionTimer = Integer.parseInt(data[5].fieldValue);
            allowBossDuplication = Boolean.parseBoolean(data[6].fieldValue);
            clearCopyInventory = Boolean.parseBoolean(data[7].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{1, 2, 3, 4};
    }
}

