/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import DummyCore.Utils.MathUtils;
import DummyCore.Utils.MiscUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import ec3.common.block.BlocksCore;
import ec3.common.item.ItemBoundGem;
import ec3.common.mod.EssentialCraftCore;
import ec3.common.tile.TileMRUGeneric;
import ec3.utils.common.ECUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.config.Configuration;

public class TileMagicalTeleporter
extends TileMRUGeneric {
    public int progressLevel;
    public static float cfgMaxMRU = 50000.0f;
    public static boolean generatesCorruption = false;
    public static int genCorruption = 5;
    public static int mruUsage = 500;
    public static int teleportTime = 250;
    public static boolean allowDimensionalTeleportation = true;

    public TileMagicalTeleporter() {
        this.setSlotsNum(2);
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.progressLevel = par1NBTTagCompound.func_74762_e("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("progress", this.progressLevel);
    }

    @Override
    public void func_145845_h() {
        this.maxMRU = (int)cfgMaxMRU;
        super.func_145845_h();
        this.spawnParticles();
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.tryTeleport();
        }
        ECUtils.manage(this, 0);
    }

    public boolean isStructureCorrect() {
        boolean flag = true;
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if ((x == 2 || x == -2) && z == 0 || (z == 2 || z == -2) && x == 0) {
                    ItemStack c;
                    ItemStack s = new ItemStack(this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z), this.field_145850_b.func_72805_g(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z), 1);
                    flag = ItemStack.func_77989_b((ItemStack)s, (ItemStack)(c = new ItemStack(BlocksCore.magicPlating, 0, 1)));
                    if (flag) continue;
                    return false;
                }
                if (x == 0 && z == 0) continue;
                boolean bl = flag = this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z) == BlocksCore.voidStone;
                if (flag) continue;
                return false;
            }
        }
        flag = this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e + 2) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d + 2, this.field_145849_e + 2) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c + 2, this.field_145848_d + 1, this.field_145849_e + 1) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c + 2, this.field_145848_d + 2, this.field_145849_e + 1) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c - 2, this.field_145848_d + 1, this.field_145849_e + 1) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c - 2, this.field_145848_d + 2, this.field_145849_e + 1) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e + 2) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d + 2, this.field_145849_e + 2) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c + 2, this.field_145848_d + 1, this.field_145849_e - 1) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c + 2, this.field_145848_d + 2, this.field_145849_e - 1) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e - 2) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d + 2, this.field_145849_e - 2) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e - 2) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d + 2, this.field_145849_e - 2) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c - 2, this.field_145848_d + 1, this.field_145849_e - 1) == BlocksCore.voidStone && this.field_145850_b.func_147439_a(this.field_145851_c - 2, this.field_145848_d + 2, this.field_145849_e - 1) == BlocksCore.voidStone;
        return flag;
    }

    public void tryTeleport() {
        if (this.hasRequiredItemToTeleport() && this.hasPlayer() && this.getMRU() >= this.getTPCost() && this.isStructureCorrect()) {
            EntityPlayer player = this.getPlayer();
            ++this.progressLevel;
            this.field_145850_b.func_72956_a((Entity)player, "minecart.base", 0.1f, 0.8f + (float)this.progressLevel / (float)teleportTime);
            if (this.progressLevel >= teleportTime) {
                if (generatesCorruption) {
                    ECUtils.increaseCorruptionAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(genCorruption));
                }
                int[] tpCoords = this.getCoordsToTP();
                if (!this.field_145850_b.field_72995_K) {
                    this.setMRU(this.getMRU() - this.getTPCost());
                    for (int i = 0; i < 20; ++i) {
                        this.field_145850_b.func_72956_a((Entity)player, "fireworks.largeBlast_far", 1.0f, 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v));
                    }
                    int currentPlayerDim = player.field_71093_bK;
                    int newDim = this.getDimensionToTP();
                    if (currentPlayerDim != newDim && !player.field_70170_p.field_72995_K && allowDimensionalTeleportation) {
                        MinecraftServer mcServer = MinecraftServer.func_71276_C();
                        EntityPlayerMP p_72356_1_ = (EntityPlayerMP)player;
                        int j = currentPlayerDim;
                        WorldServer worldserver = mcServer.func_71218_a(currentPlayerDim);
                        p_72356_1_.field_71093_bK = newDim;
                        WorldServer worldserver1 = mcServer.func_71218_a(newDim);
                        p_72356_1_.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(p_72356_1_.field_71093_bK, p_72356_1_.field_70170_p.field_73013_u, p_72356_1_.field_70170_p.func_72912_H().func_76067_t(), p_72356_1_.field_71134_c.func_73081_b()));
                        worldserver.func_72973_f((Entity)p_72356_1_);
                        p_72356_1_.field_70128_L = false;
                        this.transferEntityToWorld((Entity)p_72356_1_, j, worldserver, worldserver1);
                        mcServer.func_71203_ab().func_72375_a(p_72356_1_, worldserver);
                        p_72356_1_.field_71135_a.func_147364_a(p_72356_1_.field_70165_t, p_72356_1_.field_70163_u, p_72356_1_.field_70161_v, p_72356_1_.field_70177_z, p_72356_1_.field_70125_A);
                        p_72356_1_.field_71134_c.func_73080_a(worldserver1);
                        mcServer.func_71203_ab().func_72354_b(p_72356_1_, worldserver1);
                        mcServer.func_71203_ab().func_72385_f(p_72356_1_);
                        for (PotionEffect potioneffect : p_72356_1_.func_70651_bq()) {
                            p_72356_1_.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(p_72356_1_.func_145782_y(), potioneffect));
                        }
                        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)p_72356_1_, j, newDim);
                    }
                    player.func_70634_a((double)tpCoords[0] + 0.5, (double)tpCoords[1] + 1.5, (double)tpCoords[2] + 0.5);
                    for (int i = 0; i < 20; ++i) {
                        player.field_70170_p.func_72956_a((Entity)player, "fireworks.largeBlast", 1.0f, 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v));
                    }
                }
                this.progressLevel = 0;
            }
        } else {
            this.progressLevel = 0;
        }
    }

    public void transferEntityToWorld(Entity p_82448_1_, int p_82448_2_, WorldServer p_82448_3_, WorldServer p_82448_4_) {
        WorldProvider pOld = p_82448_3_.field_73011_w;
        WorldProvider pNew = p_82448_4_.field_73011_w;
        double moveFactor = pOld.getMovementFactor() / pNew.getMovementFactor();
        double d0 = p_82448_1_.field_70165_t * moveFactor;
        double d1 = p_82448_1_.field_70161_v * moveFactor;
        p_82448_3_.field_72984_F.func_76320_a("moving");
        if (p_82448_1_.field_71093_bK == 1) {
            ChunkCoordinates chunkcoordinates = p_82448_2_ == 1 ? p_82448_4_.func_72861_E() : p_82448_4_.func_73054_j();
            d0 = chunkcoordinates.field_71574_a;
            p_82448_1_.field_70163_u = chunkcoordinates.field_71572_b;
            d1 = chunkcoordinates.field_71573_c;
            p_82448_1_.func_70012_b(d0, p_82448_1_.field_70163_u, d1, 90.0f, 0.0f);
            if (p_82448_1_.func_70089_S()) {
                p_82448_3_.func_72866_a(p_82448_1_, false);
            }
        }
        p_82448_3_.field_72984_F.func_76319_b();
        if (p_82448_2_ != 1) {
            p_82448_3_.field_72984_F.func_76320_a("placing");
            d0 = MathHelper.func_76125_a((int)((int)d0), (int)-29999872, (int)29999872);
            d1 = MathHelper.func_76125_a((int)((int)d1), (int)-29999872, (int)29999872);
            if (p_82448_1_.func_70089_S()) {
                p_82448_1_.func_70012_b(d0, p_82448_1_.field_70163_u, d1, p_82448_1_.field_70177_z, p_82448_1_.field_70125_A);
                p_82448_4_.func_72838_d(p_82448_1_);
                p_82448_4_.func_72866_a(p_82448_1_, false);
            }
            p_82448_3_.field_72984_F.func_76319_b();
        }
        p_82448_1_.func_70029_a((World)p_82448_4_);
    }

    public int getTPCost() {
        int diffZ;
        int diffY;
        int[] tpCoords = this.getCoordsToTP();
        int dim = this.getDimensionToTP();
        int diffX = (int)MathUtils.getDifference((float)this.field_145851_c, (float)tpCoords[0]);
        float mainDiff = (diffX + (diffY = (int)MathUtils.getDifference((float)this.field_145848_d, (float)tpCoords[1])) + (diffZ = (int)MathUtils.getDifference((float)this.field_145849_e, (float)tpCoords[2]))) / 3;
        int ret = (int)((float)mruUsage * mainDiff);
        if ((float)ret > cfgMaxMRU) {
            ret = (int)cfgMaxMRU;
        }
        if (this.field_145850_b.field_73011_w.field_76574_g != dim) {
            ret = (int)cfgMaxMRU;
        }
        return ret;
    }

    public EntityPlayer getPlayer() {
        List l = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1)));
        if (!l.isEmpty()) {
            return (EntityPlayer)l.get(0);
        }
        return null;
    }

    public boolean hasPlayer() {
        List l = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1)));
        return !l.isEmpty();
    }

    public int getDimensionToTP() {
        ItemStack s = this.func_70301_a(1);
        return MiscUtils.getStackTag((ItemStack)s).func_74762_e("dim");
    }

    public int[] getCoordsToTP() {
        ItemStack s = this.func_70301_a(1);
        return MiscUtils.getStackTag((ItemStack)s).func_74759_k("pos");
    }

    public boolean hasRequiredItemToTeleport() {
        return this.func_70301_a(1) != null && this.func_70301_a(1).func_77973_b() instanceof ItemBoundGem && this.func_70301_a(1).func_77978_p() != null;
    }

    public void spawnParticles() {
        if (this.hasPlayer()) {
            int i;
            EntityPlayer p = this.getPlayer();
            for (i = 0; i < this.progressLevel / 5; ++i) {
                this.field_145850_b.func_72869_a("reddust", p.field_70165_t + (double)(MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) / 2.0f), p.field_70163_u + (double)(MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 2.0f) - 1.0, p.field_70161_v + (double)(MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) / 2.0f), 0.0, 0.0, 1.0);
                this.field_145850_b.func_72869_a("reddust", (double)this.field_145851_c + 0.5 + (double)(MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 2.0f), (double)(this.field_145848_d + 3), (double)this.field_145849_e + 0.5 + (double)(MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 2.0f), 0.0, 0.0, 1.0);
                this.field_145850_b.func_72869_a("reddust", (double)this.field_145851_c + 0.5 + 2.0, (double)((float)(this.field_145848_d + 2) + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v)), (double)this.field_145849_e + 0.5 + (double)(MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 2.0f), 0.0, 0.0, 1.0);
                this.field_145850_b.func_72869_a("reddust", (double)this.field_145851_c + 0.5 - 2.0, (double)((float)(this.field_145848_d + 2) + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v)), (double)this.field_145849_e + 0.5 + (double)(MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 2.0f), 0.0, 0.0, 1.0);
                this.field_145850_b.func_72869_a("reddust", (double)this.field_145851_c + 0.5 + (double)(MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 2.0f), (double)((float)(this.field_145848_d + 2) + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v)), (double)this.field_145849_e + 0.5 - 2.0, 0.0, 0.0, 1.0);
                this.field_145850_b.func_72869_a("reddust", (double)this.field_145851_c + 0.5 + (double)(MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 2.0f), (double)((float)(this.field_145848_d + 2) + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v)), (double)this.field_145849_e + 0.5 + 2.0, 0.0, 0.0, 1.0);
            }
            for (i = 0; i < 4; ++i) {
            }
        }
        if (this.isStructureCorrect()) {
            EssentialCraftCore.proxy.spawnParticle("cSpellFX", (float)this.field_145851_c + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 3.0f, this.field_145848_d + 1, (float)this.field_145849_e + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 3.0f, 0.0, 2.0, 0.0);
        }
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("MagicalTeleporterSettings", "tileentities", new String[]{"Max MRU:50000.0", "MRU Usage per block:500", "Can this device actually generate corruption:false", "The amount of corruption generated each tick(do not set to 0!):5", "Ticks required for the teleporter to teleport an entity:250", "Allow teleportation between dimensions:true"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            mruUsage = Integer.parseInt(data[1].fieldValue);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            generatesCorruption = Boolean.parseBoolean(data[2].fieldValue);
            genCorruption = Integer.parseInt(data[3].fieldValue);
            teleportTime = Integer.parseInt(data[4].fieldValue);
            allowDimensionalTeleportation = Boolean.parseBoolean(data[5].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{0, 1};
    }
}

