/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.Coord3D;
import DummyCore.Utils.UnformedItemStack;
import ec3.api.MagicalAssemblerRecipes;
import ec3.api.MagicianTableRecipe;
import ec3.api.MagicianTableRecipes;
import ec3.api.RadiatingChamberRecipe;
import ec3.api.RadiatingChamberRecipes;
import ec3.api.ShapedAssemblerRecipe;
import ec3.common.tile.TileMRUGeneric;
import ec3.common.tile.TileMagicalMirror;
import ec3.utils.common.ECUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class TileMagicalAssembler
extends TileMRUGeneric {
    public List<UnformedItemStack> requiredItemsToCraft = new ArrayList<UnformedItemStack>();
    public List<Integer> requiredStackSizeToCraft = new ArrayList<Integer>();
    public ItemStack currentCraft;
    public List<ItemStack> allRecipes = new ArrayList<ItemStack>();
    public List<IRecipe> actualRecipes = new ArrayList<IRecipe>();
    public List<Coord3D> mirrors = new ArrayList<Coord3D>();
    public List<TileMagicalMirror> mirrorsTiles = new ArrayList<TileMagicalMirror>();
    public IRecipe currentSelectedOne;
    public int currentRecipe = -1;
    public int recipeType = -1;
    public boolean isWorking = false;

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{0, 17};
    }

    @Override
    public void func_145839_a(NBTTagCompound i) {
        this.isWorking = i.func_74767_n("working");
        this.currentRecipe = i.func_74762_e("recipeID");
        this.recipeType = i.func_74762_e("recipeType");
        NBTTagList unformedItems = i.func_150295_c("unformedItems", 10);
        this.requiredItemsToCraft.clear();
        if (unformedItems != null) {
            for (int j = 0; j < unformedItems.func_74745_c(); ++j) {
                NBTTagCompound tag = unformedItems.func_150305_b(j);
                UnformedItemStack unformedIS = new UnformedItemStack();
                unformedIS.readFromNBTTagCompound(tag);
                this.requiredItemsToCraft.add(unformedIS);
            }
        }
        if (i.func_74764_b("crafted")) {
            NBTTagCompound craftedTag = i.func_74775_l("crafted");
            this.currentCraft = ItemStack.func_77949_a((NBTTagCompound)craftedTag);
        }
        super.func_145839_a(i);
        if (this.func_70301_a(1) != null) {
            this.formCraftList(this.func_70301_a(1));
            if (this.currentRecipe != -1) {
                this.formRequiredComponents();
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound i) {
        i.func_74757_a("working", this.isWorking);
        i.func_74768_a("recipeID", this.currentRecipe);
        i.func_74768_a("recipeType", this.recipeType);
        NBTTagList unformedItems = new NBTTagList();
        for (int j = 0; j < this.requiredItemsToCraft.size(); ++j) {
            NBTTagCompound tag = new NBTTagCompound();
            this.requiredItemsToCraft.get(j).writeToNBTTagCompound(tag);
            unformedItems.func_74742_a((NBTBase)tag);
        }
        i.func_74782_a("unformedItems", (NBTBase)unformedItems);
        if (this.currentCraft != null) {
            NBTTagCompound craftTag = new NBTTagCompound();
            this.currentCraft.func_77955_b(craftTag);
            i.func_74782_a("crafted", (NBTBase)craftTag);
        }
        super.func_145841_b(i);
    }

    public int getRequiredMRUToCraft() {
        if (this.currentSelectedOne == null) {
            return 0;
        }
        if (this.currentSelectedOne instanceof MagicianTableRecipe) {
            return ((MagicianTableRecipe)this.currentSelectedOne).mruRequired;
        }
        if (this.currentSelectedOne instanceof RadiatingChamberRecipe) {
            return (int)((float)((RadiatingChamberRecipe)this.currentSelectedOne).mruRequired * ((RadiatingChamberRecipe)this.currentSelectedOne).costModifier);
        }
        if (this.currentSelectedOne instanceof ShapedAssemblerRecipe) {
            return ((ShapedAssemblerRecipe)this.currentSelectedOne).mruRequired;
        }
        return 100;
    }

    public TileMagicalAssembler() {
        this.setSlotsNum(18);
        this.setMaxMRU(10000.0f);
    }

    @Override
    public void func_145845_h() {
        for (int i = 0; i < this.mirrors.size(); ++i) {
            Coord3D coord = this.mirrors.get(i);
            TileEntity tile = this.field_145850_b.func_147438_o((int)coord.x, (int)coord.y, (int)coord.z);
            if (tile != null && tile instanceof TileMagicalMirror) continue;
            this.mirrors.remove(i);
        }
        super.func_145845_h();
        ECUtils.manage(this, 0);
        if (this.func_70301_a(1) != null) {
            Coord3D coord;
            if (this.allRecipes.isEmpty() && this.currentCraft == null) {
                this.formCraftList(this.func_70301_a(1));
            }
            if (this.currentCraft != null && !this.isWorking && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.isWorking = true;
                for (int i = 0; i < this.mirrors.size(); ++i) {
                    coord = this.mirrors.get(i);
                    TileEntity tile = this.field_145850_b.func_147438_o((int)coord.x, (int)coord.y, (int)coord.z);
                    if (tile == null || !(tile instanceof TileMagicalMirror)) {
                        this.mirrors.remove(i);
                        continue;
                    }
                    ((TileMagicalMirror)tile).begin(this);
                }
            } else if (this.currentCraft == null || !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.isWorking = false;
                for (int i = 0; i < this.mirrors.size(); ++i) {
                    coord = this.mirrors.get(i);
                    TileEntity tile = this.field_145850_b.func_147438_o((int)coord.x, (int)coord.y, (int)coord.z);
                    if (tile == null || !(tile instanceof TileMagicalMirror)) {
                        this.mirrors.remove(i);
                        continue;
                    }
                    ((TileMagicalMirror)tile).end(this);
                }
            }
            if (this.currentCraft != null && this.isWorking) {
                for (int i = 0; i < this.mirrors.size(); ++i) {
                    coord = this.mirrors.get(i);
                    TileEntity tile = this.field_145850_b.func_147438_o((int)coord.x, (int)coord.y, (int)coord.z);
                    if (tile == null || !(tile instanceof TileMagicalMirror)) {
                        this.mirrors.remove(i);
                        continue;
                    }
                    ((TileMagicalMirror)tile).pulse(this);
                }
            }
            if (this.isWorking && this.currentCraft != null && this.field_145850_b.func_72820_D() % 20L == 0L && !this.requiredItemsToCraft.isEmpty() && (this.func_70301_a(17) == null || this.func_70301_a(17).func_77969_a(this.currentCraft) && this.func_70301_a((int)17).field_77994_a + 1 < this.func_70301_a(17).func_77976_d() + 1) && this.getMRU() - this.getRequiredMRUToCraft() >= 0 && this.currentSelectedOne != null) {
                int i;
                ArrayList<UnformedItemStack> hasItems = new ArrayList<UnformedItemStack>(this.requiredItemsToCraft.size());
                ArrayList<UnformedItemStack> hasItemsCopy = new ArrayList<UnformedItemStack>(this.requiredItemsToCraft.size());
                hasItemsCopy.addAll(this.requiredItemsToCraft);
                for (i = 0; i < this.requiredItemsToCraft.size(); ++i) {
                    hasItems.add(null);
                }
                block5: for (i = 2; i < 17; ++i) {
                    ItemStack is = this.func_70301_a(i);
                    if (is == null) continue;
                    for (int j = 0; j < hasItemsCopy.size(); ++j) {
                        if (hasItemsCopy.get(j) == null || !((UnformedItemStack)hasItemsCopy.get(j)).itemStackMatches(is)) continue;
                        hasItemsCopy.set(j, null);
                        hasItems.set(j, this.requiredItemsToCraft.get(j));
                        continue block5;
                    }
                }
                for (i = 0; i < hasItems.size(); ++i) {
                    if (hasItems.get(i) != null || !this.requiredItemsToCraft.get((int)i).possibleStacks.isEmpty()) continue;
                    hasItems.set(i, this.requiredItemsToCraft.get(i));
                }
                if (hasItems.equals(this.requiredItemsToCraft)) {
                    for (i = 2; i < 17; ++i) {
                        this.func_70298_a(i, 1);
                    }
                    if (this.func_70301_a(17) == null) {
                        this.func_70299_a(17, this.currentCraft.func_77946_l());
                    } else {
                        this.func_70301_a((int)17).field_77994_a += this.currentCraft.field_77994_a;
                    }
                    this.isWorking = false;
                    this.setMRU(this.getMRU() - this.getRequiredMRUToCraft());
                    for (i = 0; i < this.mirrors.size(); ++i) {
                        Coord3D coord2 = this.mirrors.get(i);
                        TileEntity tile = this.field_145850_b.func_147438_o((int)coord2.x, (int)coord2.y, (int)coord2.z);
                        if (tile == null || !(tile instanceof TileMagicalMirror)) {
                            this.mirrors.remove(i);
                            continue;
                        }
                        ((TileMagicalMirror)tile).end(this);
                    }
                }
            }
        } else {
            this.allRecipes.clear();
            this.actualRecipes.clear();
            this.requiredItemsToCraft.clear();
            this.requiredStackSizeToCraft.clear();
            this.currentCraft = null;
            this.currentSelectedOne = null;
            this.isWorking = false;
        }
    }

    public void formRequiredComponents() {
        this.requiredItemsToCraft.clear();
        if (this.currentRecipe != -1) {
            IRecipe rec;
            this.currentSelectedOne = rec = this.actualRecipes.get(this.currentRecipe);
            this.currentCraft = rec.func_77571_b();
            for (int i = 0; i < rec.func_77570_a(); ++i) {
                Object sor;
                UnformedItemStack uis;
                ShapedRecipes sr;
                if (rec instanceof ShapedRecipes) {
                    sr = (ShapedRecipes)rec;
                    uis = new UnformedItemStack(sr.field_77574_d[i]);
                    this.requiredItemsToCraft.add(uis);
                }
                if (rec instanceof ShapelessRecipes) {
                    sr = (ShapelessRecipes)rec;
                    uis = new UnformedItemStack(sr.field_77579_b.get(i));
                    this.requiredItemsToCraft.add(uis);
                }
                if (rec instanceof MagicianTableRecipe) {
                    MagicianTableRecipe mtr = (MagicianTableRecipe)rec;
                    uis = mtr.requiredItems[i];
                    this.requiredItemsToCraft.add(uis);
                }
                if (rec instanceof RadiatingChamberRecipe) {
                    RadiatingChamberRecipe rcr = (RadiatingChamberRecipe)rec;
                    uis = new UnformedItemStack(rcr.recipeItems[i]);
                    this.requiredItemsToCraft.add(uis);
                }
                if (rec instanceof ShapedOreRecipe) {
                    sor = (ShapedOreRecipe)rec;
                    uis = new UnformedItemStack(sor.getInput()[i]);
                    this.requiredItemsToCraft.add(uis);
                }
                if (rec instanceof ShapedAssemblerRecipe) {
                    sor = (ShapedAssemblerRecipe)rec;
                    uis = new UnformedItemStack(((ShapedAssemblerRecipe)sor).getInput()[i]);
                    this.requiredItemsToCraft.add(uis);
                }
                if (!(rec instanceof ShapelessOreRecipe)) continue;
                sor = (ShapelessOreRecipe)rec;
                uis = new UnformedItemStack(sor.getInput().get(i));
                this.requiredItemsToCraft.add(uis);
            }
        }
    }

    public void formCraftList(ItemStack is) {
        this.allRecipes.clear();
        this.actualRecipes.clear();
        this.requiredItemsToCraft.clear();
        this.requiredStackSizeToCraft.clear();
        this.currentCraft = null;
        this.currentSelectedOne = null;
        if (is != null) {
            List rec = CraftingManager.func_77594_a().func_77592_b();
            ArrayList<Object> lstCR = new ArrayList<Object>();
            ArrayList lstRC = new ArrayList();
            ArrayList<MagicianTableRecipe> lstMT = new ArrayList<MagicianTableRecipe>();
            ArrayList<ShapedAssemblerRecipe> lstMA = new ArrayList<ShapedAssemblerRecipe>();
            ItemStack genStk = is.func_77946_l();
            genStk.field_77994_a = 0;
            String searchPair = genStk.toString();
            genStk = null;
            for (int i = 0; i < RadiatingChamberRecipes.craftMatrixByID.size(); ++i) {
                String string = RadiatingChamberRecipes.craftMatrixByID.get(i);
                if (string == null || string.isEmpty() || !string.contains(searchPair)) continue;
                lstRC.addAll(RadiatingChamberRecipes.recipes.get(string));
            }
            lstMA.addAll(MagicalAssemblerRecipes.findUsageRecipes(is));
            lstMT.addAll(MagicianTableRecipes.getRecipiesByComponent(is));
            for (IRecipe iRecipe : rec) {
                ShapedOreRecipe sor;
                ShapedRecipes sscr;
                if (iRecipe instanceof ShapedRecipes) {
                    sscr = (ShapedRecipes)iRecipe;
                    if (Arrays.asList(sscr.field_77574_d).contains(is)) {
                        lstCR.add(sscr);
                    }
                }
                if (iRecipe instanceof ShapelessRecipes) {
                    sscr = (ShapelessRecipes)iRecipe;
                    for (int i = 0; i < sscr.field_77579_b.size(); ++i) {
                        ItemStack s = (ItemStack)sscr.field_77579_b.get(i);
                        if (s == null || !s.func_77969_a(is)) continue;
                        lstCR.add(sscr);
                    }
                }
                if (iRecipe instanceof ShapedOreRecipe) {
                    sor = (ShapedOreRecipe)iRecipe;
                    for (Object object : sor.getInput()) {
                        ItemStack compared = null;
                        if (object instanceof ItemStack && (compared = (ItemStack)object).func_77969_a(is)) {
                            lstCR.add(sor);
                        }
                        if (object instanceof Item && (compared = new ItemStack((Item)object, 1, 0)).func_77969_a(is)) {
                            lstCR.add(sor);
                        }
                        if (object instanceof Block && (compared = new ItemStack((Block)object, 1, 0)).func_77969_a(is)) {
                            lstCR.add(sor);
                        }
                        if (object instanceof ItemStack[]) {
                            for (ItemStack s : (ItemStack[])object) {
                                if (!s.func_77969_a(is)) continue;
                                lstCR.add(sor);
                            }
                        }
                        if (object instanceof String) {
                            ArrayList isLst = OreDictionary.getOres((String)((String)object));
                            for (ItemStack s : isLst) {
                                if (!s.func_77969_a(is)) continue;
                                lstCR.add(sor);
                            }
                        }
                        if (!(object instanceof List)) continue;
                        List isLst2 = (List)object;
                        for (ItemStack s : isLst2) {
                            if (!s.func_77969_a(is)) continue;
                            lstCR.add(sor);
                        }
                    }
                }
                if (!(iRecipe instanceof ShapelessOreRecipe)) continue;
                sor = (ShapelessOreRecipe)iRecipe;
                for (Object o : sor.getInput()) {
                    ItemStack compared = null;
                    if (o instanceof ItemStack && (compared = (ItemStack)o).func_77969_a(is)) {
                        lstCR.add(sor);
                    }
                    if (o instanceof Item && (compared = new ItemStack((Item)o, 1, 0)).func_77969_a(is)) {
                        lstCR.add(sor);
                    }
                    if (o instanceof Block && (compared = new ItemStack((Block)o, 1, 0)).func_77969_a(is)) {
                        lstCR.add(sor);
                    }
                    if (o instanceof ItemStack[]) {
                        for (ItemStack s : (ItemStack[])o) {
                            if (!s.func_77969_a(is)) continue;
                            lstCR.add(sor);
                        }
                    }
                    if (o instanceof String) {
                        ArrayList arrayList = OreDictionary.getOres((String)((String)o));
                        for (ItemStack s : arrayList) {
                            if (!s.func_77969_a(is)) continue;
                            lstCR.add(sor);
                        }
                    }
                    if (!(o instanceof List)) continue;
                    List list = (List)o;
                    for (ItemStack s : list) {
                        if (!s.func_77969_a(is)) continue;
                        lstCR.add(sor);
                    }
                }
            }
            for (IRecipe iRecipe : lstMA) {
                if (this.actualRecipes.contains(iRecipe)) continue;
                this.actualRecipes.add(iRecipe);
                this.allRecipes.add(iRecipe.func_77571_b());
            }
            for (IRecipe iRecipe : lstCR) {
                if (this.actualRecipes.contains(iRecipe)) continue;
                this.actualRecipes.add(iRecipe);
                this.allRecipes.add(iRecipe.func_77571_b());
            }
            for (RadiatingChamberRecipe radiatingChamberRecipe : lstRC) {
                this.actualRecipes.add(radiatingChamberRecipe);
                this.allRecipes.add(radiatingChamberRecipe.result);
            }
            for (MagicianTableRecipe magicianTableRecipe : lstMT) {
                this.actualRecipes.add(magicianTableRecipe);
                this.allRecipes.add(magicianTableRecipe.result);
            }
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{0};
    }
}

