/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import DummyCore.Utils.MathUtils;
import ec3.api.IHotBlock;
import ec3.common.item.ItemsCore;
import ec3.common.mod.EssentialCraftCore;
import ec3.common.tile.TileMRUGeneric;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.ForgeDirection;

public class TileHeatGenerator
extends TileMRUGeneric {
    public int currentBurnTime;
    public int currentMaxBurnTime;
    public static float cfgMaxMRU = 10000.0f;
    public static float cfgBalance = -1.0f;
    public static float mruGenerated = 20.0f;

    public TileHeatGenerator() {
        this.balance = cfgBalance;
        this.maxMRU = (int)cfgMaxMRU;
        this.setSlotsNum(2);
    }

    public boolean canGenerateMRU() {
        return false;
    }

    @Override
    public void func_145845_h() {
        float mruGen = mruGenerated;
        super.func_145845_h();
        if (this.balance == -1.0f) {
            this.balance = this.field_145850_b.field_73012_v.nextFloat() * 2.0f;
        }
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            if (this.currentBurnTime > 0) {
                --this.currentBurnTime;
                if (!this.field_145850_b.field_72995_K) {
                    float mruFactor = 1.0f;
                    Block[] b = new Block[]{this.field_145850_b.func_147439_a(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e), this.field_145850_b.func_147439_a(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e), this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2), this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2)};
                    int[] ox = new int[]{2, -2, 0, 0};
                    int[] oz = new int[]{0, 0, 2, -2};
                    for (int i = 0; i < 4; ++i) {
                        if (b[i] == Blocks.field_150350_a) {
                            mruFactor *= 0.0f;
                            continue;
                        }
                        if (b[i] == Blocks.field_150424_aL) {
                            mruFactor *= 0.75f;
                            continue;
                        }
                        if (b[i] == Blocks.field_150353_l) {
                            mruFactor *= 0.95f;
                            continue;
                        }
                        if (b[i] == Blocks.field_150480_ab) {
                            mruFactor *= 0.7f;
                            continue;
                        }
                        if (b[i] instanceof IHotBlock) {
                            mruFactor *= ((IHotBlock)b[i]).getHeatModifier(this.func_145831_w(), this.field_145851_c + ox[i], this.field_145848_d, this.field_145849_e + oz[i]);
                            continue;
                        }
                        mruFactor *= 0.5f;
                    }
                    if ((mruGen *= mruFactor) >= 1.0f) {
                        this.setMRU((int)((float)this.getMRU() + mruGen));
                        if (this.getMRU() > this.getMaxMRU()) {
                            this.setMRU(this.getMaxMRU());
                        }
                    }
                }
            }
            if (!this.field_145850_b.field_72995_K && this.func_70301_a(0) != null && this.currentBurnTime == 0 && this.getMRU() < this.getMaxMRU()) {
                this.currentMaxBurnTime = this.currentBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.func_70301_a(0));
                if (this.currentBurnTime > 0 && this.func_70301_a(0) != null) {
                    if (this.func_70301_a(1) == null || this.func_70301_a((int)1).field_77994_a < this.func_70297_j_()) {
                        if (this.func_70301_a(1) != null && this.func_70301_a(1).func_77973_b() == ItemsCore.magicalSlag) {
                            ItemStack stk = this.func_70301_a(1);
                            ++stk.field_77994_a;
                            this.func_70299_a(1, stk);
                        }
                        if (this.func_70301_a(1) == null) {
                            ItemStack stk = new ItemStack(ItemsCore.magicalSlag, 1, 0);
                            this.func_70299_a(1, stk);
                        }
                    }
                    if (this.func_70301_a((int)0).field_77994_a == 0) {
                        this.func_70299_a(0, this.func_70301_a(0).func_77973_b().getContainerItem(this.func_70301_a(0)));
                    }
                    this.func_70298_a(0, 1);
                }
            }
        }
        for (int i = 2; i < 6; ++i) {
            ForgeDirection rotation = ForgeDirection.VALID_DIRECTIONS[i];
            float rotXAdv = (float)rotation.offsetX - 0.5f;
            float rotZAdv = (float)rotation.offsetZ - 0.5f;
            EssentialCraftCore.proxy.FlameFX((float)this.field_145851_c + 0.725f + rotXAdv / 2.2f, (float)this.field_145848_d + 0.4f, (float)this.field_145849_e + 0.725f + rotZAdv / 2.2f, 0.0, 0.0, 0.0, 0.8, 0.5, 0.5, 0.5);
            EssentialCraftCore.proxy.FlameFX((float)this.field_145851_c + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 0.2f, (float)this.field_145848_d + 0.65f, (float)this.field_145849_e + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 0.2f, 0.0, 0.01f, 0.0, 0.8, 0.5, 0.5, 1.0);
        }
        EssentialCraftCore.proxy.SmokeFX((float)this.field_145851_c + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 0.05f, (float)this.field_145848_d + 0.8f, (float)this.field_145849_e + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 0.05f, 0.0, 0.0, 0.0, 1.0);
    }

    @Override
    public void func_145839_a(NBTTagCompound i) {
        this.currentBurnTime = i.func_74762_e("burn");
        this.currentMaxBurnTime = i.func_74762_e("burnMax");
        super.func_145839_a(i);
    }

    @Override
    public void func_145841_b(NBTTagCompound i) {
        i.func_74768_a("burn", this.currentBurnTime);
        i.func_74768_a("burnMax", this.currentMaxBurnTime);
        super.func_145841_b(i);
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("HeatGeneratorSettings", "tileentities", new String[]{"Max MRU:10000.0", "Default balance(-1 is random):-1.0", "Max MRU generated per tick:20"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            cfgBalance = Float.parseFloat(data[1].fieldValue);
            mruGenerated = Float.parseFloat(data[2].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{1};
    }
}

