/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.Coord3D;
import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import DummyCore.Utils.MathUtils;
import ec3.common.mod.EssentialCraftCore;
import ec3.common.tile.TileMRUGeneric;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;

public class TileFlowerBurner
extends TileMRUGeneric {
    public Coord3D burnedFlower;
    public int burnTime = 0;
    public static float cfgMaxMRU = 10000.0f;
    public static float cfgBalance = -1.0f;
    public static float mruGenerated = 10.0f;
    public static int flowerBurnTime = 600;
    public static int saplingBurnTime = 900;
    public static int tallgrassBurnTime = 150;
    public static boolean createDeadBush = true;

    public TileFlowerBurner() {
        this.balance = cfgBalance;
        this.maxMRU = (int)cfgMaxMRU;
    }

    public boolean canGenerateMRU() {
        return false;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.balance == -1.0f) {
            this.balance = this.field_145850_b.field_73012_v.nextFloat() * 2.0f;
        }
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            if (!this.field_145850_b.field_72995_K) {
                if (this.burnedFlower == null && this.getMRU() < this.getMaxMRU()) {
                    int offsetX = (int)(MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) * 8.0);
                    int offsetZ = (int)(MathUtils.randomDouble((Random)this.field_145850_b.field_73012_v) * 8.0);
                    Block b = this.field_145850_b.func_147439_a(this.field_145851_c + offsetX, this.field_145848_d, this.field_145849_e + offsetZ);
                    int[] ids = OreDictionary.getOreIDs((ItemStack)new ItemStack(b, 1, 0));
                    String name = "";
                    if (ids != null && ids.length > 0) {
                        for (int i = 0; i < ids.length; ++i) {
                            int oreDictID = ids[i];
                            String n = OreDictionary.getOreName((int)oreDictID);
                            if (n == null || n.isEmpty()) continue;
                            name = n;
                            break;
                        }
                    }
                    if (name.toLowerCase().contains("flower") || b instanceof BlockFlower) {
                        this.burnedFlower = new Coord3D((float)(this.field_145851_c + offsetX), (float)this.field_145848_d, (float)(this.field_145849_e + offsetZ));
                        this.burnTime = flowerBurnTime;
                    }
                    if (name.toLowerCase().contains("sapling") || b instanceof BlockSapling) {
                        this.burnedFlower = new Coord3D((float)(this.field_145851_c + offsetX), (float)this.field_145848_d, (float)(this.field_145849_e + offsetZ));
                        this.burnTime = saplingBurnTime;
                    }
                    if (name.toLowerCase().contains("tallgrass") || b instanceof BlockTallGrass) {
                        this.burnedFlower = new Coord3D((float)(this.field_145851_c + offsetX), (float)this.field_145848_d, (float)(this.field_145849_e + offsetZ));
                        this.burnTime = tallgrassBurnTime;
                    }
                } else if (this.burnedFlower != null) {
                    --this.burnTime;
                    this.setMRU((int)((float)this.getMRU() + mruGenerated));
                    if (this.getMRU() > this.getMaxMRU()) {
                        this.setMRU(this.getMaxMRU());
                    }
                    if (this.burnTime <= 0) {
                        if (createDeadBush) {
                            this.field_145850_b.func_147465_d((int)this.burnedFlower.x, (int)this.burnedFlower.y, (int)this.burnedFlower.z, (Block)Blocks.field_150330_I, 0, 3);
                        } else {
                            this.field_145850_b.func_147465_d((int)this.burnedFlower.x, (int)this.burnedFlower.y, (int)this.burnedFlower.z, Blocks.field_150350_a, 0, 3);
                        }
                        this.burnedFlower = null;
                    }
                }
            }
            if (this.burnedFlower != null && this.burnTime > 0) {
                this.field_145850_b.func_72869_a("flame", (double)(this.burnedFlower.x + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 0.3f), (double)(this.burnedFlower.y + 0.1f + this.field_145850_b.field_73012_v.nextFloat() / 2.0f), (double)(this.burnedFlower.z + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 0.3f), 0.0, 0.0, 0.0);
                --this.burnTime;
                if (this.burnTime <= 0) {
                    for (int t = 0; t < 200; ++t) {
                        EssentialCraftCore.proxy.SmokeFX(this.burnedFlower.x + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 0.3f, this.burnedFlower.y + 0.1f + this.field_145850_b.field_73012_v.nextFloat() / 2.0f, this.burnedFlower.z + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 0.3f, 0.0, 0.0, 0.0, 1.0);
                    }
                }
            }
        }
        EssentialCraftCore.proxy.FlameFX((float)this.field_145851_c + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 0.4f, (float)this.field_145848_d + 0.1f, (float)this.field_145849_e + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 0.4f, 0.0, 0.01f, 0.0, 1.0, 0.5, 1.0, 1.0);
        EssentialCraftCore.proxy.FlameFX((float)this.field_145851_c + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 0.2f, (float)this.field_145848_d + 0.2f, (float)this.field_145849_e + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 0.2f, 0.0, 0.01f, 0.0, 1.0, 0.5, 1.0, 1.0);
        for (int i = 0; i < 10; ++i) {
            EssentialCraftCore.proxy.SmokeFX((float)this.field_145851_c + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 0.1f, (float)this.field_145848_d + 0.6f, (float)this.field_145849_e + 0.5f + MathUtils.randomFloat((Random)this.field_145850_b.field_73012_v) * 0.1f, 0.0, 0.0, 0.0, 1.0);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound i) {
        if (i.func_74764_b("coord")) {
            DummyData[] coordData = DataStorage.parseData((String)i.func_74779_i("coord"));
            this.burnedFlower = new Coord3D(Double.parseDouble(coordData[0].fieldValue), Double.parseDouble(coordData[1].fieldValue), Double.parseDouble(coordData[2].fieldValue));
        }
        this.burnTime = i.func_74762_e("burn");
        super.func_145839_a(i);
    }

    @Override
    public void func_145841_b(NBTTagCompound i) {
        if (this.burnedFlower != null) {
            i.func_74778_a("coord", this.burnedFlower.toString());
        }
        i.func_74768_a("burn", this.burnTime);
        super.func_145841_b(i);
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("NatureFurnaceSettings", "tileentities", new String[]{"Max MRU:10000.0", "Default balance(-1 is random):-1.0", "MRU generated per tick:10", "Time required to burn a flower:600", "Time required to burn a sapling:900", "Time required to burn grass:150", "Should leave Dead Bushes:true"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            cfgBalance = Float.parseFloat(data[1].fieldValue);
            mruGenerated = Float.parseFloat(data[2].fieldValue);
            flowerBurnTime = Integer.parseInt(data[3].fieldValue);
            saplingBurnTime = Integer.parseInt(data[4].fieldValue);
            tallgrassBurnTime = Integer.parseInt(data[5].fieldValue);
            createDeadBush = Boolean.parseBoolean(data[6].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[0];
    }
}

