/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import DummyCore.Utils.MiscUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class TileElementalCrystal
extends TileEntity {
    public int syncTick;
    public float size;
    public float fire;
    public float water;
    public float earth;
    public float air;
    public static float mutatuinChance = 0.001f;
    public static float growthModifier = 1.0f;

    public void func_145839_a(NBTTagCompound i) {
        super.func_145839_a(i);
        this.size = i.func_74760_g("size");
        this.fire = i.func_74760_g("fire");
        this.water = i.func_74760_g("water");
        this.earth = i.func_74760_g("earth");
        this.air = i.func_74760_g("air");
    }

    public void func_145841_b(NBTTagCompound i) {
        super.func_145841_b(i);
        i.func_74776_a("size", this.size);
        i.func_74776_a("fire", this.fire);
        i.func_74776_a("water", this.water);
        i.func_74776_a("earth", this.earth);
        i.func_74776_a("air", this.air);
    }

    public float getElementByNum(int num) {
        if (num == 0) {
            return this.fire;
        }
        if (num == 1) {
            return this.water;
        }
        if (num == 2) {
            return this.earth;
        }
        if (num == 3) {
            return this.air;
        }
        return -1.0f;
    }

    public void setElementByNum(int num, float amount) {
        if (num == 0) {
            this.fire += amount;
        }
        if (num == 1) {
            this.water += amount;
        }
        if (num == 2) {
            this.earth += amount;
        }
        if (num == 3) {
            this.air += amount;
        }
    }

    public void randomlyMutate() {
        Random r = this.field_145850_b.field_73012_v;
        if (r.nextFloat() <= mutatuinChance) {
            this.mutate(r.nextInt(4), r.nextInt(3) - r.nextInt(3));
        }
    }

    public boolean mutate(int element, int amount) {
        if (this.getElementByNum(element) + (float)amount <= 100.0f && this.getElementByNum(element) + (float)amount >= 0.0f) {
            this.setElementByNum(element, amount);
        }
        return false;
    }

    public int getDominant() {
        if (this.fire > this.water && this.fire > this.earth && this.fire > this.air) {
            return 0;
        }
        if (this.water > this.fire && this.water > this.earth && this.water > this.air) {
            return 1;
        }
        if (this.earth > this.water && this.earth > this.fire && this.earth > this.air) {
            return 2;
        }
        if (this.air > this.fire && this.air > this.earth && this.air > this.water) {
            return 3;
        }
        return -1;
    }

    public void func_145845_h() {
        Block b;
        int metadata = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (metadata == 1 && !(b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)).func_149747_d((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, 0)) {
            this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_149697_b(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 0);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (metadata == 0 && !(b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)).func_149747_d((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, 1)) {
            this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_149697_b(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 0);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (metadata == 2 && !(b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)).func_149747_d((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, 3)) {
            this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_149697_b(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 0);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (metadata == 3 && !(b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)).func_149747_d((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, 2)) {
            this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_149697_b(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 0);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (metadata == 4 && !(b = this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)).func_149747_d((IBlockAccess)this.field_145850_b, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, 5)) {
            this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_149697_b(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 0);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (metadata == 5 && !(b = this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)).func_149747_d((IBlockAccess)this.field_145850_b, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, 4)) {
            this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_149697_b(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, metadata, 0);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.size < 100.0f) {
            this.field_145850_b.func_72869_a("enchantmenttable", (double)((float)this.field_145851_c + this.field_145850_b.field_73012_v.nextFloat()), (double)(this.field_145848_d + 1), (double)((float)this.field_145849_e + this.field_145850_b.field_73012_v.nextFloat()), 0.0, 0.0, 0.0);
            if (!this.field_145850_b.field_72995_K) {
                this.size += 0.002f * growthModifier;
                this.randomlyMutate();
            }
        }
        if (this.syncTick == 0) {
            if (!this.field_145850_b.field_72995_K) {
                MiscUtils.sendPacketToAllAround((World)this.field_145850_b, (Packet)this.func_145844_m(), (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (int)this.field_145850_b.field_73011_w.field_76574_g, (double)128.0);
            }
            this.syncTick = 10;
        } else {
            --this.syncTick;
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -10, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        if (net.func_150729_e() instanceof INetHandlerPlayClient && pkt.func_148853_f() == -10) {
            this.func_145839_a(pkt.func_148857_g());
        }
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("ElementalCrystalSettings", "tileentities", new String[]{"Chance to mutate per tick:0.001", "Growth per tick modifier(crystal grows at 0.2% per tick):1.0"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            mutatuinChance = Float.parseFloat(data[0].fieldValue);
            growthModifier = Float.parseFloat(data[1].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }
}

