/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import DummyCore.Utils.MiscUtils;
import ec3.common.block.BlocksCore;
import ec3.common.tile.TileMRUGeneric;
import ec3.utils.common.ECUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;

public class TileCrystalFormer
extends TileMRUGeneric {
    public int progressLevel;
    public static float cfgMaxMRU = 5000.0f;
    public static int mruUsage = 100;
    public static int requiredTime = 1000;
    public static boolean generatesCorruption = true;
    public static int genCorruption = 2;

    public TileCrystalFormer() {
        this.maxMRU = (int)cfgMaxMRU;
        this.setSlotsNum(8);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        ECUtils.manage(this, 0);
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.doWork();
        }
        this.spawnParticles();
    }

    public void doWork() {
        if (this.canWork() && this.getMRU() > mruUsage && !this.field_145850_b.field_72995_K) {
            if (this.setMRU(this.getMRU() - mruUsage)) {
                ++this.progressLevel;
            }
            if (generatesCorruption) {
                ECUtils.increaseCorruptionAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v.nextInt(genCorruption));
            }
            if (this.progressLevel >= requiredTime) {
                this.progressLevel = 0;
                this.createItem();
            }
        }
    }

    public void createItem() {
        ItemStack b = new ItemStack(Items.field_151133_ar, 1, 0);
        this.func_70299_a(2, b);
        this.func_70299_a(3, b);
        this.func_70299_a(4, b);
        this.func_70298_a(5, 1);
        this.func_70298_a(6, 1);
        this.func_70298_a(7, 1);
        ItemStack crystal = new ItemStack(BlocksCore.elementalCrystal, 1, 0);
        MiscUtils.getStackTag((ItemStack)crystal).func_74776_a("size", 1.0f);
        MiscUtils.getStackTag((ItemStack)crystal).func_74776_a("fire", 0.0f);
        MiscUtils.getStackTag((ItemStack)crystal).func_74776_a("water", 0.0f);
        MiscUtils.getStackTag((ItemStack)crystal).func_74776_a("earth", 0.0f);
        MiscUtils.getStackTag((ItemStack)crystal).func_74776_a("air", 0.0f);
        this.func_70299_a(1, crystal);
    }

    public boolean canWork() {
        ItemStack[] s = new ItemStack[7];
        for (int i = 1; i < 8; ++i) {
            s[i - 1] = this.func_70301_a(i);
        }
        return s[0] == null && s[1] != null && s[2] != null && s[3] != null && s[4] != null && s[5] != null && s[6] != null && s[1].func_77973_b() == Items.field_151131_as && s[2].func_77973_b() == Items.field_151131_as && s[3].func_77973_b() == Items.field_151131_as && this.isGlassBlock(s[4]) && this.isGlassBlock(s[5]) && s[6].func_77973_b() == Items.field_151045_i;
    }

    public boolean isGlassBlock(ItemStack is) {
        if (is == null) {
            return false;
        }
        if (is.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150359_w) || is.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150399_cn)) {
            return true;
        }
        if (OreDictionary.getOreIDs((ItemStack)is) != null && OreDictionary.getOreIDs((ItemStack)is).length > 0) {
            for (int i = 0; i < OreDictionary.getOreIDs((ItemStack)is).length; ++i) {
                String name = OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)is)[i]);
                if (!name.equals("blockGlass")) continue;
                return true;
            }
        }
        return false;
    }

    public void spawnParticles() {
        if (this.canWork() && this.getMRU() > 0) {
            for (int o = 0; o < 10; ++o) {
                this.field_145850_b.func_72869_a("reddust", (double)this.field_145851_c + 0.1 + this.field_145850_b.field_73012_v.nextDouble() / 1.1, (double)((float)this.field_145848_d + (float)o / 10.0f), (double)this.field_145849_e + 0.1 + this.field_145850_b.field_73012_v.nextDouble() / 1.1, -1.0, 1.0, 1.0);
            }
        }
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("CrystalFormerSettings", "tileentities", new String[]{"Max MRU:5000.0", "MRU Usage:100", "Ticks required to create a crystal:1000", "Can this device actually generate corruption:true", "The amount of corruption generated each tick(do not set to 0!):2"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            mruUsage = Integer.parseInt(data[1].fieldValue);
            requiredTime = Integer.parseInt(data[2].fieldValue);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            generatesCorruption = Boolean.parseBoolean(data[3].fieldValue);
            genCorruption = Integer.parseInt(data[4].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{1};
    }
}

