/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import ec3.common.item.ItemEssence;
import ec3.common.item.ItemsCore;
import ec3.common.tile.TileElementalCrystal;
import ec3.common.tile.TileMRUGeneric;
import ec3.utils.common.ECUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.config.Configuration;

public class TileCrystalExtractor
extends TileMRUGeneric {
    public int progressLevel;
    public static float cfgMaxMRU = 5000.0f;
    public static int mruUsage = 100;
    public static int requiredTime = 1000;

    public TileCrystalExtractor() {
        this.maxMRU = (int)cfgMaxMRU;
        this.setSlotsNum(13);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        ECUtils.manage(this, 0);
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.doWork();
        }
        this.spawnParticles();
    }

    public void doWork() {
        if (this.canWork() && this.getMRU() > mruUsage && !this.field_145850_b.field_72995_K) {
            if (this.setMRU(this.getMRU() - mruUsage)) {
                ++this.progressLevel;
            }
            if (this.progressLevel >= requiredTime) {
                this.progressLevel = 0;
                this.createItems();
            }
        }
    }

    public void createItems() {
        int i;
        TileElementalCrystal t = this.getCrystal();
        float f = t.fire;
        float w = t.water;
        float e = t.earth;
        float a = t.air;
        float s = t.size * 3000.0f;
        float[] baseChance = new float[]{f, w, e, a};
        int[] essenceChance = new int[]{37500, 50000, 75000, 150000};
        int[] getChance = new int[16];
        for (i = 0; i < 16; ++i) {
            getChance[i] = (int)(s * baseChance[ItemEssence.convertDamageToIntBefore4(i)] / (float)essenceChance[i / 4]);
        }
        if (!this.field_145850_b.field_72995_K) {
            for (i = 1; i < 13; ++i) {
                int sts;
                ItemStack st = new ItemStack(ItemsCore.essence, 1, this.field_145850_b.field_73012_v.nextInt(16));
                if (this.field_145850_b.field_73012_v.nextInt(100) >= getChance[st.func_77960_j()]) continue;
                st.field_77994_a = sts = this.field_145850_b.field_73012_v.nextInt(1 + getChance[st.func_77960_j()] / 4);
                if (st.field_77994_a <= 0) {
                    st.field_77994_a = 1;
                }
                this.func_70299_a(i, st);
            }
        }
    }

    public boolean canWork() {
        for (int i = 1; i < 13; ++i) {
            if (this.func_70301_a(i) == null) continue;
            return false;
        }
        return this.getCrystal() != null;
    }

    public boolean hasItemInSlots() {
        for (int i = 1; i < 13; ++i) {
            if (this.func_70301_a(i) == null) continue;
            return true;
        }
        return false;
    }

    public void spawnParticles() {
        TileElementalCrystal t;
        if (this.canWork() && this.getMRU() > 0 && (t = this.getCrystal()) != null) {
            for (int o = 0; o < 10; ++o) {
                this.field_145850_b.func_72869_a("portal", (double)this.field_145851_c + this.field_145850_b.field_73012_v.nextDouble(), (double)t.field_145848_d + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_145849_e + this.field_145850_b.field_73012_v.nextDouble(), (double)(t.field_145851_c - this.field_145851_c), 0.0, (double)(t.field_145849_e - this.field_145849_e));
            }
        }
    }

    public TileElementalCrystal getCrystal() {
        TileElementalCrystal t = null;
        if (this.hasCrystalOnFront()) {
            t = (TileElementalCrystal)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
        }
        if (this.hasCrystalOnBack()) {
            t = (TileElementalCrystal)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
        }
        if (this.hasCrystalOnLeft()) {
            t = (TileElementalCrystal)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
        }
        if (this.hasCrystalOnRight()) {
            t = (TileElementalCrystal)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
        }
        return t;
    }

    public boolean hasCrystalOnFront() {
        TileEntity t = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
        return t != null && t instanceof TileElementalCrystal;
    }

    public boolean hasCrystalOnBack() {
        TileEntity t = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
        return t != null && t instanceof TileElementalCrystal;
    }

    public boolean hasCrystalOnLeft() {
        TileEntity t = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
        return t != null && t instanceof TileElementalCrystal;
    }

    public boolean hasCrystalOnRight() {
        TileEntity t = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
        return t != null && t instanceof TileElementalCrystal;
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("CrystalExtractorSettings", "tileentities", new String[]{"Max MRU:5000.0", "MRU Usage:100", "Ticks required to get an essence:1000"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            mruUsage = Integer.parseInt(data[1].fieldValue);
            requiredTime = Integer.parseInt(data[2].fieldValue);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
    }
}

