/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.tile;

import DummyCore.Utils.DataStorage;
import DummyCore.Utils.DummyData;
import ec3.common.item.ItemEssence;
import ec3.common.tile.TileElementalCrystal;
import ec3.common.tile.TileMRUGeneric;
import ec3.utils.common.ECUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.config.Configuration;

public class TileCrystalController
extends TileMRUGeneric {
    public static float cfgMaxMRU = 5000.0f;
    public static int mruUsage = 100;
    public static int chanceToUseMRU = 20;
    public static float mutateModifier = 0.001f;

    public TileCrystalController() {
        this.maxMRU = (int)cfgMaxMRU;
        this.setSlotsNum(2);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        ECUtils.manage(this, 0);
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) && !this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextInt(chanceToUseMRU) == 0 && this.getMRU() >= mruUsage) {
            this.setMRU(this.getMRU() - mruUsage);
        }
        this.spawnParticles();
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.mutateToElement();
        }
    }

    public void spawnParticles() {
        if (this.getMRU() > 0 && this.getCrystal() != null) {
            for (int o = 0; o < 2; ++o) {
                this.field_145850_b.func_72869_a("reddust", (double)this.field_145851_c + 0.3 + this.field_145850_b.field_73012_v.nextDouble() / 2.0, (double)((float)this.field_145848_d + 0.3f + (float)o / 2.0f), (double)this.field_145849_e + 0.3 + this.field_145850_b.field_73012_v.nextDouble() / 2.0, -1.0, 1.0, 0.0);
            }
        }
    }

    public void mutateToElement() {
        if (this.func_70301_a(1) != null && this.func_70301_a(1).func_77973_b() instanceof ItemEssence && this.getMRU() > 500 && !this.field_145850_b.field_72995_K && this.getCrystal() != null && this.getCrystal().size < 100.0f) {
            ItemStack e = this.func_70301_a(1);
            TileElementalCrystal c = this.getCrystal();
            int rarity = (int)((float)e.func_77960_j() / 4.0f);
            float chance = mutateModifier * (float)(rarity + 1);
            if (this.field_145850_b.field_73012_v.nextFloat() <= chance) {
                int type = ItemEssence.convertDamageToIntBefore4(e.func_77960_j());
                c.mutate(type, this.field_145850_b.field_73012_v.nextInt((rarity + 1) * 2));
                this.func_70298_a(1, 1);
                this.setMRU(this.getMRU() - mruUsage * 10);
            }
        }
    }

    public TileElementalCrystal getCrystal() {
        TileElementalCrystal t = null;
        if (this.hasCrystalOnFront()) {
            t = (TileElementalCrystal)this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
        }
        if (this.hasCrystalOnBack()) {
            t = (TileElementalCrystal)this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
        }
        if (this.hasCrystalOnLeft()) {
            t = (TileElementalCrystal)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
        }
        if (this.hasCrystalOnRight()) {
            t = (TileElementalCrystal)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
        }
        return t;
    }

    public boolean hasCrystalOnFront() {
        TileEntity t = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
        return t != null && t instanceof TileElementalCrystal;
    }

    public boolean hasCrystalOnBack() {
        TileEntity t = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
        return t != null && t instanceof TileElementalCrystal;
    }

    public boolean hasCrystalOnLeft() {
        TileEntity t = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
        return t != null && t instanceof TileElementalCrystal;
    }

    public boolean hasCrystalOnRight() {
        TileEntity t = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
        return t != null && t instanceof TileElementalCrystal;
    }

    public static void setupConfig(Configuration cfg) {
        try {
            cfg.load();
            String[] cfgArrayString = cfg.getStringList("CrystalControllerSettings", "tileentities", new String[]{"Max MRU:5000.0", "MRU Usage:100", "Chance to NOT use MRU(do not set to 0!):20", "Crystal mutation chance modifier:0.001"}, "");
            String dataString = "";
            for (int i = 0; i < cfgArrayString.length; ++i) {
                dataString = dataString + "||" + cfgArrayString[i];
            }
            DummyData[] data = DataStorage.parseData((String)dataString);
            mutateModifier = Float.parseFloat(data[3].fieldValue);
            mruUsage = Integer.parseInt(data[1].fieldValue);
            chanceToUseMRU = Integer.parseInt(data[2].fieldValue);
            cfgMaxMRU = Float.parseFloat(data[0].fieldValue);
            cfg.save();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public int[] getOutputSlots() {
        return new int[]{0};
    }
}

