/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.item;

import DummyCore.Utils.MathUtils;
import baubles.api.BaubleType;
import baubles.api.IBauble;
import ec3.api.IItemRequiresMRU;
import ec3.api.IMRUStorage;
import ec3.utils.common.ECUtils;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemMRUStorageNBTTag
extends Item
implements IMRUStorage,
IItemRequiresMRU,
IBauble {
    int[] maxMRU = new int[5];
    IIcon[] field_77791_bV = new IIcon[5];
    int[] colors = new int[]{0x555555, 0x665555, 0x775555, 0x885555, 0x995555, 0xAA5555, 0xBB5555, 0xCC5555, 0xDD5555, 0xEE6666, 0xFF6666};
    public static String[] dropNames = new String[]{"SoulShard", "SoulSphere", "DarkSoulMatter", "RedSoulMatter", "MatterOfEthernity"};

    public ItemMRUStorageNBTTag(int[] maxMRU) {
        this.maxMRU = maxMRU;
        this.func_77625_d(1);
    }

    @Override
    public boolean setMRU(ItemStack stack, int amount) {
        if (ECUtils.getStackTag(stack).func_74762_e("mru") + amount >= 0 && ECUtils.getStackTag(stack).func_74762_e("mru") + amount <= ECUtils.getStackTag(stack).func_74762_e("maxMRU")) {
            ECUtils.getStackTag(stack).func_74768_a("mru", ECUtils.getStackTag(stack).func_74762_e("mru") + amount);
            return true;
        }
        return false;
    }

    @Override
    public int getMRU(ItemStack stack) {
        return ECUtils.getStackTag(stack).func_74762_e("mru");
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int indexInInventory, boolean isCurrentItem) {
        ECUtils.initMRUTag(itemStack, this.maxMRU[itemStack.func_77960_j()]);
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(ECUtils.getStackTag(par1ItemStack).func_74762_e("mru") + "/" + ECUtils.getStackTag(par1ItemStack).func_74762_e("maxMRU") + " MRU");
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int var4 = 0; var4 < 5; ++var4) {
            ItemStack min = new ItemStack(par1, 1, var4);
            ECUtils.initMRUTag(min, this.getMaxMRU(min));
            ItemStack max = new ItemStack(par1, 1, var4);
            ECUtils.initMRUTag(max, this.getMaxMRU(max));
            ECUtils.getStackTag(max).func_74768_a("mru", ECUtils.getStackTag(max).func_74762_e("maxMRU"));
            par3List.add(min);
            par3List.add(max);
        }
    }

    public IIcon func_77617_a(int par1) {
        return this.field_77791_bV[par1];
    }

    public String func_77667_c(ItemStack p_77667_1_) {
        return this.func_77658_a() + dropNames[p_77667_1_.func_77960_j()];
    }

    public void func_94581_a(IIconRegister par1IconRegister) {
        this.field_77791_bV[0] = par1IconRegister.func_94245_a("essentialcraft:storages/soulShard");
        this.field_77791_bV[1] = par1IconRegister.func_94245_a("essentialcraft:storages/soulSphere");
        this.field_77791_bV[2] = par1IconRegister.func_94245_a("essentialcraft:storages/darkSoulMatter");
        this.field_77791_bV[3] = par1IconRegister.func_94245_a("essentialcraft:storages/redSoulMatter");
        this.field_77791_bV[4] = par1IconRegister.func_94245_a("essentialcraft:storages/eternityMatter");
    }

    @Override
    public int getMaxMRU(ItemStack stack) {
        int dam = stack.func_77960_j();
        return this.maxMRU[dam];
    }

    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        int dam = par1ItemStack.func_77960_j();
        if (dam != -1) {
            int currentMRU = ((IMRUStorage)par1ItemStack.func_77973_b()).getMRU(par1ItemStack);
            int maxMRU = ((IMRUStorage)par1ItemStack.func_77973_b()).getMaxMRU(par1ItemStack);
            int percentage = MathUtils.getPercentage((int)currentMRU, (int)maxMRU);
            return this.colors[percentage /= 10];
        }
        return 0xFFFFFF;
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.RING;
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }
}

