/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.item;

import DummyCore.Utils.MiscUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ec3.common.item.ItemStoresMRUInNBT;
import ec3.utils.common.ECUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class ItemBiomeWand
extends ItemStoresMRUInNBT {
    public ItemBiomeWand() {
        this.setMaxMRU(5000);
        this.field_77777_bU = 1;
        this.field_77789_bW = true;
    }

    public static boolean isBiomeSaved(ItemStack stack) {
        NBTTagCompound tag = MiscUtils.getStackTag((ItemStack)stack);
        return tag.func_74764_b("biome");
    }

    public static int getBiomeID(ItemStack stack) {
        NBTTagCompound tag = MiscUtils.getStackTag((ItemStack)stack);
        if (ItemBiomeWand.isBiomeSaved(stack)) {
            return tag.func_74762_e("biome");
        }
        return -1;
    }

    public static void setBiomeID(ItemStack stack, int bID, boolean remove) {
        NBTTagCompound tag = MiscUtils.getStackTag((ItemStack)stack);
        if (remove) {
            tag.func_82580_o("biome");
            return;
        }
        tag.func_74768_a("biome", bID);
        stack.func_77982_d(tag);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int px, int y, int pz, int side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af()) {
            if (ItemBiomeWand.isBiomeSaved(stack)) {
                if (ECUtils.tryToDecreaseMRUInStorage(player, -100) || this.setMRU(stack, -100)) {
                    for (int x = px - 1; x <= px + 1; ++x) {
                        for (int z = pz - 1; z <= pz + 1; ++z) {
                            MiscUtils.changeBiome((World)world, (BiomeGenBase)BiomeGenBase.func_150568_d((int)ItemBiomeWand.getBiomeID(stack)), (int)x, (int)z);
                            player.func_71038_i();
                        }
                    }
                }
            } else {
                int cbiome = world.func_72807_a((int)px, (int)pz).field_76756_M;
                ItemBiomeWand.setBiomeID(stack, cbiome, false);
                player.func_71038_i();
            }
        } else {
            ItemBiomeWand.setBiomeID(stack, 0, true);
            player.func_71038_i();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        if (ItemBiomeWand.isBiomeSaved(par1ItemStack)) {
            return BiomeGenBase.func_150568_d((int)ItemBiomeWand.getBiomeID((ItemStack)par1ItemStack)).field_76790_z;
        }
        return 65535;
    }
}

