/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.item;

import DummyCore.Utils.DCASMCheck;
import DummyCore.Utils.ExistanceCheck;
import DummyCore.Utils.MiscUtils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ec3.api.IItemRequiresMRU;
import ec3.common.item.ItemsCore;
import ec3.common.mod.EssentialCraftCore;
import ec3.utils.common.ECUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.ISpecialArmor;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.IGoggles;
import thaumcraft.api.IRepairable;
import thaumcraft.api.IVisDiscountGear;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.nodes.IRevealer;

@DCASMCheck
@ExistanceCheck(classPath={"thaumcraft.api.IRepairable", "thaumcraft.api.IVisDiscountGear", "thaumcraft.api.nodes.IRevealer", "thaumcraft.api.IGoggles"})
public class ItemArmorMod
extends ItemArmor
implements IRepairable,
IVisDiscountGear,
IRevealer,
IGoggles,
ISpecialArmor,
IItemRequiresMRU {
    public String armorTexture;
    public int aType;
    public ItemArmor.ArmorMaterial mat;
    public static int[][] discount = new int[][]{{5, 5, 3, 2}, {8, 10, 7, 5}, {10, 15, 8, 7}, {2, 3, 2, 1}};

    public ItemArmorMod(ItemArmor.ArmorMaterial p_i45325_1_, int p_i45325_2_, int p_i45325_3_, int it) {
        super(p_i45325_1_, p_i45325_2_, p_i45325_3_);
        this.aType = it;
        this.mat = p_i45325_1_;
    }

    public Item setArmorTexture(String path) {
        this.armorTexture = path;
        return this;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        list.add(EnumChatFormatting.DARK_PURPLE + StatCollector.func_74838_a((String)"tc.visdiscount") + ": " + this.getVisDiscount(stack, player, null) + "%");
        if (this.aType == 1) {
            list.add(this.getMRU(stack) + "/" + this.getMaxMRU(stack) + " MRU");
        }
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        HashMultimap mods = HashMultimap.create();
        if (this == ItemsCore.magicArmorItems[5]) {
            mods.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("1bca943c-3cf5-42cc-a3df-2ed994ae0000"), "hp", 20.0, 0));
        }
        if (this == ItemsCore.magicArmorItems[7]) {
            mods.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("1bca943c-3cf5-42cc-a3df-2ed994ae0000"), "movespeed", 0.05, 0));
        }
        if (this == ItemsCore.magicArmorItems[9]) {
            mods.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("1bca943c-3cf5-42cc-a3df-2ed994ae0000"), "hp", 30.0, 0));
        }
        if (this == ItemsCore.magicArmorItems[11]) {
            mods.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("1bca943c-3cf5-42cc-a3df-2ed994ae0000"), "movespeed", 0.1, 0));
        }
        return mods;
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, int slot, String type) {
        switch (slot) {
            case 2: {
                return "essentialcraft:textures/special/models/" + this.armorTexture + "_1.png";
            }
        }
        return "essentialcraft:textures/special/models/" + this.armorTexture + "_0.png";
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        if (this.aType != 1) {
            super.func_150895_a(par1, par2CreativeTabs, par3List);
        } else {
            for (int var4 = 0; var4 < 1; ++var4) {
                ItemStack min = new ItemStack(par1, 1, 0);
                ECUtils.initMRUTag(min, 5000);
                ItemStack max = new ItemStack(par1, 1, 0);
                ECUtils.initMRUTag(max, 5000);
                ECUtils.getStackTag(max).func_74768_a("mru", 5000);
                par3List.add(min);
                par3List.add(max);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        ModelBiped armorModel = null;
        if (itemStack != null) {
            if (itemStack.func_77973_b() instanceof ItemArmorMod) {
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                int type = ((ItemArmor)itemStack.func_77973_b()).field_77881_a;
                armorModel = type == 3 ? (ModelBiped)EssentialCraftCore.proxy.getClientModel(0) : (type == 1 ? (ModelBiped)EssentialCraftCore.proxy.getClientModel(2) : (ModelBiped)EssentialCraftCore.proxy.getClientModel(1));
            }
            if (armorModel != null) {
                armorModel.field_78116_c.field_78806_j = armorSlot == 0;
                armorModel.field_78114_d.field_78806_j = armorSlot == 0;
                armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
                armorModel.field_78112_f.field_78806_j = armorSlot == 1;
                armorModel.field_78113_g.field_78806_j = armorSlot == 1;
                armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                int n = armorModel.field_78120_m = entityLiving.func_71124_b(0) != null ? 1 : 0;
                if (entityLiving instanceof EntityPlayer) {
                    armorModel.field_78118_o = ((EntityPlayer)entityLiving).func_71057_bx() > 2;
                }
            }
        }
        return armorModel;
    }

    public boolean showIngamePopups(ItemStack itemstack, EntityLivingBase player) {
        int type = ((ItemArmor)itemstack.func_77973_b()).field_77881_a;
        return type == 0;
    }

    public boolean showNodes(ItemStack itemstack, EntityLivingBase player) {
        int type = ((ItemArmor)itemstack.func_77973_b()).field_77881_a;
        return type == 0;
    }

    public int getVisDiscount(ItemStack stack, EntityPlayer player, Aspect aspect) {
        int type = ((ItemArmor)stack.func_77973_b()).field_77881_a;
        return discount[this.aType][type];
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (this.aType != 1) {
            if (!source.func_76363_c()) {
                ItemArmor aarmor = (ItemArmor)armor.func_77973_b();
                return new ISpecialArmor.ArmorProperties(0, (double)aarmor.field_77879_b / 25.0, aarmor.func_77612_l() + 1 - armor.func_77960_j());
            }
            return new ISpecialArmor.ArmorProperties(0, 0.0, armor.func_77958_k() + 1 - armor.func_77960_j());
        }
        int mru = this.getMRU(armor);
        if (mru > 0) {
            ItemArmor aarmor = (ItemArmor)armor.func_77973_b();
            return new ISpecialArmor.ArmorProperties(0, (double)aarmor.field_77879_b / 25.0, aarmor.func_77612_l() + 1 - armor.func_77960_j());
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, armor.func_77958_k() + 1 - armor.func_77960_j());
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return this.mat.func_78044_b(this.field_77881_a);
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        EntityPlayer p;
        if (this.aType != 1) {
            stack.func_77972_a(damage, entity);
        } else if (!(entity instanceof EntityPlayer) || ECUtils.tryToDecreaseMRUInStorage(p = (EntityPlayer)entity, -damage * 1000) || this.setMRU(stack, -damage * 1000)) {
            // empty if block
        }
    }

    @Override
    public boolean setMRU(ItemStack stack, int amount) {
        if (this.getMRU(stack) + amount >= 0 && this.getMRU(stack) + amount <= this.getMaxMRU(stack)) {
            MiscUtils.getStackTag((ItemStack)stack).func_74768_a("mru", MiscUtils.getStackTag((ItemStack)stack).func_74762_e("mru") + amount);
            return true;
        }
        return false;
    }

    @Override
    public int getMRU(ItemStack stack) {
        return MiscUtils.getStackTag((ItemStack)stack).func_74762_e("mru");
    }

    @Override
    public int getMaxMRU(ItemStack stack) {
        return this.aType == 1 ? 5000 : 1;
    }
}

