/*
 * Decompiled with CFR 0.152.
 */
package ec3.common.entity;

import cpw.mods.fml.common.registry.EntityRegistry;
import ec3.common.entity.EntityArmorDestroyer;
import ec3.common.entity.EntityDemon;
import ec3.common.entity.EntityDivider;
import ec3.common.entity.EntityDividerProjectile;
import ec3.common.entity.EntityHologram;
import ec3.common.entity.EntityMRUArrow;
import ec3.common.entity.EntityMRUPresence;
import ec3.common.entity.EntityMRURay;
import ec3.common.entity.EntityOrbitalStrike;
import ec3.common.entity.EntityPlayerClone;
import ec3.common.entity.EntityPoisonFume;
import ec3.common.entity.EntityShadowKnife;
import ec3.common.entity.EntitySolarBeam;
import ec3.common.entity.EntityWindMage;
import ec3.common.mod.EssentialCraftCore;
import ec3.utils.cfg.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class EntitiesCore {
    public static EntitiesCore instance;
    public static final List<Class<? extends Entity>> registeredEntities;
    public static int id;

    public static void registerEntities() {
        EntitiesCore.registerEntity(EntityMRUPresence.class, 64, 1, true);
        EntitiesCore.registerEntity(EntityMRUArrow.class, 64, 1, true);
        EntitiesCore.registerEntity(EntitySolarBeam.class, 64, 1, true);
        EntitiesCore.registerEntity(EntityWindMage.class, 64, 1, true);
        EntitiesCore.registerEntity(EntityPoisonFume.class, 64, 1, true);
        EntitiesCore.registerEntity(EntityShadowKnife.class, 32, 1, true);
        EntitiesCore.registerEntity(EntityMRURay.class, 128, 1, true);
        EntitiesCore.registerEntity(EntityDemon.class, 32, 1, true);
        EntitiesCore.registerEntity(EntityHologram.class, 32, 1, true);
        EntitiesCore.registerEntity(EntityPlayerClone.class, 32, 1, true);
        EntitiesCore.registerEntity(EntityOrbitalStrike.class, 32, 1, true);
        EntitiesCore.registerEntity(EntityDivider.class, 32, 1, true);
        EntitiesCore.registerEntity(EntityArmorDestroyer.class, 32, 1, true);
        EntitiesCore.registerEntity(EntityDividerProjectile.class, 32, 1, true);
        EntityRegistry.addSpawn(EntityWindMage.class, (int)2, (int)1, (int)6, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])EntitiesCore.biomesToSpawn());
        EntityRegistry.addSpawn(EntityPoisonFume.class, (int)100, (int)8, (int)16, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])EntitiesCore.biomesToSpawn());
    }

    public static void registerEntity(Class<? extends Entity> entityClass, int trackingRange, int tickDelay, boolean trackRotation) {
        EntityRegistry.registerModEntity(entityClass, (String)entityClass.getName(), (int)EntitiesCore.nextID(), (Object)EssentialCraftCore.core, (int)trackingRange, (int)tickDelay, (boolean)trackRotation);
        registeredEntities.add(entityClass);
    }

    private static int nextID() {
        return ++id;
    }

    public static int nextEntityID(int defaultID) {
        if (Config.autoFindEID) {
            return defaultID;
        }
        for (int i = defaultID; i < 512; ++i) {
            if (EntityList.func_90035_a((int)i) != null) continue;
            return i;
        }
        return defaultID;
    }

    public static BiomeGenBase[] biomesToSpawn() {
        ArrayList<BiomeGenBase> spawnLst = new ArrayList<BiomeGenBase>();
        for (int i = 0; i < BiomeGenBase.func_150565_n().length; ++i) {
            if (BiomeGenBase.func_150565_n()[i] == null || BiomeGenBase.func_150565_n()[i] == BiomeGenBase.field_76778_j || BiomeGenBase.func_150565_n()[i] == BiomeGenBase.field_76779_k || BiomeGenBase.func_150565_n()[i].func_76747_a(EnumCreatureType.monster) == null || BiomeGenBase.func_150565_n()[i].func_76747_a(EnumCreatureType.monster).isEmpty() || BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150565_n()[i], (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.isBiomeOfType((BiomeGenBase)BiomeGenBase.func_150565_n()[i], (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) continue;
            spawnLst.add(BiomeGenBase.func_150565_n()[i]);
        }
        BiomeGenBase[] biomesArray = new BiomeGenBase[spawnLst.size()];
        for (int i = 0; i < spawnLst.size(); ++i) {
            biomesArray[i] = (BiomeGenBase)spawnLst.get(i);
        }
        return biomesArray;
    }

    static {
        registeredEntities = new ArrayList<Class<? extends Entity>>();
        id = -1;
    }
}

