/*
 * Decompiled with CFR 0.152.
 */
package ec3.api;

import DummyCore.Utils.Notifier;
import DummyCore.Utils.UnformedItemStack;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import ec3.api.MagicianTableRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import net.minecraft.item.ItemStack;

public class MagicianTableRecipes {
    public static final Hashtable<List<UnformedItemStack>, MagicianTableRecipe> recipes = new Hashtable();
    public static final Hashtable<String, MagicianTableRecipe> recipesByIS = new Hashtable();
    public static final List<List<UnformedItemStack>> craftMatrixByID = new ArrayList<List<UnformedItemStack>>();

    public static List<MagicianTableRecipe> getRecipiesByComponent(ItemStack component) {
        ArrayList<MagicianTableRecipe> retLst = new ArrayList<MagicianTableRecipe>();
        for (List<UnformedItemStack> lst : craftMatrixByID) {
            for (UnformedItemStack stk : lst) {
                if (stk == null || component == null || !stk.itemStackMatches(component)) continue;
                retLst.add(recipes.get(lst));
            }
        }
        return retLst;
    }

    public static MagicianTableRecipe getRecipeByResult(ItemStack result) {
        ItemStack search = result.func_77946_l();
        search.field_77994_a = 0;
        String searchStr = search.toString();
        search = null;
        return recipesByIS.get(searchStr);
    }

    public static List<UnformedItemStack> getUnformedStkByItemStacks(ItemStack[] pair) {
        if (pair == null) {
            return new ArrayList<UnformedItemStack>();
        }
        boolean allNull = true;
        for (int i = 0; i < pair.length; ++i) {
            if (pair[i] == null) continue;
            allNull = false;
        }
        if (allNull) {
            return new ArrayList<UnformedItemStack>();
        }
        block1: for (List<UnformedItemStack> lst : craftMatrixByID) {
            if (lst == null) continue;
            for (int i = 0; i < lst.size(); ++i) {
                UnformedItemStack stack = lst.get(i);
                if ((stack != null && !stack.possibleStacks.isEmpty() || pair[i] != null) && stack != null && !stack.itemStackMatches(pair[i])) continue block1;
            }
            return lst;
        }
        return new ArrayList<UnformedItemStack>();
    }

    public static MagicianTableRecipe getRecipeByCP(ItemStack[] craftingPair) {
        List<UnformedItemStack> lst = MagicianTableRecipes.getUnformedStkByItemStacks(craftingPair);
        return recipes.get(lst);
    }

    public static boolean addRecipe(MagicianTableRecipe rec) {
        try {
            UnformedItemStack[] req = new UnformedItemStack[rec.requiredItems.length];
            for (int i = 0; i < req.length; ++i) {
                req[i] = rec.requiredItems[i] != null ? rec.requiredItems[i].copy() : null;
            }
            recipes.put(Arrays.asList(req), rec);
            ItemStack result = rec.result.func_77946_l();
            result.field_77994_a = 0;
            String searchStr = result.toString();
            result = null;
            recipesByIS.put(searchStr, rec);
            craftMatrixByID.add(Arrays.asList(req));
            req = null;
            return true;
        }
        catch (Exception e) {
            Side side = FMLCommonHandler.instance().getEffectiveSide();
            Notifier.notifyCustomMod((String)"EssentialCraftAPI", (String)("Unable to add recipe " + rec + " on side " + side));
            return false;
        }
    }

    public static boolean addRecipeIS(ItemStack[] craftingPair, ItemStack result, int mruRequired) {
        try {
            UnformedItemStack[] unformedStacks = new UnformedItemStack[craftingPair.length];
            for (int i = 0; i < craftingPair.length; ++i) {
                unformedStacks[i] = new UnformedItemStack(craftingPair[i]);
            }
            MagicianTableRecipe addedRecipe = new MagicianTableRecipe(unformedStacks, result, mruRequired);
            return MagicianTableRecipes.addRecipe(addedRecipe);
        }
        catch (Exception e) {
            Side side = FMLCommonHandler.instance().getEffectiveSide();
            Notifier.notifyCustomMod((String)"EssentialCraftAPI", (String)("Unable to add ore recipe " + Arrays.toString(craftingPair) + " with the result " + result + " on side " + side));
            return false;
        }
    }

    public static boolean addRecipeIS(UnformedItemStack[] craftingPair, ItemStack result, int mruRequired) {
        try {
            MagicianTableRecipe addedRecipe = new MagicianTableRecipe(craftingPair, result, mruRequired);
            return MagicianTableRecipes.addRecipe(addedRecipe);
        }
        catch (Exception e) {
            Side side = FMLCommonHandler.instance().getEffectiveSide();
            Notifier.notifyCustomMod((String)"EssentialCraftAPI", (String)("Unable to add ore recipe " + Arrays.toString(craftingPair) + " with the result " + result + " on side " + side));
            return false;
        }
    }

    public static boolean addRecipeOreDict(String[] craftingPair, ItemStack result, int mruRequired) {
        try {
            UnformedItemStack[] unformedStack = new UnformedItemStack[craftingPair.length];
            for (int i = 0; i < unformedStack.length; ++i) {
                unformedStack[i] = new UnformedItemStack(craftingPair[i]);
            }
            MagicianTableRecipe addedRecipe = new MagicianTableRecipe(unformedStack, result, mruRequired);
            return MagicianTableRecipes.addRecipe(addedRecipe);
        }
        catch (Exception e) {
            Side side = FMLCommonHandler.instance().getEffectiveSide();
            Notifier.notifyCustomMod((String)"EssentialCraftAPI", (String)("Unable to add ore dict recipe " + Arrays.toString(craftingPair) + " with the result " + result + " on side " + side));
            return false;
        }
    }
}

