/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.handler;

import cpw.mods.fml.common.registry.VillagerRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import net.darkhax.wawla.handler.ConfigurationHandler;
import net.darkhax.wawla.util.Constants;
import net.darkhax.wawla.util.IRCUtility;
import net.darkhax.wawla.util.PastebinUtility;
import net.darkhax.wawla.util.Utilities;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.StatCollector;

public class MissingDataDumpHandler {
    public static boolean sendReport = false;
    ArrayList<String> lang = new ArrayList();

    public MissingDataDumpHandler() {
        if (ConfigurationHandler.enableDumpFile) {
            PastebinUtility pastebin = new PastebinUtility("a8dec0b9187cb7989f3ca85a34ee52db");
            Constants.LOG.info("Beginning missing data dump.");
            PastebinUtility.Paste log = new PastebinUtility.Paste();
            this.writeIntroduction(log);
            this.initExistingLangFile();
            this.writeMissingEnchantments(log);
            this.writeMissingVillagers(log);
            String outpaste = pastebin.post("Wawla-Data-Dump" + MissingDataDumpHandler.getTimeStamp(), log, PastebinUtility.ReportFormat.PLAIN_TEXT, PastebinUtility.ExpireDate.ONE_WEEK);
            if (sendReport) {
                new IRCUtility("Darkhax: Some data has been collected: " + outpaste);
            }
            Constants.LOG.info("The data dump has been completed. Please see " + outpaste);
            this.lang = null;
        }
    }

    public void writeIntroduction(PastebinUtility.Paste paste) {
        ArrayList message = new ArrayList();
        Utilities.wrapStringToList("This is a data dump file for the Wawla mod. This dump file is generated when the player launches their game. Wawla will go through all enchantements and villagers added to the game, and then generate a language key. If the language key does not have a valid translation, then the key will be added to this file. This dump file does not contain any personal information about the user. After all the data has been collected, if any missing keys have been found, the dump file will be uploaded to pastebin, and then sent directly to the mod author. This information is important to the mod author, as it allows them to add better compatibility for Wawla and the mods that you are using. This file will automatically be deleted from pastebin after 7 days. While the data collected by this mod is not sensitive, it is possible to disable the dump file all together in your configuration file. Thank you for your time.", 80, true, message);
        paste.appendLine("                 WW      WW   AAA   WW      WW LL        AAA   ");
        paste.appendLine("                 WW      WW  AAAAA  WW      WW LL       AAAAA  ");
        paste.appendLine("                 WW   W  WW AA   AA WW   W  WW LL      AA   AA ");
        paste.appendLine("                  WW WWW WW AAAAAAA  WW WWW WW LL      AAAAAAA ");
        paste.appendLine("                   WW   WW  AA   AA   WW   WW  LLLLLLL AA   AA ");
        paste.appendLine("");
        for (String line : message) {
            paste.appendLine(line);
        }
    }

    public void writeMissingEnchantments(PastebinUtility.Paste paste) {
        paste.appendLine("");
        Enchantment[] enchantments = Enchantment.field_92090_c;
        ArrayList<String> missings = new ArrayList<String>();
        int counter = 0;
        for (int pos = 0; pos < enchantments.length; ++pos) {
            Enchantment ench = enchantments[pos];
            String translation = StatCollector.func_74838_a((String)("description." + ench.func_77320_a()));
            if (ench == null || !translation.startsWith("description.") || this.lang.contains(translation)) continue;
            missings.add("description." + ench.func_77320_a());
            ++counter;
            sendReport = true;
        }
        paste.appendLine("#Missing Enchantment Descriptions: " + counter + " found.");
        for (String entry : missings) {
            paste.appendLine(entry);
        }
    }

    public void writeMissingVillagers(PastebinUtility.Paste paste) {
        paste.appendLine("");
        VillagerRegistry village = VillagerRegistry.instance();
        ArrayList<String> missings = new ArrayList<String>();
        int counter = 0;
        Iterator i$ = village.getRegisteredVillagers().iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            String profession = StatCollector.func_74838_a((String)("description.villager.profession." + Utilities.getVillagerName(id)));
            if (!profession.startsWith("description.villager.profession.") || this.lang.contains(profession)) continue;
            missings.add(profession);
            ++counter;
            sendReport = true;
        }
        paste.appendLine("#Missing Villager Professions: " + counter + " found.");
        for (String entry : missings) {
            paste.appendLine(entry);
        }
    }

    public static String getTimeStamp() {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        Date now = new Date();
        String timeStamp = sdfDate.format(now);
        return timeStamp;
    }

    public void initExistingLangFile() {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new URL("https://raw.githubusercontent.com/Darkhax-Minecraft/WAWLA/master/src/main/resources/assets/wawla/lang/en_US.lang").openStream()));
            while ((line = reader.readLine()) != null) {
                if (line.equals("") && line.startsWith("#")) continue;
                String[] langs = line.split("=");
                this.lang.add(langs[0]);
            }
            reader.close();
        }
        catch (MalformedURLException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

