/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.client.gui.GuiBlockPlacer;
import openblocks.common.container.ContainerBlockPlacer;
import openmods.api.IHasGui;
import openmods.api.INeighbourAwareTile;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.include.IncludeInterface;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.TileEntityInventory;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.InventoryUtils;

public class TileEntityBlockPlacer
extends OpenTileEntity
implements INeighbourAwareTile,
IHasGui,
IInventoryProvider {
    static final int BUFFER_SIZE = 9;
    private static final int EVENT_ACTIVATE = 2;
    private boolean _redstoneSignal;
    private final GenericInventory inventory = this.registerInventoryCallback((GenericInventory)new TileEntityInventory((TileEntity)this, "blockPlacer", false, 9));

    public void setRedstoneSignal(boolean redstoneSignal) {
        if (redstoneSignal != this._redstoneSignal) {
            this._redstoneSignal = redstoneSignal;
            if (this._redstoneSignal && !InventoryUtils.inventoryIsEmpty((IInventory)this.inventory)) {
                this.placeBlock();
            }
        }
    }

    private void placeBlock() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a <= 0) continue;
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 2, i);
            break;
        }
    }

    public boolean func_145842_c(int event, int param) {
        if (event == 2) {
            this.placeBlock(param);
            return true;
        }
        return false;
    }

    private void placeBlock(final int slotId) {
        Block block;
        if (!(this.field_145850_b instanceof WorldServer)) {
            return;
        }
        final ItemStack stack = this.inventory.func_70301_a(slotId);
        if (stack == null || stack.field_77994_a <= 0) {
            return;
        }
        final ForgeDirection direction = this.getRotation();
        final int x = this.field_145851_c + direction.offsetX;
        final int y = this.field_145848_d + direction.offsetY;
        final int z = this.field_145849_e + direction.offsetZ;
        final boolean blockExists = this.field_145850_b.func_72899_e(x, y, z) ? !(block = this.field_145850_b.func_147439_a(x, y, z)).isAir((IBlockAccess)this.field_145850_b, x, y, z) && !block.isReplaceable((IBlockAccess)this.field_145850_b, x, y, z) : false;
        FakePlayerPool.instance.executeOnPlayer((WorldServer)this.field_145850_b, new FakePlayerPool.PlayerUser(){

            public void usePlayer(OpenModsFakePlayer fakePlayer) {
                ItemStack newStack = fakePlayer.equipWithAndRightClick(stack, Vec3.func_72443_a((double)TileEntityBlockPlacer.this.field_145851_c, (double)TileEntityBlockPlacer.this.field_145848_d, (double)TileEntityBlockPlacer.this.field_145849_e), Vec3.func_72443_a((double)x, (double)(y - 1), (double)z), direction.getOpposite(), blockExists);
                TileEntityBlockPlacer.this.inventory.func_70299_a(slotId, newStack);
            }
        });
    }

    public void onNeighbourChanged(Block block) {
        if (!this.field_145850_b.field_72995_K) {
            this.setRedstoneSignal(this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerBlockPlacer((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiBlockPlacer(new ContainerBlockPlacer((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }
}

