/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;
import openmods.api.INeighbourAwareTile;
import openmods.context.ContextManager;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.OpenModsFakePlayer;
import openmods.include.IncludeInterface;
import openmods.inventory.GenericInventory;
import openmods.inventory.legacy.ItemDistribution;
import openmods.sync.SyncableBoolean;
import openmods.tileentity.SyncedTileEntity;
import openmods.world.DropCapture;

public class TileEntityBlockBreaker
extends SyncedTileEntity
implements INeighbourAwareTile {
    private static final int EVENT_ACTIVATE = 3;
    @IncludeInterface(value=IInventory.class)
    private final GenericInventory inventory = this.registerInventoryCallback(new GenericInventory("blockbreaker", true, 1){

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return false;
        }
    });
    private int redstoneAnimTimer;
    private SyncableBoolean activated;

    public TileEntityBlockBreaker() {
        this.syncMap.addUpdateListener(this.createRenderUpdateListener());
    }

    protected void createSyncedFields() {
        this.activated = new SyncableBoolean(false);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isActivated() {
        return this.activated.get();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.activated.get()) {
            if (this.redstoneAnimTimer <= 0) {
                this.activated.set(false);
                this.sync();
            } else {
                --this.redstoneAnimTimer;
            }
        }
    }

    private void setRedstoneSignal(boolean redstoneSignal) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (redstoneSignal) {
            this.redstoneAnimTimer = 5;
            this.activated.set(true);
            this.sync();
            this.triggerBreakBlock();
        }
    }

    private boolean canBreakBlock(Block block, int x, int y, int z) {
        return !block.isAir((IBlockAccess)this.field_145850_b, x, y, z) && block != Blocks.field_150357_h && block.func_149712_f(this.field_145850_b, z, y, z) > -1.0f;
    }

    private void triggerBreakBlock() {
        Block block;
        ForgeDirection direction = this.getRotation();
        int x = this.field_145851_c + direction.offsetX;
        int y = this.field_145848_d + direction.offsetY;
        int z = this.field_145849_e + direction.offsetZ;
        if (this.field_145850_b.func_72899_e(x, y, z) && this.canBreakBlock(block = this.field_145850_b.func_147439_a(x, y, z), x, y, z)) {
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 3, 0);
        }
        this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "tile.piston.in", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.15f + 0.6f);
    }

    public boolean func_145842_c(int event, int param) {
        if (event == 3) {
            this.breakBlock();
            return true;
        }
        return false;
    }

    public void breakBlock() {
        if (!(this.field_145850_b instanceof WorldServer)) {
            return;
        }
        final ForgeDirection direction = this.getRotation();
        final int x = this.field_145851_c + direction.offsetX;
        final int y = this.field_145848_d + direction.offsetY;
        final int z = this.field_145849_e + direction.offsetZ;
        if (!this.field_145850_b.func_72899_e(x, y, z)) {
            return;
        }
        final Block block = this.field_145850_b.func_147439_a(x, y, z);
        final int metadata = this.field_145850_b.func_72805_g(x, y, z);
        if (!this.canBreakBlock(block, x, y, z)) {
            return;
        }
        FakePlayerPool.instance.executeOnPlayer((WorldServer)this.field_145850_b, new FakePlayerPool.PlayerUser(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void usePlayer(OpenModsFakePlayer fakePlayer) {
                List drops;
                fakePlayer.field_71071_by.field_70461_c = 0;
                fakePlayer.field_71071_by.func_70299_a(0, new ItemStack(Items.field_151046_w, 0, 0));
                if (!TileEntityBlockBreaker.this.field_145850_b.func_72962_a((EntityPlayer)fakePlayer, x, y, z)) {
                    return;
                }
                DropCapture.CaptureContext dropsCapturer = DropCapture.instance.start(x, y, z);
                ContextManager.push();
                try {
                    BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(x, y, z, TileEntityBlockBreaker.this.field_145850_b, block, metadata, (EntityPlayer)fakePlayer);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        return;
                    }
                    boolean canHarvest = block.canHarvestBlock((EntityPlayer)fakePlayer, metadata);
                    block.func_149681_a(TileEntityBlockBreaker.this.field_145850_b, x, y, z, metadata, (EntityPlayer)fakePlayer);
                    boolean canRemove = block.removedByPlayer(TileEntityBlockBreaker.this.field_145850_b, (EntityPlayer)fakePlayer, x, y, z, canHarvest);
                    if (canRemove) {
                        block.func_149664_b(TileEntityBlockBreaker.this.field_145850_b, x, y, z, metadata);
                        if (canHarvest) {
                            block.func_149636_a(TileEntityBlockBreaker.this.field_145850_b, (EntityPlayer)fakePlayer, x, y, z, metadata);
                        }
                        TileEntityBlockBreaker.this.field_145850_b.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (metadata << 12));
                    }
                }
                finally {
                    ContextManager.pop();
                    List drops2 = dropsCapturer.stop();
                }
                if (!drops.isEmpty()) {
                    TileEntityBlockBreaker.this.tryInjectItems(drops, direction.getOpposite());
                }
            }
        });
    }

    private void tryInjectItems(List<EntityItem> drops, ForgeDirection direction) {
        TileEntity targetInventory = this.getTileInDirection(direction);
        if (targetInventory == null) {
            return;
        }
        for (EntityItem drop : drops) {
            ItemStack stack = drop.func_92059_d();
            ItemDistribution.insertItemInto((ItemStack)stack, (TileEntity)targetInventory, (ForgeDirection)direction, (boolean)true);
            if (stack.field_77994_a > 0) continue;
            drop.func_70106_y();
        }
    }

    public void onNeighbourChanged(Block block) {
        if (!this.field_145850_b.field_72995_K) {
            this.setRedstoneSignal(this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }
}

