/*
 * Decompiled with CFR 0.152.
 */
package io.github.alex_hawks.SanguineExtras.api.sigil;

import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.monster.EntityWitch;

public class MobNet {
    private static final Set<Class<?>> capture = new LinkedHashSet();
    private static final Set<Class<?>> spawn = new LinkedHashSet();

    public static void addToCaptureBlacklist(Class<?> ent) {
        capture.add(ent);
    }

    public static void addToCaptureBlacklist(String name) {
        try {
            MobNet.addToCaptureBlacklist(Class.forName(name));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void addToSpawnBlacklist(Class<?> ent) {
        spawn.add(ent);
    }

    public static void addToSpawnBlacklist(String name) {
        try {
            MobNet.addToSpawnBlacklist(Class.forName(name));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void removeFromCaptureBlacklist(Class<?> ent) {
        capture.remove(ent);
    }

    public static void removeFromSpawnBlacklist(Class<?> ent) {
        spawn.remove(ent);
    }

    public static boolean isCaptureBlacklisted(Object ent) {
        if (capture.contains(ent.getClass())) {
            return true;
        }
        for (Class<?> clazz : capture) {
            if (!clazz.isInstance(ent)) continue;
            capture.add(ent.getClass());
            return true;
        }
        return false;
    }

    public static boolean isSpawnBlacklisted(Object ent) {
        if (spawn.contains(ent.getClass())) {
            return true;
        }
        for (Class<?> clazz : spawn) {
            if (!clazz.isInstance(ent)) continue;
            spawn.add(ent.getClass());
            return true;
        }
        return false;
    }

    static {
        MobNet.addToCaptureBlacklist(IEntityMultiPart.class);
        MobNet.addToCaptureBlacklist("thaumcraft.common.entities.golems.EntityGolemBase");
        MobNet.addToSpawnBlacklist(IEntityMultiPart.class);
        MobNet.addToSpawnBlacklist(EntityWitch.class);
    }
}

