/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.gui.client;

import com.vanhal.progressiveautomation.entities.miner.TileMiner;
import com.vanhal.progressiveautomation.gui.client.BaseGUI;
import com.vanhal.progressiveautomation.gui.container.ContainerMiner;
import com.vanhal.progressiveautomation.upgrades.UpgradeType;
import com.vanhal.progressiveautomation.util.StringHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GUIMiner
extends BaseGUI {
    public static final ResourceLocation texture = new ResourceLocation("progressiveautomation", "textures/gui/Miner.png");
    protected int infoScreenX = 38;
    protected int infoScreenW = 66;
    protected int infroScreenY1 = 17;
    protected int infroScreenY2 = 27;
    protected int infroScreenY3 = 37;
    private TileMiner miner;

    public GUIMiner(InventoryPlayer inv, TileEntity entity) {
        super(new ContainerMiner(inv, entity), texture);
        this.miner = (TileMiner)entity;
    }

    @Override
    protected void drawText() {
        this.drawString(StringHelper.localize("gui.miner"), 5, GRAY);
        this.drawString(StringHelper.localize("gui.range") + ": " + StringHelper.getScaledNumber(this.miner.getRange()), this.infoScreenX, this.infoScreenW, this.infroScreenY3, this.miner.hasUpgrade(UpgradeType.WITHER) ? GREEN : WHITE);
        if (this.miner.isInvalidTool()) {
            this.drawString(this.getTextLine(1, "gui.invalidtool.1"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, ORANGE);
            this.drawString(this.getTextLine(2, "gui.invalidtool.2"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, ORANGE);
        } else if (this.miner.isLooked()) {
            boolean readyToMine = true;
            if (!this.miner.hasFuel() && !this.miner.isBurning()) {
                String fuelString = "gui.need.fuel";
                if (this.miner.hasEngine()) {
                    fuelString = "gui.need.energy";
                }
                this.drawString(StringHelper.localize(fuelString), this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
                readyToMine = false;
            } else if (this.miner.func_70301_a(1) == null && !this.miner.hasUpgrade(UpgradeType.COBBLE_GEN)) {
                this.drawString(StringHelper.localize("gui.need.cobble"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
                readyToMine = false;
            } else if (this.miner.func_70301_a(this.miner.SLOT_PICKAXE) == null) {
                this.drawString(StringHelper.localize("gui.need.pick"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
                readyToMine = false;
            } else if (this.miner.func_70301_a(this.miner.SLOT_SHOVEL) == null) {
                this.drawString(StringHelper.localize("gui.need.shovel"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, RED);
                readyToMine = false;
            } else {
                this.drawString(StringHelper.getScaledNumber(this.miner.getMinedBlocks()) + "/" + StringHelper.getScaledNumber(this.miner.getMineBlocks()), this.infoScreenX, this.infoScreenW, this.infroScreenY2, BLUE);
            }
            if (!readyToMine) {
                this.drawString(StringHelper.localize("gui.notready"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, RED);
            } else if (this.miner.getMinedBlocks() == this.miner.getMineBlocks()) {
                this.drawString(StringHelper.localize("gui.finished"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, BLUE);
            } else {
                this.drawString(StringHelper.localize("gui.mining"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, GREEN);
            }
        } else {
            this.drawString(this.getTextLine(1, "gui.hi.miner"), this.infoScreenX, this.infoScreenW, this.infroScreenY1, GREEN);
            this.drawString(this.getTextLine(2, "gui.addtools"), this.infoScreenX, this.infoScreenW, this.infroScreenY2, GREEN);
        }
    }

    @Override
    protected void drawElements() {
        this.drawFlame(this.miner.getPercentDone(), 10, 34);
        if (this.miner.hasUpgrade(UpgradeType.COBBLE_GEN)) {
            this.func_73729_b(this.field_147003_i - 25, this.field_147009_r + 10, 231, 0, 25, 64);
        }
    }
}

