/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.entities;

import cofh.api.energy.IEnergyHandler;
import com.vanhal.progressiveautomation.PAConfig;
import com.vanhal.progressiveautomation.blocks.network.PartialTileNBTUpdateMessage;
import com.vanhal.progressiveautomation.items.ItemRFEngine;
import com.vanhal.progressiveautomation.ref.ToolHelper;
import com.vanhal.progressiveautomation.ref.WrenchModes;
import com.vanhal.progressiveautomation.util.BlockHelper;
import com.vanhal.progressiveautomation.util.Point2I;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;

public class BaseTileEntity
extends TileEntity
implements ISidedInventory,
IEnergyHandler {
    protected ItemStack[] slots;
    protected int progress = 0;
    protected int burnLevel = 0;
    protected boolean RedstonePowered = false;
    protected boolean firstLook = false;
    public ForgeDirection extDirection = ForgeDirection.UP;
    public ForgeDirection facing = ForgeDirection.EAST;
    public WrenchModes.Mode[] sides = new WrenchModes.Mode[6];
    private boolean dirty;
    private NBTTagCompound partialUpdateTag = new NBTTagCompound();
    protected Random RND = new Random();
    public int SLOT_FUEL = 0;
    public int SLOT_PICKAXE = -1;
    public int SLOT_SHOVEL = -1;
    public int SLOT_AXE = -1;
    public int SLOT_SWORD = -1;
    public int SLOT_HOE = -1;
    public int SLOT_UPGRADE = -1;
    public int SLOT_INVENTORY_START = -1;
    public int SLOT_INVENTORY_END = -1;
    protected boolean lastEngine = false;

    public BaseTileEntity(int numSlots) {
        this.slots = new ItemStack[numSlots + 1];
        if (numSlots > 9) {
            this.SLOT_INVENTORY_START = numSlots - 8;
            this.SLOT_INVENTORY_END = numSlots;
        } else {
            this.SLOT_INVENTORY_START = this.SLOT_INVENTORY_END = numSlots;
        }
        for (int i = 0; i < 6; ++i) {
            this.sides[i] = WrenchModes.Mode.Normal;
            if (i != this.extDirection.ordinal()) continue;
            this.sides[i] = WrenchModes.Mode.Output;
        }
    }

    protected void setExtDirection(ForgeDirection dir) {
        this.sides[this.extDirection.ordinal()] = WrenchModes.Mode.Normal;
        this.extDirection = dir;
        this.sides[this.extDirection.ordinal()] = WrenchModes.Mode.Output;
    }

    public final void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeCommonNBT(nbt);
        this.writeNonSyncableNBT(nbt);
    }

    public final void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readCommonNBT(nbt);
        this.readNonSyncableNBT(nbt);
    }

    public void readFromItemStack(ItemStack itemStack) {
        if (itemStack == null || itemStack.field_77990_d == null) {
            return;
        }
        this.readCommonNBT(itemStack.field_77990_d);
        this.readNonSyncableNBT(itemStack.field_77990_d);
    }

    public void writeToItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
        this.writeCommonNBT(itemStack.field_77990_d);
        this.writeNonSyncableNBT(itemStack.field_77990_d);
    }

    protected void writeSyncOnlyNBT(NBTTagCompound nbt) {
    }

    public void writeCommonNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Progress", this.progress);
        nbt.func_74768_a("BurnLevel", this.burnLevel);
        nbt.func_74757_a("firstLook", this.firstLook);
        nbt.func_74768_a("facing", this.facing.ordinal());
        int[] ary = new int[6];
        for (int i = 0; i < 6; ++i) {
            ary[i] = this.sides[i].ordinal();
        }
        nbt.func_74783_a("sides", ary);
        ary = null;
    }

    public void writeNonSyncableNBT(NBTTagCompound nbt) {
        NBTTagList contents = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            ItemStack stack = this.slots[i];
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            contents.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Contents", (NBTBase)contents);
    }

    public void readSyncOnlyNBT(NBTTagCompound nbt) {
    }

    public void readCommonNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Progress")) {
            this.progress = nbt.func_74762_e("Progress");
        }
        if (nbt.func_74764_b("BurnLevel")) {
            this.burnLevel = nbt.func_74762_e("BurnLevel");
        }
        if (nbt.func_74764_b("firstLook")) {
            this.firstLook = nbt.func_74767_n("firstLook");
        }
        if (nbt.func_74764_b("facing")) {
            this.facing = ForgeDirection.getOrientation((int)nbt.func_74762_e("facing"));
        }
        if (nbt.func_74764_b("sides")) {
            int[] ary = nbt.func_74759_k("sides");
            for (int i = 0; i < 6; ++i) {
                this.sides[i] = WrenchModes.modes.get(ary[i]);
            }
        }
    }

    protected void readNonSyncableNBT(NBTTagCompound nbt) {
        NBTTagList contents = nbt.func_150295_c("Contents", 10);
        for (int i = 0; i < contents.func_74745_c(); ++i) {
            NBTTagCompound tag = contents.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot >= this.slots.length) continue;
            this.slots[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeCommonNBT(nbttagcompound);
        this.writeSyncOnlyNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -1, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readCommonNBT(pkt.func_148857_g());
        this.readSyncOnlyNBT(pkt.func_148857_g());
    }

    public PartialTileNBTUpdateMessage getPartialUpdateMessage() {
        PartialTileNBTUpdateMessage message = new PartialTileNBTUpdateMessage(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.partialUpdateTag);
        this.dirty = false;
        this.partialUpdateTag = new NBTTagCompound();
        return message;
    }

    protected void addPartialUpdate(String fieldName, Integer value) {
        this.partialUpdateTag.func_74768_a(fieldName, value.intValue());
        this.dirty = true;
    }

    protected void addPartialUpdate(String fieldName, String value) {
        this.partialUpdateTag.func_74778_a(fieldName, value);
        this.dirty = true;
    }

    protected void addPartialUpdate(String fieldName, NBTBase value) {
        this.partialUpdateTag.func_74782_a(fieldName, value);
        this.dirty = true;
    }

    protected void addPartialUpdate(String fieldName, Boolean value) {
        this.partialUpdateTag.func_74757_a(fieldName, value.booleanValue());
        this.dirty = true;
    }

    protected void addPartialUpdate(String fieldName, NBTTagCompound value) {
        this.partialUpdateTag.func_74782_a(fieldName, (NBTBase)value);
        this.dirty = true;
    }

    protected NBTTagCompound getCompoundTagFromPartialUpdate(String fieldName) {
        return this.partialUpdateTag.func_74775_l(fieldName);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isBurning()) {
                this.RedstonePowered = this.isIndirectlyPowered();
                if (!this.RedstonePowered && this.readyToBurn() && this.slots[this.SLOT_FUEL] != null) {
                    if (this.isFuel()) {
                        this.burnLevel = this.progress = this.getBurnTime();
                        this.addPartialUpdate("Progress", this.progress);
                        this.addPartialUpdate("BurnLevel", this.burnLevel);
                        if (this.slots[this.SLOT_FUEL].func_77973_b().hasContainerItem(this.slots[this.SLOT_FUEL])) {
                            this.slots[this.SLOT_FUEL] = this.slots[this.SLOT_FUEL].func_77973_b().getContainerItem(this.slots[this.SLOT_FUEL]);
                            if (!this.isFuel()) {
                                this.moveToInventoryOrDrop(this.SLOT_FUEL);
                            }
                        } else {
                            --this.slots[this.SLOT_FUEL].field_77994_a;
                            if (this.slots[this.SLOT_FUEL].field_77994_a == 0) {
                                this.slots[this.SLOT_FUEL] = null;
                            }
                        }
                    } else if (this.hasEngine() && this.useEnergy(PAConfig.rfCost, false) > 0 && (this.burnLevel != 1 || this.progress != 1)) {
                        this.progress = 1;
                        this.burnLevel = 1;
                        this.addPartialUpdate("Progress", this.progress);
                        this.addPartialUpdate("BurnLevel", this.burnLevel);
                    }
                }
            } else {
                --this.progress;
                if (this.progress <= 0) {
                    this.progress = 0;
                    this.burnLevel = 0;
                    this.addPartialUpdate("BurnLevel", this.burnLevel);
                    if (this.readyToBurn() && this.hasEngine() && this.useEnergy(PAConfig.rfCost, false) > 0) {
                        this.progress = 1;
                        this.burnLevel = 1;
                    }
                }
                this.addPartialUpdate("Progress", this.progress);
            }
            this.checkForPowerChange();
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int value) {
        this.progress = value;
    }

    public int getBurnLevel() {
        return this.burnLevel;
    }

    public void setBurnLevel(int value) {
        this.burnLevel = value;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.slots[slot];
    }

    public ItemStack func_70298_a(int slot, int amt) {
        if (this.slots[slot] != null) {
            ItemStack newStack;
            if (this.slots[slot].field_77994_a <= amt) {
                newStack = this.slots[slot];
                this.slots[slot] = null;
            } else {
                newStack = this.slots[slot].func_77979_a(amt);
                if (this.slots[slot].field_77994_a == 0) {
                    this.slots[slot] = null;
                }
            }
            return newStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.slots[slot] != null) {
            ItemStack stack = this.slots[slot];
            this.slots[slot] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.slots[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == this.SLOT_FUEL && BaseTileEntity.getItemBurnTime(stack) > 0 && ToolHelper.getType(stack) == -1) {
            return true;
        }
        return slot >= this.SLOT_INVENTORY_START && slot <= this.SLOT_INVENTORY_END && this.SLOT_INVENTORY_START != this.SLOT_INVENTORY_END;
    }

    public void destroyTool(int slot) {
        if (slot == -1 || this.slots[slot] == null) {
            return;
        }
        if (ToolHelper.tinkersType(this.slots[slot].func_77973_b()) >= 0) {
            this.addToInventory(this.slots[slot]);
        } else if (!PAConfig.destroyTools) {
            this.addToInventory(this.slots[slot]);
        }
        this.slots[slot] = null;
    }

    public WrenchModes.Mode getSide(ForgeDirection side) {
        return this.sides[side.ordinal()];
    }

    public void setSide(ForgeDirection side, WrenchModes.Mode type) {
        this.sides[side.ordinal()] = type;
    }

    public int[] func_94128_d(int side) {
        int[] output = new int[this.slots.length];
        for (int i = 0; i < this.slots.length; ++i) {
            output[i] = i;
        }
        return output;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        int availSpace;
        if (slot < 0 || slot > this.SLOT_INVENTORY_END) {
            return false;
        }
        if (this.sides[side] == WrenchModes.Mode.Disabled) {
            return false;
        }
        if (this.sides[side] == WrenchModes.Mode.Output) {
            return false;
        }
        if (this.sides[side] == WrenchModes.Mode.FuelInput && slot != this.SLOT_FUEL) {
            return false;
        }
        if (this.sides[side] == WrenchModes.Mode.Input && slot == this.SLOT_FUEL) {
            return false;
        }
        return this.slots[slot] != null && this.slots[slot].func_77969_a(stack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.slots[slot]) ? (availSpace = this.func_70297_j_() - this.slots[slot].field_77994_a) > 0 : this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (this.sides[side] == WrenchModes.Mode.Disabled) {
            return false;
        }
        return slot >= this.SLOT_INVENTORY_START && slot <= this.SLOT_INVENTORY_END && (this.sides[side] == WrenchModes.Mode.Normal || this.sides[side] == WrenchModes.Mode.Output);
    }

    public boolean readyToBurn() {
        return true;
    }

    public boolean isBurning() {
        return this.progress > 0;
    }

    public float getPercentDone() {
        if (this.isBurning() && this.burnLevel > 0) {
            float done = this.progress;
            return done /= (float)this.burnLevel;
        }
        return 0.0f;
    }

    public int getScaledDone(int scale) {
        return (int)Math.floor((float)scale * this.getPercentDone());
    }

    public int getBurnTime() {
        return this.getBurnTime(this.slots[0]);
    }

    public int getBurnTime(ItemStack item) {
        return BaseTileEntity.getItemBurnTime(item) / PAConfig.fuelCost;
    }

    public static int getItemBurnTime(ItemStack item) {
        if (PAConfig.allowPotatos) {
            if (item.func_77973_b() == Items.field_151174_bG) {
                return 40;
            }
            if (item.func_77973_b() == Items.field_151168_bH) {
                return 80;
            }
        }
        if (item == null) {
            return 0;
        }
        return TileEntityFurnace.func_145952_a((ItemStack)item);
    }

    public boolean isFuel() {
        return this.getBurnTime() > 0;
    }

    public boolean hasFuel() {
        if (this.slots[this.SLOT_FUEL] != null) {
            if (this.hasEngine()) {
                if (this.useEnergy(PAConfig.rfCost, true) > 0) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public int extraSlotCheck(ItemStack item) {
        int targetSlot = -1;
        if (this.getBurnTime(item) > 0) {
            if (this.slots[0] == null) {
                targetSlot = 0;
            } else if (item.func_77969_a(this.slots[0]) && ItemStack.func_77970_a((ItemStack)item, (ItemStack)this.slots[0])) {
                targetSlot = 0;
            }
        }
        return targetSlot;
    }

    public void checkInventory() {
        if (this.SLOT_INVENTORY_START == -1 || this.SLOT_INVENTORY_END == -1) {
            return;
        }
        for (int i = this.SLOT_INVENTORY_START; i <= this.SLOT_INVENTORY_END; ++i) {
            int moveTo;
            if (this.slots[i] == null || (moveTo = this.extraSlotCheck(this.slots[i])) < 0) continue;
            this.slots[i] = this.moveItemToSlot(this.slots[i], moveTo);
        }
        for (int x = 0; x < 6; ++x) {
            int i;
            ISidedInventory externalInv;
            if (this.sides[x] != WrenchModes.Mode.Output) continue;
            ForgeDirection testSide = ForgeDirection.getOrientation((int)x);
            if (BlockHelper.getAdjacentTileEntity((TileEntity)this, testSide) instanceof ISidedInventory) {
                externalInv = (ISidedInventory)BlockHelper.getAdjacentTileEntity((TileEntity)this, testSide);
                for (i = this.SLOT_INVENTORY_START; i <= this.SLOT_INVENTORY_END; ++i) {
                    if (this.slots[i] == null) continue;
                    this.addtoSidedExtInventory(externalInv, i);
                }
                continue;
            }
            if (!(BlockHelper.getAdjacentTileEntity((TileEntity)this, testSide) instanceof IInventory)) continue;
            externalInv = (IInventory)BlockHelper.getAdjacentTileEntity((TileEntity)this, testSide);
            for (i = this.SLOT_INVENTORY_START; i <= this.SLOT_INVENTORY_END; ++i) {
                if (this.slots[i] == null) continue;
                this.addtoExtInventory((IInventory)externalInv, i);
            }
        }
    }

    protected ItemStack moveItemToSlot(ItemStack item, int targetSlot) {
        if (this.slots[targetSlot] == null) {
            this.slots[targetSlot] = item;
            item = null;
        } else if (this.slots[targetSlot].field_77994_a < this.slots[targetSlot].func_77976_d() && this.slots[targetSlot].func_77969_a(item) && ItemStack.func_77970_a((ItemStack)item, (ItemStack)this.slots[targetSlot])) {
            int avail = this.slots[targetSlot].func_77976_d() - this.slots[targetSlot].field_77994_a;
            if (avail >= item.field_77994_a) {
                this.slots[targetSlot].field_77994_a += item.field_77994_a;
                item = null;
            } else {
                item.field_77994_a -= avail;
                this.slots[targetSlot].field_77994_a += avail;
            }
        }
        return item;
    }

    public boolean addtoExtInventory(IInventory inv, int fromSlot) {
        int i;
        for (i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null || !inv.func_70301_a(i).func_77969_a(this.slots[fromSlot]) || inv.func_70301_a((int)i).field_77994_a >= inv.func_70301_a(i).func_77976_d() || !ItemStack.func_77970_a((ItemStack)inv.func_70301_a(i), (ItemStack)this.slots[fromSlot])) continue;
            int avail = inv.func_70301_a(i).func_77976_d() - inv.func_70301_a((int)i).field_77994_a;
            if (avail >= this.slots[fromSlot].field_77994_a) {
                inv.func_70301_a((int)i).field_77994_a += this.slots[fromSlot].field_77994_a;
                this.slots[fromSlot] = null;
                return true;
            }
            this.slots[fromSlot].field_77994_a -= avail;
            inv.func_70301_a((int)i).field_77994_a += avail;
        }
        if (this.slots[fromSlot] != null && this.slots[fromSlot].field_77994_a > 0) {
            for (i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i) != null || !inv.func_94041_b(i, this.slots[fromSlot])) continue;
                inv.func_70299_a(i, this.slots[fromSlot]);
                this.slots[fromSlot] = null;
                return true;
            }
        }
        return false;
    }

    public boolean addtoSidedExtInventory(ISidedInventory inv, int fromSlot) {
        int j;
        int side = this.extDirection.getOpposite().ordinal();
        int[] trySlots = inv.func_94128_d(side);
        int i = 0;
        for (j = 0; j < trySlots.length; ++j) {
            i = trySlots[j];
            if (inv.func_70301_a(i) == null || !inv.func_70301_a(i).func_77969_a(this.slots[fromSlot]) || inv.func_70301_a((int)i).field_77994_a >= inv.func_70301_a(i).func_77976_d() || !ItemStack.func_77970_a((ItemStack)inv.func_70301_a(i), (ItemStack)this.slots[fromSlot])) continue;
            int avail = inv.func_70301_a(i).func_77976_d() - inv.func_70301_a((int)i).field_77994_a;
            if (avail >= this.slots[fromSlot].field_77994_a) {
                inv.func_70301_a((int)i).field_77994_a += this.slots[fromSlot].field_77994_a;
                this.slots[fromSlot] = null;
                return true;
            }
            this.slots[fromSlot].field_77994_a -= avail;
            inv.func_70301_a((int)i).field_77994_a += avail;
        }
        if (this.slots[fromSlot] != null && this.slots[fromSlot].field_77994_a > 0) {
            for (j = 0; j < trySlots.length; ++j) {
                i = trySlots[j];
                if (!inv.func_102007_a(i, this.slots[fromSlot], side) || inv.func_70301_a(i) != null || !inv.func_94041_b(i, this.slots[fromSlot])) continue;
                inv.func_70299_a(i, this.slots[fromSlot]);
                this.slots[fromSlot] = null;
                return true;
            }
        }
        return false;
    }

    public boolean roomInInventory(ItemStack item) {
        int i;
        if (this.SLOT_INVENTORY_START == -1 || this.SLOT_INVENTORY_END == -1) {
            return false;
        }
        if (item == null) {
            return false;
        }
        int stackSize = item.field_77994_a;
        for (i = this.SLOT_INVENTORY_START; i <= this.SLOT_INVENTORY_END; ++i) {
            if (this.slots[i] == null || !this.slots[i].func_77969_a(item) || this.slots[i].field_77994_a >= this.slots[i].func_77976_d() || !ItemStack.func_77970_a((ItemStack)item, (ItemStack)this.slots[i])) continue;
            int avail = this.slots[i].func_77976_d() - this.slots[i].field_77994_a;
            if (avail >= stackSize) {
                return true;
            }
            stackSize -= avail;
        }
        if (item != null && stackSize > 0) {
            for (i = this.SLOT_INVENTORY_START; i <= this.SLOT_INVENTORY_END; ++i) {
                if (this.slots[i] != null) continue;
                return true;
            }
        }
        return stackSize == 0;
    }

    public boolean addToInventory(ItemStack item) {
        int i;
        if (this.SLOT_INVENTORY_START == -1 || this.SLOT_INVENTORY_END == -1) {
            return false;
        }
        int extraSlot = this.extraSlotCheck(item);
        if (extraSlot >= 0) {
            item = this.moveItemToSlot(item, extraSlot);
        }
        for (i = this.SLOT_INVENTORY_START; i <= this.SLOT_INVENTORY_END; ++i) {
            if (this.slots[i] == null || item == null || !this.slots[i].func_77969_a(item) || this.slots[i].field_77994_a >= this.slots[i].func_77976_d() || !ItemStack.func_77970_a((ItemStack)item, (ItemStack)this.slots[i])) continue;
            int avail = this.slots[i].func_77976_d() - this.slots[i].field_77994_a;
            if (avail >= item.field_77994_a) {
                this.slots[i].field_77994_a += item.field_77994_a;
                item = null;
                return true;
            }
            item.field_77994_a -= avail;
            this.slots[i].field_77994_a += avail;
        }
        if (item != null && item.field_77994_a > 0) {
            for (i = this.SLOT_INVENTORY_START; i <= this.SLOT_INVENTORY_END; ++i) {
                if (this.slots[i] != null || !this.func_94041_b(i, item)) continue;
                this.slots[i] = item;
                item = null;
                return true;
            }
        }
        if (item != null && item.field_77994_a == 0) {
            item = null;
        }
        if (item != null) {
            this.dropItem(item);
            item = null;
        }
        return false;
    }

    public void moveToInventoryOrDrop(int slot) {
        if (!this.field_145850_b.field_72995_K) {
            for (int x = 0; x < 6; ++x) {
                ISidedInventory externalInv;
                if (this.sides[x] != WrenchModes.Mode.Output) continue;
                ForgeDirection testSide = ForgeDirection.getOrientation((int)x);
                if (BlockHelper.getAdjacentTileEntity((TileEntity)this, testSide) instanceof ISidedInventory) {
                    externalInv = (ISidedInventory)BlockHelper.getAdjacentTileEntity((TileEntity)this, testSide);
                    if (this.slots[slot] == null) continue;
                    this.addtoSidedExtInventory(externalInv, slot);
                    continue;
                }
                if (!(BlockHelper.getAdjacentTileEntity((TileEntity)this, testSide) instanceof IInventory)) continue;
                externalInv = (IInventory)BlockHelper.getAdjacentTileEntity((TileEntity)this, testSide);
                if (this.slots[slot] == null) continue;
                this.addtoExtInventory((IInventory)externalInv, slot);
            }
            if (this.slots[slot] != null) {
                ItemStack item = this.slots[slot].func_77946_l();
                this.slots[slot] = null;
                if (item != null) {
                    this.addToInventory(item);
                }
                if (item != null && (this.SLOT_INVENTORY_START == -1 || this.SLOT_INVENTORY_END == -1)) {
                    this.dropItem(item);
                }
            }
        }
    }

    public void dropItem(ItemStack item) {
        if (item != null) {
            EntityItem entItem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 1.5f), (double)((float)this.field_145849_e + 0.5f), item);
            entItem.field_145804_b = 1;
            float f3 = 0.05f;
            entItem.field_70159_w = (float)this.field_145850_b.field_73012_v.nextGaussian() * f3;
            entItem.field_70181_x = (float)this.field_145850_b.field_73012_v.nextGaussian() * f3 + 0.2f;
            entItem.field_70179_y = (float)this.field_145850_b.field_73012_v.nextGaussian() * f3;
            this.field_145850_b.func_72838_d((Entity)entItem);
        }
    }

    public boolean hasEngine() {
        if (this.slots[this.SLOT_FUEL] == null) {
            return false;
        }
        return this.slots[this.SLOT_FUEL].func_77973_b() instanceof ItemRFEngine;
    }

    protected ItemRFEngine getEngine() {
        if (this.hasEngine()) {
            return (ItemRFEngine)this.slots[this.SLOT_FUEL].func_77973_b();
        }
        return null;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        return this.getEngine() != null;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.field_145850_b.field_72995_K) {
            return 0;
        }
        return this.addEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    protected int useEnergy(int amount, boolean simulate) {
        ItemRFEngine engine = this.getEngine();
        if (this.getEngine() == null) {
            return 0;
        }
        int energyExtracted = Math.min(engine.getCharge(this.slots[this.SLOT_FUEL]), amount);
        if (energyExtracted != amount) {
            return 0;
        }
        if (!simulate) {
            engine.addCharge(this.slots[this.SLOT_FUEL], energyExtracted * -1);
        }
        return energyExtracted;
    }

    protected int addEnergy(int amount, boolean simulate) {
        ItemRFEngine engine = this.getEngine();
        if (this.getEngine() == null) {
            return 0;
        }
        int energyReceived = Math.min(engine.getMaxCharge() - engine.getCharge(this.slots[this.SLOT_FUEL]), Math.min(amount, PAConfig.rfRate));
        if (!simulate) {
            engine.addCharge(this.slots[this.SLOT_FUEL], energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.hasEngine()) {
            return this.getEngine().getCharge(this.slots[this.SLOT_FUEL]);
        }
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.hasEngine()) {
            return this.getEngine().getMaxCharge();
        }
        return 0;
    }

    protected void checkForPowerChange() {
        if (!this.lastEngine && this.hasEngine() || this.lastEngine && !this.hasEngine()) {
            this.lastEngine = this.hasEngine();
            this.notifyUpdate();
        }
    }

    protected void notifyUpdate() {
        Block minerBlock = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, minerBlock);
    }

    public void setLooked() {
        if (!this.firstLook) {
            this.firstLook = true;
            this.addPartialUpdate("firstLook", this.firstLook);
        }
    }

    public boolean isLooked() {
        return this.firstLook;
    }

    public Point2I spiral(int n, int x, int y) {
        return BaseTileEntity.spiral(n, x, y, this.facing);
    }

    public static Point2I spiral(int n, int x, int y, ForgeDirection direction) {
        int dy;
        int dx;
        int k = (int)Math.ceil((Math.sqrt(n) - 1.0) / 2.0);
        int t = 2 * k + 1;
        int m = t * t;
        if (n >= m - --t) {
            dx = k - (m - n);
            dy = -k;
        } else if (n >= (m -= t) - t) {
            dx = -k;
            dy = -k + (m - n);
        } else if (n >= (m -= t) - t) {
            dx = -k + (m - n);
            dy = k;
        } else {
            dx = k;
            dy = k - (m - n - t);
        }
        if (direction == ForgeDirection.NORTH) {
            return new Point2I(x + dy, y - dx);
        }
        if (direction == ForgeDirection.SOUTH) {
            return new Point2I(x - dy, y + dx);
        }
        if (direction == ForgeDirection.EAST) {
            return new Point2I(x + dx, y + dy);
        }
        return new Point2I(x - dx, y - dy);
    }

    protected boolean isIndirectlyPowered() {
        return this.field_145850_b.func_94574_k(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, 0) ? true : (this.field_145850_b.func_94574_k(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, 1) ? true : (this.field_145850_b.func_94574_k(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, 2) ? true : (this.field_145850_b.func_94574_k(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, 3) ? true : (this.field_145850_b.func_94574_k(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, 5) ? true : (this.field_145850_b.func_94574_k(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, 4) ? true : (this.field_145850_b.func_94574_k(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e, 1) ? true : (this.field_145850_b.func_94574_k(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1, 2) ? true : (this.field_145850_b.func_94574_k(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1, 3) ? true : (this.field_145850_b.func_94574_k(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e, 4) ? true : this.field_145850_b.func_94574_k(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e, 5))))))))));
    }
}

