/*
 * Decompiled with CFR 0.152.
 */
package com.vanhal.progressiveautomation.compat.mods;

import com.vanhal.progressiveautomation.ProgressiveAutomation;
import com.vanhal.progressiveautomation.compat.BaseMod;
import com.vanhal.progressiveautomation.util.OreHelper;
import com.vanhal.progressiveautomation.util.Point3I;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.IGrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class Vanilla
extends BaseMod {
    @Override
    public boolean shouldLoad() {
        this.modID = "Vanilla";
        ProgressiveAutomation.logger.info("Vanilla Loaded");
        return true;
    }

    @Override
    public boolean isSapling(ItemStack stack) {
        return OreHelper.testOre("treeSapling", stack);
    }

    @Override
    public boolean isPlantible(ItemStack item) {
        if (item.func_77973_b() instanceof IPlantable) {
            return true;
        }
        if (item.func_77973_b() == Items.field_151120_aE) {
            return true;
        }
        return Block.func_149634_a((Item)item.func_77973_b()) == Blocks.field_150434_aF;
    }

    @Override
    public boolean shouldHoe(ItemStack item) {
        return item.func_77973_b() instanceof IPlantable;
    }

    @Override
    public boolean isPlant(Block plantBlock, int metadata) {
        if (plantBlock instanceof IGrowable) {
            return true;
        }
        if (plantBlock instanceof BlockNetherWart) {
            return true;
        }
        if (plantBlock == Blocks.field_150436_aH) {
            return true;
        }
        return plantBlock == Blocks.field_150434_aF;
    }

    @Override
    public boolean isGrown(Point3I plantPoint, Block plantBlock, int metadata, World worldObj) {
        if (plantBlock instanceof IGrowable) {
            return !((IGrowable)plantBlock).func_149851_a(worldObj, plantPoint.getX(), plantPoint.getY(), plantPoint.getZ(), true);
        }
        if (plantBlock instanceof BlockNetherWart) {
            return metadata >= 3;
        }
        if (plantBlock == Blocks.field_150436_aH) {
            return worldObj.func_147439_a(plantPoint.getX(), plantPoint.getY() + 1, plantPoint.getZ()) == Blocks.field_150436_aH;
        }
        if (plantBlock == Blocks.field_150434_aF) {
            return worldObj.func_147439_a(plantPoint.getX(), plantPoint.getY() + 1, plantPoint.getZ()) == Blocks.field_150434_aF;
        }
        return false;
    }

    protected Block getPlantBlock(World worldObj, ItemStack itemStack, Point3I point) {
        Block plant = null;
        if (itemStack.func_77973_b() instanceof IPlantable) {
            plant = ((IPlantable)itemStack.func_77973_b()).getPlant((IBlockAccess)worldObj, point.getX(), point.getY(), point.getZ());
        } else if (itemStack.func_77973_b() == Items.field_151120_aE) {
            plant = Blocks.field_150436_aH;
        } else if (Block.func_149634_a((Item)itemStack.func_77973_b()) == Blocks.field_150434_aF) {
            plant = Blocks.field_150434_aF;
        }
        return plant;
    }

    @Override
    public boolean validBlock(World worldObj, ItemStack itemStack, Point3I point) {
        Block plant = this.getPlantBlock(worldObj, itemStack, point);
        if (plant != null) {
            return plant.func_149742_c(worldObj, point.getX(), point.getY(), point.getZ()) && worldObj.func_147439_a(point.getX(), point.getY(), point.getZ()) != plant;
        }
        return false;
    }

    @Override
    public boolean placeSeed(World worldObj, ItemStack itemStack, Point3I point, boolean doAction) {
        Block plant = this.getPlantBlock(worldObj, itemStack, point);
        if (plant != null) {
            if (doAction) {
                worldObj.func_147465_d(point.getX(), point.getY(), point.getZ(), plant, itemStack.func_77973_b().getDamage(itemStack), 7);
            }
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<ItemStack> harvestPlant(Point3I plantPoint, Block plantBlock, int metadata, World worldObj) {
        if (plantBlock == Blocks.field_150436_aH || plantBlock == Blocks.field_150434_aF) {
            plantPoint.setY(plantPoint.getY() + 1);
            plantBlock = worldObj.func_147439_a(plantPoint.getX(), plantPoint.getY(), plantPoint.getZ());
            metadata = worldObj.func_72805_g(plantPoint.getX(), plantPoint.getY(), plantPoint.getZ());
        }
        return super.harvestPlant(plantPoint, plantBlock, metadata, worldObj);
    }
}

