/*
 * Decompiled with CFR 0.152.
 */
package neresources.utils;

import neresources.api.utils.ColorHelper;
import neresources.reference.Resources;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;
import org.lwjgl.opengl.GL11;

public class RenderHelper {
    public static void drawLine(double x1, double y1, double x2, double y2, int color, int precision) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double add = y1 > y2 ? -1.0 : 1.0;
        double error = 0.0;
        double dError = Math.abs(dy * 1.0 / (dx * 1.0)) / (double)precision;
        double y = y1;
        for (double x = x1; x <= x2; x += 1.0 / (double)precision) {
            RenderHelper.drawPoint(x, y, color);
            error += dError;
            while (error >= 0.5 / (double)precision) {
                y += add;
                error -= 1.0;
            }
        }
    }

    public static void drawPoint(double x, double y, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        int scale = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d).func_78325_e();
        GL11.glColor3f((float)ColorHelper.getRed(color), (float)ColorHelper.getGreen(color), (float)ColorHelper.getBlue(color));
        GL11.glPointSize((float)((float)scale * 1.3f));
        GL11.glBegin((int)0);
        GL11.glVertex2d((double)x, (double)y);
        GL11.glEnd();
    }

    public static void renderEntity(int x, int y, float scale, float yaw, float pitch, EntityLivingBase entityLivingBase) {
        if (entityLivingBase.field_70170_p == null) {
            entityLivingBase.field_70170_p = Minecraft.func_71410_x().field_71441_e;
        }
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)50.0f);
        GL11.glScalef((float)(-scale), (float)scale, (float)scale);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float renderYawOffset = entityLivingBase.field_70761_aq;
        float rotationYaw = entityLivingBase.field_70177_z;
        float rotationPitch = entityLivingBase.field_70125_A;
        float prevRotationYawHead = entityLivingBase.field_70758_at;
        float rotationYawHead = entityLivingBase.field_70759_as;
        net.minecraft.client.renderer.RenderHelper.func_74519_b();
        if (entityLivingBase instanceof EntityDragon || entityLivingBase instanceof EntityBat) {
            GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (entityLivingBase instanceof EntityDragon) {
                pitch = 20.0f - pitch;
                GL11.glRotatef((float)(yaw < 90.0f ? (yaw < -90.0f ? 90.0f : -yaw) : -90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                pitch = -pitch;
            }
        }
        if (entityLivingBase instanceof EntitySquid) {
            GL11.glRotatef((float)50.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glRotatef((float)(-((float)Math.atan(pitch / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        entityLivingBase.field_70761_aq = (float)Math.atan(yaw / 40.0f) * 20.0f;
        entityLivingBase.field_70177_z = (float)Math.atan(yaw / 40.0f) * 40.0f;
        entityLivingBase.field_70125_A = -((float)Math.atan(pitch / 40.0f)) * 20.0f;
        entityLivingBase.field_70759_as = entityLivingBase.field_70177_z;
        entityLivingBase.field_70758_at = entityLivingBase.field_70177_z;
        GL11.glTranslatef((float)0.0f, (float)entityLivingBase.field_70129_M, (float)0.0f);
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        String temp = BossStatus.field_82827_c;
        RenderManager.field_78727_a.func_147940_a((Entity)entityLivingBase, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        BossStatus.field_82827_c = temp;
        entityLivingBase.field_70761_aq = renderYawOffset;
        entityLivingBase.field_70177_z = rotationYaw;
        entityLivingBase.field_70125_A = rotationPitch;
        entityLivingBase.field_70758_at = prevRotationYawHead;
        entityLivingBase.field_70759_as = rotationYawHead;
        GL11.glPopMatrix();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
    }

    public static void renderChest(float x, float y, float rotate, float scale, float lidAngle) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Resources.Vanilla.CHEST);
        ModelChest modelchest = new ModelChest();
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)x, (float)y, (float)50.0f);
        GL11.glRotatef((float)-160.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)scale, (float)(-scale), (float)(-scale));
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glRotatef((float)rotate, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float lidAngleF = lidAngle / 180.0f;
        lidAngleF = 1.0f - lidAngleF;
        lidAngleF = 1.0f - lidAngleF * lidAngleF * lidAngleF;
        modelchest.field_78234_a.field_78795_f = -(lidAngleF * (float)Math.PI / 2.0f);
        modelchest.field_78233_c.field_82906_o += 0.1f;
        modelchest.field_78233_c.field_82907_q += 0.12f;
        modelchest.field_78232_b.field_82906_o -= 0.755f;
        modelchest.field_78232_b.field_82908_p -= 0.4f;
        modelchest.field_78232_b.field_82907_q -= 0.9f;
        modelchest.func_78231_a();
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

