/*
 * Decompiled with CFR 0.152.
 */
package neresources.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.LinkedList;
import java.util.List;
import neresources.config.Settings;
import neresources.entries.EnchantmentEntry;
import neresources.reference.Resources;
import neresources.registry.EnchantmentRegistry;
import neresources.utils.Font;
import neresources.utils.TranslationHelper;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class NEIEnchantmentHandler
extends TemplateRecipeHandler {
    private static final int ITEM_X = 8;
    private static final int ITEM_Y = 6;
    private static final int ENTRYS_PER_PAGE = 11;
    private static final int ENCHANT_X = 30;
    private static final int FIRST_ENCHANT_Y = 5;
    private static final int SPACING_Y = 10;
    private static final int PAGE_X = 55;
    private static final int PAGE_Y = 120;
    private static int CYCLE_TIME = (int)(20.0f * Settings.CYCLE_TIME);

    public static void reloadSettings() {
        CYCLE_TIME = (int)(20.0f * Settings.CYCLE_TIME);
    }

    public String getGuiTexture() {
        return Resources.Gui.Nei.ENCHANTMENT.toString();
    }

    public String getRecipeName() {
        return TranslationHelper.translateToLocal("ner.enchantments.title");
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)130);
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (EnchantmentRegistry.getInstance().getEnchantments(ingredient).size() > 0) {
            this.arecipes.add(new CachedEnchantment(ingredient));
        }
    }

    public void drawExtras(int recipe) {
        CachedEnchantment cachedEnchantment = (CachedEnchantment)((Object)this.arecipes.get(recipe));
        Font font = new Font(false);
        int y = 5;
        for (EnchantmentEntry enchantment : cachedEnchantment.getEnchantments()) {
            font.print(enchantment.getTranslatedWithLevels(), 30, y);
            y += 10;
        }
        if (cachedEnchantment.lastSet > 0) {
            String toPrint = TranslationHelper.translateToLocal("ner.page") + " " + (cachedEnchantment.set + 1) + " " + TranslationHelper.translateToLocal("ner.of") + " " + (cachedEnchantment.lastSet + 1);
            font.print(toPrint, 55, 120);
        }
        cachedEnchantment.cycleOutput(this.cycleticks);
    }

    public class CachedEnchantment
    extends TemplateRecipeHandler.CachedRecipe {
        private ItemStack itemStack;
        private List<EnchantmentEntry> enchantments;
        public int set;
        public int lastSet;
        private long cycleAt;

        public CachedEnchantment(ItemStack itemStack) {
            super((TemplateRecipeHandler)NEIEnchantmentHandler.this);
            this.itemStack = itemStack;
            this.enchantments = new LinkedList<EnchantmentEntry>(EnchantmentRegistry.getInstance().getEnchantments(itemStack));
            this.set = 0;
            this.lastSet = this.enchantments.size() / 12;
            this.cycleAt = -1L;
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.itemStack, 8, 6);
        }

        public List<EnchantmentEntry> getEnchantments() {
            int last = this.set * 11 + 11;
            if (last >= this.enchantments.size()) {
                last = this.enchantments.size() - 1;
            }
            return this.enchantments.subList(this.set * 11, last);
        }

        public void cycleOutput(long tick) {
            if (this.cycleAt == -1L) {
                this.cycleAt = tick + (long)CYCLE_TIME;
            }
            if (tick >= this.cycleAt) {
                if (++this.set > this.lastSet) {
                    this.set = 0;
                }
                this.cycleAt += (long)CYCLE_TIME;
            }
        }
    }
}

