/*
 * Decompiled with CFR 0.152.
 */
package neresources.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.List;
import neresources.api.utils.PlantDrop;
import neresources.config.Settings;
import neresources.entries.PlantEntry;
import neresources.reference.Resources;
import neresources.registry.PlantRegistry;
import neresources.utils.Font;
import neresources.utils.TranslationHelper;
import net.minecraft.item.ItemStack;

public class NEIAdvSeedHandler
extends TemplateRecipeHandler {
    private static final int Y = 16;
    private static int CYCLE_TIME = (int)(20.0f * Settings.CYCLE_TIME);

    public static void reloadSettings() {
        CYCLE_TIME = (int)(20.0f * Settings.CYCLE_TIME);
    }

    public String getGuiTexture() {
        return Resources.Gui.Nei.ADV_PLANT.toString();
    }

    public String getRecipeName() {
        return TranslationHelper.translateToLocal("ner.advPlant.title");
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(60, 15, 28, 18), "neresources.plant", new Object[]{new Object()}));
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (ingredients.length == 0) {
            return;
        }
        if (ingredients[0] instanceof ItemStack) {
            ItemStack ingredient = (ItemStack)ingredients[0];
            if (PlantRegistry.getInstance().contains(ingredient)) {
                this.arecipes.add(new CachedPlant(PlantRegistry.getInstance().getEntry(ingredient)));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("neresources.plant")) {
            for (PlantEntry entry : PlantRegistry.getInstance().getAllPlants()) {
                this.arecipes.add(new CachedPlant(entry));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (PlantRegistry.getInstance().containsDrop(result)) {
            this.arecipes.add(new CachedSeed(result));
        }
    }

    public void drawExtras(int recipe) {
        String toPrint;
        CachedAbstract cachedAbstract = (CachedAbstract)((Object)this.arecipes.get(recipe));
        float chance = cachedAbstract.getChance();
        if (Float.isNaN(chance)) {
            int[] minMax = cachedAbstract.getMinMax();
            toPrint = minMax[0] + " - " + minMax[1];
        } else {
            toPrint = String.format("%2.2f", Float.valueOf(chance * 100.0f)).replace(",", ".") + "%";
        }
        Font font = new Font(false);
        font.print(toPrint, 56, 36);
        cachedAbstract.cycleOutput(this.cycleticks);
    }

    public class CachedPlant
    extends CachedAbstract {
        private PlantEntry entry;

        public CachedPlant(PlantEntry entry) {
            super(entry.getDrops().size());
            this.entry = entry;
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.entry.getPlant(), 34, 16);
        }

        public PositionedStack getOtherStack() {
            return new PositionedStack((Object)this.entry.getDrops().get(this.i).getDrop(), 94, 16);
        }

        @Override
        public float getChance() {
            PlantDrop drop = this.entry.getDrops().get(this.i);
            switch (drop.getDropKind()) {
                case chance: {
                    return drop.getChance();
                }
                case weight: {
                    return (float)drop.getWeight() / (float)this.entry.getTotalWeight();
                }
                case minMax: {
                    return Float.NaN;
                }
            }
            return 0.0f;
        }

        @Override
        public int[] getMinMax() {
            PlantDrop drop = this.entry.getDrops().get(this.i);
            return new int[]{drop.getMinDrop(), drop.getMaxDrop()};
        }
    }

    public class CachedSeed
    extends CachedAbstract {
        private List<PlantEntry> entrys;
        private ItemStack seed;

        public CachedSeed(ItemStack seed) {
            super(PlantRegistry.getInstance().getEntriesForDrop(seed).size());
            this.seed = seed;
            this.entrys = PlantRegistry.getInstance().getEntriesForDrop(seed);
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.entrys.get(this.i).getPlant(), 34, 16);
        }

        public PositionedStack getOtherStack() {
            return new PositionedStack((Object)this.seed, 94, 16);
        }

        @Override
        public float getChance() {
            PlantEntry entry = this.entrys.get(this.i);
            PlantDrop drop = entry.getDrop(this.seed);
            switch (drop.getDropKind()) {
                case chance: {
                    return drop.getChance();
                }
                case weight: {
                    return (float)drop.getWeight() / (float)entry.getTotalWeight();
                }
                case minMax: {
                    return Float.NaN;
                }
            }
            return 0.0f;
        }

        @Override
        public int[] getMinMax() {
            PlantEntry entry = this.entrys.get(this.i);
            PlantDrop drop = entry.getDrop(this.seed);
            return new int[]{drop.getMinDrop(), drop.getMaxDrop()};
        }
    }

    public abstract class CachedAbstract
    extends TemplateRecipeHandler.CachedRecipe {
        protected int i;
        protected int lastI;
        protected long cycleAt;

        public CachedAbstract(int size) {
            super((TemplateRecipeHandler)NEIAdvSeedHandler.this);
            this.i = 0;
            this.lastI = size;
            this.cycleAt = -1L;
        }

        public void cycleOutput(long tick) {
            if (this.cycleAt == -1L) {
                this.cycleAt = tick + (long)CYCLE_TIME;
            }
            if (this.cycleAt <= tick) {
                if (++this.i >= this.lastI) {
                    this.i = 0;
                }
                this.cycleAt += (long)CYCLE_TIME;
            }
        }

        public abstract float getChance();

        public abstract int[] getMinMax();
    }
}

