/*
 * Decompiled with CFR 0.152.
 */
package neresources.compatibility.tinkersconstruct;

import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.List;
import neresources.api.distributions.DistributionBase;
import neresources.api.distributions.DistributionCustom;
import neresources.api.distributions.DistributionSquare;
import neresources.api.distributions.DistributionTriangular;
import neresources.api.messages.ModifyMobMessage;
import neresources.api.messages.ModifyOreMessage;
import neresources.api.messages.RegisterOreMessage;
import neresources.api.utils.DistributionHelpers;
import neresources.api.utils.DropItem;
import neresources.api.utils.LightLevel;
import neresources.api.utils.Modifier;
import neresources.api.utils.Priority;
import neresources.api.utils.conditionals.Conditional;
import neresources.api.utils.restrictions.BiomeRestriction;
import neresources.api.utils.restrictions.BlockRestriction;
import neresources.api.utils.restrictions.Restriction;
import neresources.compatibility.CompatBase;
import neresources.entries.MobEntry;
import neresources.registry.MessageRegistry;
import neresources.registry.OreRegistry;
import neresources.utils.MapKeys;
import neresources.utils.TranslationHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.armor.TinkerArmor;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.ToolCore;
import tconstruct.tools.TinkerTools;
import tconstruct.util.config.PHConstruct;
import tconstruct.world.TinkerWorld;
import tconstruct.world.entity.BlueSlime;

public class TiConCompat
extends CompatBase {
    private Block slagBlock;
    ItemStack[] bushes;
    ItemStack[] gravel = new ItemStack[6];

    @Override
    protected void init() {
        this.register();
    }

    @Optional.Method(modid="TConstruct")
    private void register() {
        int i;
        this.slagBlock = TinkerWorld.oreSlag;
        this.bushes = new ItemStack[]{new ItemStack((Block)TinkerWorld.oreBerry, 1, 12), new ItemStack((Block)TinkerWorld.oreBerry, 1, 13), new ItemStack((Block)TinkerWorld.oreBerry, 1, 14), new ItemStack((Block)TinkerWorld.oreBerry, 1, 15), new ItemStack((Block)TinkerWorld.oreBerrySecond, 1, 12), new ItemStack((Block)TinkerWorld.oreBerrySecond, 1, 13)};
        for (i = 0; i < this.bushes.length; ++i) {
            MessageRegistry.addMessage(new ModifyOreMessage(this.bushes[i], Priority.FIRST, new ItemStack(TinkerWorld.oreBerries, 1, i)));
        }
        for (i = 0; i < 6; ++i) {
            this.gravel[i] = new ItemStack(TinkerWorld.oreGravel, 1, i);
        }
        if (PHConstruct.generateCopper) {
            this.generateUnderground(new ItemStack(this.slagBlock, 1, 3), PHConstruct.copperuDensity, PHConstruct.copperuMinY, PHConstruct.copperuMaxY, 8);
        }
        if (PHConstruct.generateTin) {
            this.generateUnderground(new ItemStack(this.slagBlock, 1, 4), PHConstruct.tinuDensity, PHConstruct.tinuMinY, PHConstruct.tinuMaxY, 8);
        }
        if (PHConstruct.generateAluminum) {
            this.generateUnderground(new ItemStack(this.slagBlock, 1, 5), PHConstruct.aluminumuDensity, PHConstruct.aluminumuMinY, PHConstruct.aluminumuMaxY, 6);
        }
        if (PHConstruct.generateNetherOres) {
            this.generateNetherOres();
        }
        if (PHConstruct.generateIronBush) {
            this.generateOreBush(this.bushes[0], PHConstruct.ironBushDensity, PHConstruct.ironBushDensity, this.getAverageSize(12), 32, 32);
        }
        if (PHConstruct.generateGoldBush) {
            this.generateOreBush(this.bushes[1], PHConstruct.goldBushDensity, PHConstruct.goldBushDensity, this.getAverageSize(6), 32, 32);
        }
        if (PHConstruct.generateCopperBush) {
            this.generateOreBush(this.bushes[2], PHConstruct.copperBushDensity, PHConstruct.copperBushDensity, this.getAverageSize(12), 32, 32);
        }
        if (PHConstruct.generateTinBush) {
            this.generateOreBush(this.bushes[3], PHConstruct.tinBushDensity, PHConstruct.tinBushDensity, this.getAverageSize(12), 32, 32);
        }
        if (PHConstruct.generateAluminumBush) {
            this.generateOreBush(this.bushes[4], PHConstruct.aluminumBushDensity, PHConstruct.aluminumBushDensity, this.getAverageSize(14), 32, 32);
        }
        if (PHConstruct.generateEssenceBush) {
            this.generateOreBush(this.bushes[5], PHConstruct.essenceBushRarity, PHConstruct.essenceBushRarity, this.getAverageSize(12), 32, 32);
        }
        if (PHConstruct.enableTBlueSlime) {
            this.registerBlueSlimes();
        }
        this.registerDropChanges();
    }

    private float getAverageSize(int chance) {
        float result = 0.0f;
        for (int i = 0; i < chance; ++i) {
            if (i == 11) {
                result += 6.75f;
            }
            if (i >= 5) {
                result += 3.0f;
                continue;
            }
            result += 1.5f;
        }
        return result / (float)chance;
    }

    private void generateSurface(ItemStack ore, int rarity, int veinSize) {
        float chanceToSpawn = 1.0f / (float)rarity;
        float numOres = 0.7f * (float)veinSize;
        double cubeLength = Math.pow(numOres, 0.3333);
        float[] distribution = DistributionHelpers.getOverworldSurfaceDistribution(this.round(cubeLength));
        distribution = DistributionHelpers.multiplyArray(distribution, chanceToSpawn);
        this.registerOre(new RegisterOreMessage(ore, (DistributionBase)new DistributionCustom(distribution), new ItemStack[0]));
    }

    private int round(double val) {
        if (val % 1.0 > 0.5) {
            return (int)Math.ceil(val);
        }
        return (int)Math.floor(val);
    }

    private void generateOreBush(ItemStack bush, int density, int rarity, float averageSize, int midY, int var) {
        float chanceToSpawn = (float)density / (float)rarity;
        float numBushesPerChunk = averageSize * chanceToSpawn;
        float maxChance = numBushesPerChunk / (256.0f * (float)(2 * var + 1));
        this.registerOre(new RegisterOreMessage(bush, (DistributionBase)new DistributionTriangular(midY, var, maxChance), new ItemStack[0]));
        OreRegistry.addOreLink(MapKeys.getKey(new ItemStack(bush.func_77973_b(), 1, bush.func_77960_j() - 4)), MapKeys.getKey(bush));
    }

    private void generateUnderground(ItemStack ore, int numVeins, int minY, int maxY, int veinSize) {
        float chance = (float)numVeins * (float)veinSize / (float)((maxY - minY + 1) * 256);
        this.registerOre(new RegisterOreMessage(ore, (DistributionBase)new DistributionSquare(Math.max(0, minY - veinSize / 2), minY, maxY, Math.min(maxY + veinSize / 2, 255), chance), new ItemStack[0]));
        this.registerOre(new RegisterOreMessage(ore, (DistributionBase)new DistributionSquare(Math.max(0, minY - veinSize / 2), minY, maxY, Math.min(maxY + veinSize / 2, 255), chance), new Restriction(BlockRestriction.STONE, BiomeRestriction.EXTREME_HILLS), new ItemStack[0]));
    }

    @Optional.Method(modid="TConstruct")
    private void generateNetherOres() {
        int netherDensity = PHConstruct.netherDensity;
        ItemStack ardite = new ItemStack(this.slagBlock, 1, 1);
        ItemStack cobalt = new ItemStack(this.slagBlock, 1, 2);
        int veinSize = 3;
        int minY = 32;
        int maxY = 96;
        float chance = (float)netherDensity * (float)veinSize / (float)((maxY - minY + 1) * 256);
        float[] distribution = DistributionHelpers.getRoundedSquareDistribution(Math.max(0, minY - veinSize / 2), minY, maxY, Math.min(maxY + veinSize / 2, 127), chance);
        chance = (float)netherDensity * (float)veinSize / 32768.0f;
        DistributionHelpers.addDistribution(distribution, DistributionHelpers.getSquareDistribution(0, 127, chance));
        this.registerOre(new RegisterOreMessage(ardite, (DistributionBase)new DistributionCustom(distribution), Restriction.NETHER_LIKE, new ItemStack[0]));
        this.registerOre(new RegisterOreMessage(cobalt, (DistributionBase)new DistributionCustom(distribution), Restriction.NETHER_LIKE, new ItemStack[0]));
    }

    @Optional.Method(modid="TConstruct")
    private void registerBlueSlimes() {
        Conditional scalesWithSlimeSize = new Conditional("ner.slimeScale.text", new Modifier[0]);
        Conditional kingSlimeOnly = new Conditional("ner.kingSlime.text", Modifier.darkBlue);
        List<ItemStack> toolDrops = this.getTinkerTools();
        DropItem[] toolDropItems = new DropItem[toolDrops.size() + 3];
        toolDropItems[0] = new DropItem(new ItemStack(TinkerWorld.strangeFood, 1), 0, 10, scalesWithSlimeSize);
        toolDropItems[1] = new DropItem(new ItemStack(TinkerArmor.heartCanister, 1, 1), 1, 1, 0.2f, kingSlimeOnly);
        toolDropItems[2] = new DropItem(new ItemStack(TinkerArmor.heartCanister, 1, 3), 1, 1, kingSlimeOnly);
        for (int i = 0; i < toolDrops.size(); ++i) {
            toolDropItems[i + 3] = new DropItem(toolDrops.get(i), 1, 1, 1.0f / (float)toolDrops.size(), kingSlimeOnly);
        }
        this.registerMob(new MobEntry((EntityLivingBase)new BlueSlime(world), LightLevel.any, toolDropItems));
    }

    @Optional.Method(modid="TConstruct")
    private List<ItemStack> getTinkerTools() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < TConstructRegistry.tools.size(); ++i) {
            String loc;
            String name;
            ItemStack extraStack;
            ItemStack accessoryStack;
            ItemStack handleStack;
            ToolCore tool = (ToolCore)TConstructRegistry.tools.get(i);
            ItemStack headStack = new ItemStack(tool.getHeadItem(), 1, 17);
            ItemStack toolStack = ToolBuilder.instance.buildTool(headStack, handleStack = new ItemStack(tool.getHandleItem(), 1, 17), accessoryStack = tool.getAccessoryItem() != null ? new ItemStack(tool.getAccessoryItem(), 1, 17) : null, extraStack = tool.getExtraItem() != null ? new ItemStack(tool.getExtraItem(), 1, 17) : null, name = TranslationHelper.canTranslate(loc = "tool." + tool.getToolName().toLowerCase() + ".kingslime") ? TranslationHelper.translateToLocal(loc) : TranslationHelper.translateToLocal("tool.kingslimeprefix") + " " + tool.getLocalizedToolName());
            if (toolStack == null) continue;
            NBTTagCompound tags = toolStack.func_77978_p().func_74775_l("InfiTool");
            tags.func_74768_a("Attack", 5 + tool.getDamageVsEntity(null));
            tags.func_74768_a("TotalDurability", 2500);
            tags.func_74768_a("BaseDurability", 2500);
            tags.func_74768_a("MiningSpeed", 1400);
            result.add(toolStack);
        }
        return result;
    }

    @Optional.Method(modid="TConstruct")
    private void registerDropChanges() {
        Conditional beheading = new Conditional("ner.beheading.text", Modifier.orange);
        MessageRegistry.addMessage(new ModifyMobMessage(EntityDragon.class, true, Priority.FIRST, new DropItem(new ItemStack(TinkerArmor.heartCanister, 1, 3), 5, 5, Conditional.playerKill)));
        MessageRegistry.addMessage(new ModifyMobMessage(IBossDisplayData.class, false, new DropItem(new ItemStack(TinkerArmor.heartCanister, 1, 3), 1, 1, Conditional.playerKill)));
        MessageRegistry.addMessage(new ModifyMobMessage(IMob.class, new DropItem(new ItemStack(TinkerArmor.heartCanister, 1, 1), 1, 1, 0.025f, Conditional.playerKill, Conditional.rareDrop)));
        Class[] entityClasses = new Class[]{EntitySkeleton.class, EntitySkeleton.class, EntityZombie.class, EntityCreeper.class};
        for (int i = 0; i < entityClasses.length; ++i) {
            ItemStack[] itemStackArray;
            Class clazz = entityClasses[i];
            boolean bl = i == 1;
            DropItem[] dropItemArray = new DropItem[]{new DropItem(new ItemStack(Items.field_151144_bL, 1, i + (i == 3 ? 1 : 0)), 0, 1, Conditional.playerKill, beheading)};
            if (i == 1) {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(Items.field_151144_bL, 1, 1);
            } else {
                itemStackArray = new ItemStack[]{};
            }
            MessageRegistry.addMessage(new ModifyMobMessage(clazz, true, bl, dropItemArray, itemStackArray, Priority.THIRD, Priority.SECOND));
        }
        MessageRegistry.addMessage(new ModifyMobMessage(EntitySkeleton.class, true, true, new DropItem(new ItemStack(TinkerTools.materials, 1, 8), 1, 1, 0.2f, new Conditional[0])));
    }
}

