/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.util.handler.event;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.annot.Handler;
import WayofTime.bloodmagic.api.network.SoulNetwork;
import WayofTime.bloodmagic.api.saving.BMWorldSavedData;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.FileUtils;

@Handler
public class MigrateNetworkDataHandler {
    @SubscribeEvent
    public void playerJoin(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            UUID playerId = PlayerHelper.getUUIDFromPlayer(player);
            Stopwatch stopwatch = Stopwatch.createStarted();
            if (event.getWorld().func_175693_T() == null) {
                return;
            }
            BMWorldSavedData saveData = (BMWorldSavedData)event.getWorld().func_175693_T().func_75742_a(BMWorldSavedData.class, "BloodMagic-SoulNetworks");
            SoulNetwork oldData = (SoulNetwork)event.getWorld().func_175693_T().func_75742_a(SoulNetwork.class, playerId.toString());
            if (saveData == null) {
                saveData = new BMWorldSavedData();
                event.getWorld().func_175693_T().func_75745_a("BloodMagic-SoulNetworks", (WorldSavedData)saveData);
            }
            if (oldData == null) {
                return;
            }
            WayofTime.bloodmagic.api.saving.SoulNetwork network = saveData.getNetwork(playerId);
            if (oldData.getOrbTier() > network.getOrbTier()) {
                network.setOrbTier(oldData.getOrbTier());
            }
            if (oldData.getCurrentEssence() > network.getCurrentEssence()) {
                network.setCurrentEssence(oldData.getCurrentEssence());
            }
            File oldDataFile = event.getWorld().func_72860_G().func_75758_b(playerId.toString());
            try {
                FileUtils.forceDelete((File)oldDataFile);
            }
            catch (IOException e) {
                BloodMagic.instance.getLogger().error("Error deleting data file {}.", oldDataFile);
                BloodMagic.instance.getLogger().error(e.getLocalizedMessage(), new Object[0]);
            }
            stopwatch.stop();
            BloodMagic.instance.getLogger().info("Migration completed for {} ({}) in {}.", player.getDisplayNameString(), playerId, stopwatch);
        }
    }
}

