/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class RitualPlacer
extends Ritual {
    public static final String PLACER_RANGE = "placerRange";
    public static final String CHEST_RANGE = "chest";

    public RitualPlacer() {
        super("ritualPlacer", 0, 5000, "ritual.BloodMagic.placerRitual");
        this.addBlockRange(PLACER_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-2, 0, -2), 5, 1, 5));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(PLACER_RANGE, 300, 7, 7);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        block7: {
            AreaDescriptor areaDescriptor;
            TileEntity tileEntity;
            World world;
            block8: {
                world = masterRitualStone.getWorldObj();
                BlockPos masterPos = masterRitualStone.getBlockPos();
                AreaDescriptor chestRange = this.getBlockRange(CHEST_RANGE);
                tileEntity = world.func_175625_s(chestRange.getContainedPositions(masterPos).get(0));
                int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
                if (currentEssence < this.getRefreshCost()) {
                    masterRitualStone.getOwnerNetwork().causeNausea();
                    return;
                }
                areaDescriptor = this.getBlockRange(PLACER_RANGE);
                if (tileEntity == null) break block7;
                if (!tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) break block8;
                IItemHandler iItemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
                if (iItemHandler.getSlots() <= 0) {
                    return;
                }
                for (BlockPos blockPos : areaDescriptor.getContainedPositions(masterRitualStone.getBlockPos())) {
                    for (int inv = 0; inv < iItemHandler.getSlots(); ++inv) {
                        if (!world.func_180495_p(blockPos).func_177230_c().func_176200_f((IBlockAccess)world, blockPos) || iItemHandler.getStackInSlot(inv) == null || iItemHandler.getStackInSlot((int)inv).field_77994_a == 0 || !(iItemHandler.getStackInSlot(inv).func_77973_b() instanceof ItemBlock) || world.func_180495_p(blockPos.func_177977_b()) == null || iItemHandler.extractItem(inv, 1, true) == null) continue;
                        world.func_175656_a(blockPos, Block.func_149634_a((Item)iItemHandler.getStackInSlot(inv).func_77973_b()).func_176203_a(iItemHandler.getStackInSlot(inv).func_77952_i()));
                        iItemHandler.extractItem(inv, 1, false);
                        tileEntity.func_70296_d();
                        masterRitualStone.getOwnerNetwork().syphon(this.getRefreshCost());
                    }
                }
                break block7;
            }
            if (!(tileEntity instanceof IInventory)) break block7;
            IInventory iInventory = (IInventory)tileEntity;
            if (iInventory.func_70302_i_() <= 0) {
                return;
            }
            block2: for (BlockPos blockPos : areaDescriptor.getContainedPositions(masterRitualStone.getBlockPos())) {
                for (int inv = 0; inv < iInventory.func_70302_i_(); ++inv) {
                    if (!world.func_180495_p(blockPos).func_177230_c().func_176200_f((IBlockAccess)world, blockPos) || iInventory.func_70301_a(inv) == null || iInventory.func_70301_a((int)inv).field_77994_a == 0 || !(iInventory.func_70301_a(inv).func_77973_b() instanceof ItemBlock) || world.func_180495_p(blockPos.func_177977_b()) == null) continue;
                    world.func_175656_a(blockPos, Block.func_149634_a((Item)iInventory.func_70301_a(inv).func_77973_b()).func_176203_a(iInventory.func_70301_a(inv).func_77952_i()));
                    iInventory.func_70298_a(inv, 1);
                    iInventory.func_70296_d();
                    masterRitualStone.getOwnerNetwork().syphon(this.getRefreshCost());
                    continue block2;
                }
            }
        }
    }

    @Override
    public int getRefreshCost() {
        return 50;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addRune(components, 3, 0, 3, EnumRuneType.EARTH);
        this.addRune(components, 3, 0, -3, EnumRuneType.EARTH);
        this.addRune(components, -3, 0, 3, EnumRuneType.EARTH);
        this.addRune(components, -3, 0, -3, EnumRuneType.EARTH);
        this.addRune(components, 3, 0, 2, EnumRuneType.WATER);
        this.addRune(components, 3, 0, -2, EnumRuneType.WATER);
        this.addRune(components, 2, 0, 3, EnumRuneType.WATER);
        this.addRune(components, 2, 0, -3, EnumRuneType.WATER);
        this.addRune(components, -2, 0, 3, EnumRuneType.WATER);
        this.addRune(components, -2, 0, -3, EnumRuneType.WATER);
        this.addRune(components, -3, 0, 2, EnumRuneType.WATER);
        this.addRune(components, -3, 0, -2, EnumRuneType.WATER);
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualPlacer();
    }
}

