/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.demonAura;

import WayofTime.bloodmagic.api.BloodMagicAPI;
import WayofTime.bloodmagic.api.soul.DemonWillHolder;
import WayofTime.bloodmagic.api.soul.EnumDemonWillType;
import WayofTime.bloodmagic.demonAura.PosXY;
import WayofTime.bloodmagic.demonAura.WillChunk;
import WayofTime.bloodmagic.demonAura.WillWorld;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class WorldDemonWillHandler {
    static ConcurrentHashMap<Integer, WillWorld> containedWills = new ConcurrentHashMap();
    public static ConcurrentHashMap<Integer, CopyOnWriteArrayList<PosXY>> dirtyChunks = new ConcurrentHashMap();

    public static DemonWillHolder getWillHolder(int dim, int x, int y) {
        WillChunk chunk = WorldDemonWillHandler.getWillChunk(dim, x, y);
        if (chunk != null) {
            return chunk.getCurrentWill();
        }
        return null;
    }

    public static DemonWillHolder getWillHolder(World world, BlockPos pos) {
        return WorldDemonWillHandler.getWillHolder(world.field_73011_w.getDimension(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    public static WillWorld getWillWorld(int dim) {
        return containedWills.get(dim);
    }

    public static WillChunk getWillChunk(int dim, int x, int y) {
        if (!containedWills.containsKey(dim)) {
            WorldDemonWillHandler.addWillWorld(dim);
        }
        return containedWills.get(dim).getWillChunkAt(x, y);
    }

    public static void addWillWorld(int dim) {
        if (!containedWills.containsKey(dim)) {
            containedWills.put(dim, new WillWorld(dim));
            BloodMagicAPI.getLogger().info("Creating demon will cache for world " + dim, new Object[0]);
        }
    }

    public static void removeWillWorld(int dim) {
        containedWills.remove(dim);
        BloodMagicAPI.getLogger().info("Removing demon will cache for world " + dim, new Object[0]);
    }

    public static void addWillChunk(int dim, Chunk chunk, short base, DemonWillHolder currentWill) {
        WillWorld aw = containedWills.get(dim);
        if (aw == null) {
            aw = new WillWorld(dim);
        }
        aw.getWillChunks().put(new PosXY(chunk.field_76635_g, chunk.field_76647_h), new WillChunk(chunk, base, currentWill));
        containedWills.put(dim, aw);
    }

    public static void removeWillChunk(int dim, int x, int y) {
        WillChunk chunk;
        WillWorld aw = containedWills.get(dim);
        if (aw != null && (chunk = aw.getWillChunks().remove(new PosXY(x, y))) != null) {
            WorldDemonWillHandler.markChunkAsDirty(chunk, dim);
        }
    }

    public static EnumDemonWillType getHighestDemonWillType(World world, BlockPos pos) {
        double currentMax = 0.0;
        EnumDemonWillType currentHighest = EnumDemonWillType.DEFAULT;
        WillChunk willChunk = WorldDemonWillHandler.getWillChunk(world, pos);
        DemonWillHolder currentWill = willChunk.getCurrentWill();
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            if (!(currentWill.getWill(type) > currentMax)) continue;
            currentMax = currentWill.getWill(type);
            currentHighest = type;
        }
        return currentHighest;
    }

    public static double drainWill(World world, BlockPos pos, EnumDemonWillType type, double amount, boolean doDrain) {
        WillChunk willChunk = WorldDemonWillHandler.getWillChunk(world, pos);
        DemonWillHolder currentWill = willChunk.getCurrentWill();
        double drain = Math.min(currentWill.getWill(type), amount);
        if (!doDrain) {
            return drain;
        }
        drain = currentWill.drainWill(type, drain);
        WorldDemonWillHandler.markChunkAsDirty(willChunk, world.field_73011_w.getDimension());
        return drain;
    }

    public static double fillWillToMaximum(World world, BlockPos pos, EnumDemonWillType type, double amount, double max, boolean doFill) {
        WillChunk willChunk = WorldDemonWillHandler.getWillChunk(world, pos);
        DemonWillHolder currentWill = willChunk.getCurrentWill();
        double fill = Math.min(amount, max - currentWill.getWill(type));
        if (!doFill || fill <= 0.0) {
            return fill > 0.0 ? fill : 0.0;
        }
        fill = currentWill.addWill(type, amount, max);
        WorldDemonWillHandler.markChunkAsDirty(willChunk, world.field_73011_w.getDimension());
        return fill;
    }

    public static double fillWill(World world, BlockPos pos, EnumDemonWillType type, double amount, boolean doFill) {
        WillChunk willChunk = WorldDemonWillHandler.getWillChunk(world, pos);
        DemonWillHolder currentWill = willChunk.getCurrentWill();
        if (!doFill) {
            return amount;
        }
        currentWill.addWill(type, amount);
        WorldDemonWillHandler.markChunkAsDirty(willChunk, world.field_73011_w.getDimension());
        return amount;
    }

    public static WillChunk getWillChunk(World world, BlockPos pos) {
        WillChunk willChunk = WorldDemonWillHandler.getWillChunk(world.field_73011_w.getDimension(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (willChunk == null) {
            Chunk chunk = world.func_175726_f(pos);
            WorldDemonWillHandler.generateWill(chunk);
            willChunk = WorldDemonWillHandler.getWillChunk(world.field_73011_w.getDimension(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        }
        return willChunk;
    }

    public static double getCurrentWill(World world, BlockPos pos, EnumDemonWillType type) {
        WillChunk willChunk = WorldDemonWillHandler.getWillChunk(world, pos);
        if (willChunk == null) {
            return 0.0;
        }
        DemonWillHolder currentWill = willChunk.getCurrentWill();
        return currentWill.getWill(type);
    }

    private static void markChunkAsDirty(WillChunk chunk, int dim) {
        CopyOnWriteArrayList<PosXY> dc;
        if (chunk.isModified()) {
            return;
        }
        PosXY pos = new PosXY(chunk.loc.x, chunk.loc.y);
        if (!dirtyChunks.containsKey(dim)) {
            dirtyChunks.put(dim, new CopyOnWriteArrayList());
        }
        if (!(dc = dirtyChunks.get(dim)).contains(pos)) {
            dc.add(pos);
        }
    }

    public static void generateWill(Chunk chunk) {
        WorldDemonWillHandler.addWillChunk(chunk.func_177412_p().field_73011_w.getDimension(), chunk, (short)1, new DemonWillHolder());
    }
}

