/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.texture;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import team.chisel.api.render.IBlockRenderContext;
import team.chisel.api.render.TextureInfo;
import team.chisel.client.render.Quad;
import team.chisel.client.render.ctm.CTM;
import team.chisel.client.render.ctm.ISubmap;
import team.chisel.client.render.ctx.CTMBlockRenderContext;
import team.chisel.client.render.texture.AbstractChiselTexture;
import team.chisel.client.render.type.BlockRenderTypeCTMH;
import team.chisel.common.util.Dir;

public class ChiselTextureCTMH
extends AbstractChiselTexture<BlockRenderTypeCTMH> {
    public ChiselTextureCTMH(BlockRenderTypeCTMH type, TextureInfo info) {
        super(type, info);
    }

    @Override
    public List<BakedQuad> transformQuad(BakedQuad quad, IBlockRenderContext context, int quadGoal) {
        Quad q = Quad.from(quad).setFullbright(this.fullbright);
        if (quad.func_178210_d().func_176740_k().func_176720_b()) {
            q = q.transformUVs(this.sprites[0].getSprite());
        } else {
            CTM ctm = context == null ? null : ((CTMBlockRenderContext)context).getCTM(quad.func_178210_d());
            ISubmap submap = this.getQuad(ctm);
            q = q.transformUVs(this.sprites[1].getSprite(), submap);
        }
        return Collections.singletonList(q.rebake());
    }

    private ISubmap getQuad(CTM ctm) {
        if (ctm == null || !ctm.connectedOr(Dir.LEFT, Dir.RIGHT)) {
            return Quad.TOP_LEFT;
        }
        if (ctm.connectedAnd(Dir.LEFT, Dir.RIGHT)) {
            return Quad.TOP_RIGHT;
        }
        if (ctm.connected(Dir.LEFT)) {
            return Quad.BOTTOM_RIGHT;
        }
        return Quad.BOTTOM_LEFT;
    }
}

