/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class ArcRecyclingRecipe
extends ArcFurnaceRecipe {
    HashMap<ItemStack, Double> outputs;

    public ArcRecyclingRecipe(HashMap<ItemStack, Double> outputs, Object input, int time, int energyPerTick) {
        super(null, input, null, time, energyPerTick, new Object[0]);
        this.outputs = outputs;
        this.setSpecialRecipeType("Recycling");
        this.outputList = Lists.newArrayList();
        for (Map.Entry<ItemStack, Double> e : outputs.entrySet()) {
            String[] type;
            int nuggetOut;
            double scaledOut = e.getValue();
            if (scaledOut >= 1.0) {
                this.outputList.add(Utils.copyStackWithAmount(e.getKey(), (int)scaledOut));
            }
            if ((nuggetOut = (int)((scaledOut - (double)((int)scaledOut)) * 9.0)) <= 0 || (type = ApiUtils.getMetalComponentTypeAndMetal(e.getKey(), "ingot")) == null) continue;
            ItemStack nuggets = IEApi.getPreferredOreStack("nugget" + type[1]);
            this.outputList.add(Utils.copyStackWithAmount(nuggets, nuggetOut));
        }
    }

    @Override
    public List<ItemStack> getOutputs(ItemStack input, ItemStack[] additives) {
        if (this.outputs == null) {
            return Lists.newArrayList();
        }
        float mod = !input.func_77973_b().func_77645_m() ? 1.0f : (float)(input.func_77958_k() - input.func_77952_i()) / (float)input.func_77958_k();
        ArrayList<ItemStack> outs = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, Double> e : this.outputs.entrySet()) {
            String[] type;
            int nuggetOut;
            double scaledOut = (double)mod * e.getValue();
            if (scaledOut >= 1.0) {
                outs.add(Utils.copyStackWithAmount(e.getKey(), (int)scaledOut));
            }
            if ((nuggetOut = (int)((scaledOut - (double)((int)scaledOut)) * 9.0)) <= 0 || (type = ApiUtils.getMetalComponentTypeAndMetal(e.getKey(), "ingot")) == null) continue;
            ItemStack nuggets = IEApi.getPreferredOreStack("nugget" + type[1]);
            outs.add(Utils.copyStackWithAmount(nuggets, nuggetOut));
        }
        return outs;
    }

    @Override
    public boolean matches(ItemStack input, ItemStack[] additives) {
        return input != null && this.input.matchesItemStack(input);
    }
}

