/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import javax.annotation.Nullable;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.energy.CapabilityEnergy;

public abstract class TileEntityIEBase
extends TileEntity {
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readCustomNBT(nbt, false);
    }

    public abstract void readCustomNBT(NBTTagCompound var1, boolean var2);

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeCustomNBT(nbt, false);
        return nbt;
    }

    public abstract void writeCustomNBT(NBTTagCompound var1, boolean var2);

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeCustomNBT(nbttagcompound, true);
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, nbttagcompound);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189515_b(new NBTTagCompound());
        this.writeCustomNBT(nbt, true);
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readCustomNBT(pkt.func_148857_g(), true);
    }

    public void receiveMessageFromClient(NBTTagCompound message) {
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
    }

    public void onEntityCollision(World world, Entity entity) {
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 0 || id == 255) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        if (id == 254) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state instanceof IExtendedBlockState) {
                ImmersiveEngineering.proxy.removeStateFromSmartModelCache((IExtendedBlockState)state);
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (world.func_175667_e(pos)) {
            newState = world.func_180495_p(pos);
        }
        if (oldState.func_177230_c() != newState.func_177230_c() || !(oldState.func_177230_c() instanceof BlockIEBase) || !(newState.func_177230_c() instanceof BlockIEBase)) {
            return true;
        }
        PropertyEnum type = ((BlockIEBase)oldState.func_177230_c()).getMetaProperty();
        return oldState.func_177229_b(type) != newState.func_177229_b(type);
    }

    public void markContainingBlockForUpdate(IBlockState newState) {
        this.markBlockForUpdate(this.func_174877_v(), newState);
    }

    public void markBlockForUpdate(BlockPos pos, IBlockState newState) {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (newState == null) {
            newState = state;
        }
        this.field_145850_b.func_184138_a(pos, state, newState, 3);
        this.field_145850_b.func_175685_c(pos, newState.func_177230_c());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && this instanceof EnergyHelper.IIEInternalFluxConnector) {
            return ((EnergyHelper.IIEInternalFluxConnector)((Object)this)).getCapabilityWrapper(facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && this instanceof EnergyHelper.IIEInternalFluxConnector) {
            return (T)((EnergyHelper.IIEInternalFluxConnector)((Object)this)).getCapabilityWrapper(facing);
        }
        return (T)super.getCapability(capability, facing);
    }
}

