/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import reborncore.api.power.EnumPowerTier;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.IWrenchable;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.client.container.IContainerProvider;
import techreborn.client.container.builder.BuiltContainer;
import techreborn.client.container.builder.ContainerBuilder;
import techreborn.init.IC2Duplicates;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.items.ItemParts;

public class TileMatterFabricator
extends TilePowerAcceptor
implements IWrenchable,
IInventoryProvider,
IContainerProvider {
    public int fabricationRate = 10000;
    public int tickTime;
    public Inventory inventory = new Inventory(7, "TileMatterFabricator", 64, (TileEntity)this);
    private int amplifier = 0;

    public TileMatterFabricator() {
        super(6);
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public EnumFacing getFacing() {
        return this.getFacingEnum();
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.MATTER_FABRICATOR, 1);
    }

    public boolean isComplete() {
        return false;
    }

    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 6; ++i) {
                int amp;
                ItemStack stack = this.inventory.func_70301_a(i);
                if (stack == null || (amp = this.getValue(stack)) == 0 || !this.canUseEnergy(85.0)) continue;
                this.useEnergy(85.0);
                this.amplifier += amp;
                this.inventory.func_70298_a(i, 1);
            }
            if (this.amplifier >= this.fabricationRate && this.spaceForOutput()) {
                this.addOutputProducts();
                this.amplifier -= this.fabricationRate;
            }
        }
    }

    private boolean spaceForOutput() {
        return this.inventory.func_70301_a(6) == null || ItemUtils.isItemEqual((ItemStack)this.inventory.func_70301_a(6), (ItemStack)new ItemStack(ModItems.UU_MATTER), (boolean)true, (boolean)true) && this.inventory.func_70301_a((int)6).field_77994_a < 64;
    }

    private void addOutputProducts() {
        if (this.inventory.func_70301_a(6) == null) {
            this.inventory.func_70299_a(6, new ItemStack(ModItems.UU_MATTER));
        } else if (ItemUtils.isItemEqual((ItemStack)this.inventory.func_70301_a(6), (ItemStack)new ItemStack(ModItems.UU_MATTER), (boolean)true, (boolean)true)) {
            this.inventory.func_70301_a((int)6).field_77994_a = Math.min(64, 1 + this.inventory.func_70301_a((int)6).field_77994_a);
        }
    }

    public boolean decreaseStoredEnergy(double aEnergy, boolean aIgnoreTooLessEnergy) {
        if (this.getEnergy() - aEnergy < 0.0 && !aIgnoreTooLessEnergy) {
            return false;
        }
        this.setEnergy(this.getEnergy() - aEnergy);
        if (this.getEnergy() < 0.0) {
            this.setEnergy(0.0);
            return false;
        }
        return true;
    }

    public int getValue(ItemStack itemStack) {
        if (itemStack.func_77973_b() == ModItems.PARTS && itemStack.func_77952_i() == ItemParts.getPartByName("scrap").func_77952_i()) {
            return 200;
        }
        if (itemStack.func_77973_b() == ModItems.SCRAP_BOX) {
            return 2000;
        }
        if (IC2Duplicates.SCRAP.hasIC2Stack() && ItemUtils.isInputEqual((Object)itemStack, (ItemStack)IC2Duplicates.SCRAP.getIc2Stack(), (boolean)true, (boolean)true, (boolean)true)) {
            return 200;
        }
        return 0;
    }

    public double getMaxPower() {
        return 1.0E8;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getMaxOutput() {
        return 0.0;
    }

    public double getMaxInput() {
        return 4096.0;
    }

    public EnumPowerTier getTier() {
        return EnumPowerTier.EXTREME;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getProgress() {
        return this.amplifier;
    }

    public void setProgress(int progress) {
        this.amplifier = progress;
    }

    public int getProgressScaled(int scale) {
        if (this.amplifier != 0) {
            return Math.min(this.amplifier * scale / this.fabricationRate, 100);
        }
        return 0;
    }

    @Override
    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("matterfabricator").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 30, 20).slot(1, 50, 20).slot(2, 70, 20).slot(3, 90, 20).slot(4, 110, 20).slot(5, 130, 20).outputSlot(6, 40, 66).syncEnergyValue().syncIntegerValue(this::getProgress, this::setProgress).addInventory().create();
    }
}

