/*
 * Decompiled with CFR 0.152.
 */
package reborncore.mcmultipart.multipart;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.translation.I18n;

public enum PartSlot implements IStringSerializable
{
    DOWN(EnumFacing.DOWN),
    UP(EnumFacing.UP),
    NORTH(EnumFacing.NORTH),
    SOUTH(EnumFacing.SOUTH),
    WEST(EnumFacing.WEST),
    EAST(EnumFacing.EAST),
    CENTER(null),
    EDGE_XNN(EnumFacing.DOWN, EnumFacing.NORTH),
    EDGE_XNP(EnumFacing.DOWN, EnumFacing.SOUTH),
    EDGE_XPN(EnumFacing.UP, EnumFacing.NORTH),
    EDGE_XPP(EnumFacing.UP, EnumFacing.SOUTH),
    EDGE_NYN(EnumFacing.WEST, EnumFacing.NORTH),
    EDGE_NYP(EnumFacing.WEST, EnumFacing.SOUTH),
    EDGE_PYN(EnumFacing.EAST, EnumFacing.NORTH),
    EDGE_PYP(EnumFacing.EAST, EnumFacing.SOUTH),
    EDGE_NNZ(EnumFacing.WEST, EnumFacing.DOWN),
    EDGE_NPZ(EnumFacing.WEST, EnumFacing.UP),
    EDGE_PNZ(EnumFacing.EAST, EnumFacing.DOWN),
    EDGE_PPZ(EnumFacing.EAST, EnumFacing.UP),
    CORNER_NNN(EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.NORTH),
    CORNER_NNP(EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.SOUTH),
    CORNER_NPN(EnumFacing.WEST, EnumFacing.UP, EnumFacing.NORTH),
    CORNER_NPP(EnumFacing.WEST, EnumFacing.UP, EnumFacing.SOUTH),
    CORNER_PNN(EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.NORTH),
    CORNER_PNP(EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.SOUTH),
    CORNER_PPN(EnumFacing.EAST, EnumFacing.UP, EnumFacing.NORTH),
    CORNER_PPP(EnumFacing.EAST, EnumFacing.UP, EnumFacing.SOUTH);

    public static final PartSlot[] VALUES;
    public static final PartSlot[] FACES;
    public static final PartSlot[] EDGES;
    public static final PartSlot[] CORNERS;
    public final EnumFacing f1;
    public final EnumFacing f2;
    public final EnumFacing f3;

    public static PartSlot getFaceSlot(EnumFacing facing) {
        if (facing == null) {
            return CENTER;
        }
        return VALUES[facing.ordinal()];
    }

    public static PartSlot getEdgeSlot(EnumFacing facing1, EnumFacing facing2) {
        if (facing1 == null || facing2 == null) {
            return null;
        }
        if (facing1 == facing2 || facing1.func_176734_d() == facing2) {
            throw new IllegalArgumentException("Tried to form an illegal edge between " + facing1 + " and " + facing2);
        }
        int x = facing1.func_82601_c() + facing2.func_82601_c();
        int y = facing1.func_96559_d() + facing2.func_96559_d();
        int z = facing1.func_82599_e() + facing2.func_82599_e();
        int edge = 0;
        if (x == 0) {
            edge = 0 + (y > 0 ? 2 : 0) + (z > 0 ? 1 : 0);
        } else if (y == 0) {
            edge = 4 + (x > 0 ? 2 : 0) + (z > 0 ? 1 : 0);
        } else if (z == 0) {
            edge = 8 + (x > 0 ? 2 : 0) + (y > 0 ? 1 : 0);
        }
        return EDGES[edge];
    }

    public static PartSlot getCornerSlot(EnumFacing facing1, EnumFacing facing2, EnumFacing facing3) {
        if (facing1 == null || facing2 == null || facing3 == null) {
            return null;
        }
        if (facing1 == facing2 || facing1.func_176734_d() == facing2) {
            throw new IllegalArgumentException("Tried to form an illegal corner between " + facing1 + " and " + facing2 + " " + facing3);
        }
        if (facing2 == facing3 || facing2.func_176734_d() == facing3) {
            throw new IllegalArgumentException("Tried to form an illegal corner between " + facing1 + " and " + facing2 + " " + facing3);
        }
        if (facing1 == facing3 || facing1.func_176734_d() == facing3) {
            throw new IllegalArgumentException("Tried to form an illegal corner between " + facing1 + " and " + facing2 + " " + facing3);
        }
        int x = (facing1.func_82601_c() + facing2.func_82601_c() + facing3.func_82601_c() + 1) / 2;
        int y = (facing1.func_96559_d() + facing2.func_96559_d() + facing3.func_96559_d() + 1) / 2;
        int z = (facing1.func_82599_e() + facing2.func_82599_e() + facing3.func_82599_e() + 1) / 2;
        int corner = x << 2 | y << 1 | z << 0;
        return CORNERS[corner];
    }

    private PartSlot(EnumFacing f1) {
        this.f1 = f1;
        this.f3 = null;
        this.f2 = null;
    }

    private PartSlot(EnumFacing f1, EnumFacing f2) {
        this.f1 = f1;
        this.f2 = f2;
        this.f3 = null;
    }

    private PartSlot(EnumFacing f1, EnumFacing f2, EnumFacing f3) {
        this.f1 = f1;
        this.f2 = f2;
        this.f3 = f3;
    }

    public String getUnlocalizedName() {
        return "partslot." + this.name().toLowerCase();
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)this.getUnlocalizedName());
    }

    public String func_176610_l() {
        return this.getLocalizedName();
    }

    public boolean matches(EnumFacing f1) {
        return this.f1 == f1 || this.f2 == f1 || this.f3 == f1;
    }

    public boolean matches(EnumFacing f1, EnumFacing f2) {
        return this.f1 == f1 && this.f2 == f2 || this.f1 == f2 && this.f2 == f1 || this.f1 == f1 && this.f3 == f2 || this.f1 == f2 && this.f3 == f1 || this.f2 == f1 && this.f3 == f2 || this.f2 == f2 && this.f3 == f1;
    }

    public boolean matches(EnumFacing f1, EnumFacing f2, EnumFacing f3) {
        return this.f1 == f1 && this.f2 == f2 && this.f3 == f3 || this.f1 == f2 && this.f2 == f1 && this.f3 == f3 || this.f1 == f1 && this.f2 == f3 && this.f3 == f2 || this.f1 == f3 && this.f2 == f2 && this.f3 == f1;
    }

    public PartSlot getOpposite(EnumFacing.Axis axis) {
        if (this.f2 != null) {
            if (this.f3 != null) {
                return PartSlot.getCornerSlot(this.f1.func_176740_k() == axis ? this.f1.func_176734_d() : this.f1, this.f2.func_176740_k() == axis ? this.f2.func_176734_d() : this.f2, this.f3.func_176740_k() == axis ? this.f3.func_176734_d() : this.f3);
            }
            return PartSlot.getEdgeSlot(this.f1.func_176740_k() == axis ? this.f1.func_176734_d() : this.f1, this.f2.func_176740_k() == axis ? this.f2.func_176734_d() : this.f2);
        }
        if (this.f1 == null) {
            return CENTER;
        }
        return PartSlot.getFaceSlot(this.f1.func_176740_k() == axis ? this.f1.func_176734_d() : this.f1);
    }

    static {
        VALUES = PartSlot.values();
        FACES = new PartSlot[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
        EDGES = new PartSlot[]{EDGE_XNN, EDGE_XNP, EDGE_XPN, EDGE_XPP, EDGE_NYN, EDGE_NYP, EDGE_PYN, EDGE_PYP, EDGE_NNZ, EDGE_NPZ, EDGE_PNZ, EDGE_PPZ};
        CORNERS = new PartSlot[]{CORNER_NNN, CORNER_NNP, CORNER_NPN, CORNER_NPP, CORNER_PNN, CORNER_PNP, CORNER_PPN, CORNER_PPP};
    }
}

