/*
 * Decompiled with CFR 0.152.
 */
package reborncore.jtraits;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import reborncore.jtraits.ASMUtils;
import reborncore.jtraits.Annotation;
import reborncore.jtraits.ClassLoadingHelper;
import reborncore.jtraits.MixinFactory;

public class Mixin<T> {
    private String parentType;
    private ClassNode parentNode;
    private Class<T> parentClass;
    private String traitType;
    private ClassNode traitNode;
    private Class<?> traitClass;
    private String newType;
    private String castType;
    private Class<T> result;
    private String[] parents;
    private boolean annCheckMixin;
    private String annCheckMixinField;
    private String annCheckMixinOwner;

    public static final String getName(Class<?> clazz, Class<?> trait) {
        return Type.getInternalName(clazz) + "$$" + trait.getSimpleName();
    }

    public Mixin(Class<T> clazz, Class<?> trait) {
        this.parentType = Type.getInternalName(clazz);
        this.parentClass = clazz;
        this.traitType = Type.getInternalName(trait);
        this.traitClass = trait;
        this.updateNodes();
        this.castType = this.newType = Mixin.getName(clazz, trait);
        this.parents = ASMUtils.recursivelyFindClasses(this);
        Class<T> c = clazz;
        do {
            Annotation.CheckMixin a;
            if ((a = c.getAnnotation(Annotation.CheckMixin.class)) == null) continue;
            this.annCheckMixin = true;
            this.annCheckMixinField = a.value();
            this.annCheckMixinOwner = c.getName().replace('.', '/');
            break;
        } while ((c = c.getSuperclass()) != null && c != Object.class);
    }

    public void updateNodes() {
        this.parentNode = ASMUtils.getClassNode(this.parentClass);
        this.traitNode = ASMUtils.getClassNode(this.traitClass);
    }

    public void updateNodes(byte[] traitBytes) {
        this.parentNode = ASMUtils.getClassNode(this.parentClass);
        this.traitNode = ASMUtils.getClassNode(this.traitClass);
    }

    public byte[] mixin_do() {
        ClassWriter writer = new ClassWriter(3);
        writer.visit(50, 1, this.newType, null, this.parentType, this.traitNode.interfaces.toArray(new String[this.traitNode.interfaces.size()]));
        writer.visitSource(this.traitType.substring(this.traitType.lastIndexOf("/") + 1) + ".java", null);
        this.transferParentFields(writer);
        this.transferTraitFields(writer);
        this.bridgeMethods(writer);
        boolean hasSelfObject = false;
        for (FieldNode f : this.parentNode.fields) {
            if (!f.name.equals("_self")) continue;
            hasSelfObject = true;
            break;
        }
        if (!hasSelfObject) {
            writer.visitField(4097, "_self", "Ljava/lang/Object;", null, null);
        }
        return writer.toByteArray();
    }

    public Class<T> mixin() {
        if (this.result != null) {
            return this.result;
        }
        this.result = ClassLoadingHelper.instance.addMixin(this.newType.replace('/', '.'), this.mixin_do(), this);
        return this.result;
    }

    private void transferParentFields(ClassWriter writer) {
        for (FieldNode f : this.parentNode.fields) {
            if (f.name.equals("_super")) continue;
            FieldVisitor v = writer.visitField(1, f.name, f.desc, null, f.value);
            if (f.visibleAnnotations != null) {
                for (AnnotationNode a : f.visibleAnnotations) {
                    if (a.values == null) continue;
                    AnnotationVisitor av = v.visitAnnotation(a.desc, true);
                    Iterator it = a.values.iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        Object val = it.next();
                        try {
                            if (!(!(val instanceof Object[]) || val instanceof byte[] || val instanceof boolean[] || val instanceof short[] || val instanceof char[] || val instanceof int[] || val instanceof long[] || val instanceof float[] || val instanceof double[])) {
                                av = av.visitArray(key);
                                int i = 0;
                                for (Object o : (Object[])val) {
                                    av.visit("" + i, o);
                                    ++i;
                                }
                                continue;
                            }
                            av.visit(key, val);
                        }
                        catch (Exception ex) {
                            if (!MixinFactory.debug) continue;
                            new RuntimeException("Invalid key/value: " + key + " - " + val, ex).printStackTrace();
                        }
                    }
                }
            }
            v.visitEnd();
        }
    }

    private void transferTraitFields(ClassWriter writer) {
        for (FieldNode f : this.traitNode.fields) {
            if (f.name.equals("_super")) continue;
            FieldVisitor v = writer.visitField(1, f.name, f.desc, null, f.value);
            if (f.visibleAnnotations != null) {
                for (AnnotationNode a : f.visibleAnnotations) {
                    AnnotationVisitor av = v.visitAnnotation(a.desc, true);
                    Iterator it = a.values.iterator();
                    while (it.hasNext()) {
                        av.visit((String)it.next(), it.next());
                    }
                }
            }
            v.visitEnd();
        }
    }

    private void bridgeMethods(ClassWriter writer) {
        MethodVisitor v;
        ArrayList<String> constructors = new ArrayList<String>();
        for (MethodNode m : this.traitNode.methods) {
            v = writer.visitMethod(0x1001 | m.access & 0xFFFFFBFF & 0xFFFFFDFF & 0xFFFFFFFB & 0xFFFFFFFD, m.name, m.desc, null, null);
            v.visitCode();
            ASMUtils.resetCopy(m.instructions);
            v.visitLabel(new Label());
            if (m.name.equals("<init>") || m.name.equals("<clinit>")) {
                if (m.name.equals("<init>")) {
                    constructors.add(m.name + m.desc);
                }
                v.visitVarInsn(25, 0);
                int index = 1;
                for (Type t : Type.getArgumentTypes((String)m.desc)) {
                    v.visitVarInsn(t == Type.BOOLEAN_TYPE || t == Type.BYTE_TYPE || t == Type.CHAR_TYPE || t == Type.INT_TYPE || t == Type.LONG_TYPE || t == Type.SHORT_TYPE ? 21 : (t == Type.DOUBLE_TYPE ? 24 : (t == Type.FLOAT_TYPE ? 23 : 25)), index);
                    index += t.getSize();
                }
                v.visitMethodInsn(183, this.parentType, m.name, m.desc, false);
                v.visitVarInsn(25, 0);
                v.visitVarInsn(25, 0);
                v.visitFieldInsn(181, this.newType, "_self", "Ljava/lang/Object;");
                if (this.annCheckMixin) {
                    v.visitVarInsn(25, 0);
                    v.visitLdcInsn((Object)1);
                    v.visitFieldInsn(181, this.annCheckMixinOwner, this.annCheckMixinField, "Z");
                }
            }
            InsnList list = new InsnList();
            ListIterator originalInsns = m.instructions.iterator();
            ArrayList<AbstractInsnNode> added = new ArrayList<AbstractInsnNode>();
            int supercall = 0;
            while (originalInsns.hasNext()) {
                AbstractInsnNode node = (AbstractInsnNode)originalInsns.next();
                AbstractInsnNode next = node.getNext();
                AbstractInsnNode prev = node.getPrevious();
                if (next != null && node instanceof VarInsnNode && ((VarInsnNode)node).var == 0 && next instanceof MethodInsnNode && ((MethodInsnNode)next).name.equals("<init>") || prev != null && prev instanceof VarInsnNode && ((VarInsnNode)prev).var == 0 && node instanceof MethodInsnNode && ((MethodInsnNode)node).name.equals("<init>")) continue;
                int result = ASMUtils.addInstructionsWithSuperRedirections(node, added, supercall, this);
                if (result == 1) {
                    supercall = 1;
                } else if (result == 2) {
                    supercall = 2;
                } else if (result == 3) {
                    supercall = 3;
                }
                if (added.isEmpty()) {
                    ASMUtils.copyInsn(list, node);
                    continue;
                }
                for (AbstractInsnNode n_ : added) {
                    list.add(n_);
                }
                added.clear();
            }
            list.accept(v);
            v.visitInsn(ASMUtils.getReturnCode(m.desc.substring(m.desc.lastIndexOf(")") + 1)));
            v.visitMaxs(m.maxStack + 1, m.maxLocals + 1);
            if (m.visibleAnnotations != null) {
                for (AnnotationNode a : m.visibleAnnotations) {
                    AnnotationVisitor av = v.visitAnnotation(a.desc, true);
                    Iterator it = a.values.iterator();
                    while (it.hasNext()) {
                        av.visit((String)it.next(), it.next());
                    }
                }
            }
            v.visitEnd();
        }
        for (MethodNode m : this.parentNode.methods) {
            if (!m.name.equals("<init>") || constructors.contains(m.name + m.desc)) continue;
            v = writer.visitMethod(4097, m.name, m.desc, null, null);
            v.visitCode();
            v.visitVarInsn(25, 0);
            int index = 1;
            for (Type t : Type.getArgumentTypes((String)m.desc)) {
                v.visitVarInsn(t == Type.BOOLEAN_TYPE || t == Type.BYTE_TYPE || t == Type.CHAR_TYPE || t == Type.INT_TYPE || t == Type.SHORT_TYPE ? 21 : (t == Type.LONG_TYPE ? 22 : (t == Type.DOUBLE_TYPE ? 24 : (t == Type.FLOAT_TYPE ? 23 : 25))), index);
                index += t.getSize();
            }
            v.visitMethodInsn(183, this.parentType, m.name, m.desc, false);
            v.visitVarInsn(25, 0);
            v.visitVarInsn(25, 0);
            v.visitFieldInsn(181, this.newType, "_self", "Ljava/lang/Object;");
            if (this.annCheckMixin) {
                v.visitVarInsn(25, 0);
                v.visitLdcInsn((Object)1);
                v.visitFieldInsn(181, this.annCheckMixinOwner, this.annCheckMixinField, "Z");
            }
            v.visitInsn(177);
            v.visitMaxs(m.maxStack + 1, m.maxLocals + 1);
            v.visitEnd();
        }
    }

    public String getParentType() {
        return this.parentType;
    }

    public ClassNode getParentNode() {
        return this.parentNode;
    }

    public Class<T> getParentClass() {
        return this.parentClass;
    }

    public String getTraitType() {
        return this.traitType;
    }

    public ClassNode getTraitNode() {
        return this.traitNode;
    }

    public String getNewType() {
        return this.newType;
    }

    public String getCastType() {
        return this.castType;
    }

    public String[] getParents() {
        return this.parents;
    }
}

