/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.chesttransporter;

import cubex2.mods.chesttransporter.TransporterType;
import cubex2.mods.chesttransporter.chests.ChestRegistry;
import cubex2.mods.chesttransporter.chests.TransportableChest;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemChestTransporter
extends Item {
    public final TransporterType type;

    protected ItemChestTransporter(TransporterType type) {
        this.type = type;
        this.func_77655_b("chesttransporter_" + type.iconName);
        this.func_77625_d(1);
        this.func_77656_e(type.maxDamage);
        this.func_77637_a(CreativeTabs.field_78040_i);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack == null || stack.func_77973_b() != this) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getEntityPlayer().field_70170_p;
        EnumFacing face = event.getFace();
        IBlockState state = world.func_180495_p(event.getPos());
        byte chestType = ItemChestTransporter.getTagCompound(stack).func_74771_c("ChestType");
        if (chestType == 0 && ItemChestTransporter.isChestAt(world, event.getPos())) {
            this.grabChest(stack, player, world, event.getPos());
        } else if (chestType != 0) {
            this.placeChest(stack, player, event.getHand(), world, event.getPos(), face);
        }
    }

    private void grabChest(ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            int metadata;
            IBlockState iblockstate = world.func_180495_p(pos);
            Block chestBlock = iblockstate.func_177230_c();
            int newChestType = ItemChestTransporter.getChestType(chestBlock, metadata = chestBlock.func_176201_c(iblockstate));
            if (newChestType == 0) {
                return;
            }
            TransportableChest tChest = ChestRegistry.getChest(chestBlock, metadata);
            if (tChest == null || !tChest.isUsableWith(stack)) {
                return;
            }
            if (!tChest.canGrab(tile)) {
                return;
            }
            ItemChestTransporter.getTagCompound(stack).func_74774_a("ChestType", (byte)newChestType);
            if (tChest.copyTileEntity()) {
                NBTTagCompound nbt = new NBTTagCompound();
                tile.func_189515_b(nbt);
                ItemChestTransporter.getTagCompound(stack).func_74782_a("ChestTile", (NBTBase)nbt);
                world.func_175713_t(pos);
            } else {
                IInventory chest = (IInventory)tile;
                ItemChestTransporter.moveItemsIntoStack(chest, stack);
            }
            tChest.preRemoveChest(stack, tile);
            world.func_175698_g(pos);
            SoundType soundType = chestBlock.func_185467_w();
            world.func_184133_a(player, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
        }
    }

    private void placeChest(ItemStack stack, EntityPlayer player, EnumHand hand, World world, BlockPos pos, EnumFacing face) {
        byte chestType = ItemChestTransporter.getTagCompound(stack).func_74771_c("ChestType");
        if (!ChestRegistry.dvToChest.containsKey(chestType)) {
            return;
        }
        BlockPos chestPos = this.getChestCoords(world, pos, face);
        ItemStack chestStack = this.createChestStack(stack, chestType);
        if (chestStack.func_179546_a(player, world, pos, hand, face, 0.0f, 0.0f, 0.0f) != EnumActionResult.SUCCESS) {
            return;
        }
        if (chestPos != null) {
            int meta;
            IBlockState iblockstate = world.func_180495_p(chestPos);
            Block block = iblockstate.func_177230_c();
            TransportableChest tChest = ChestRegistry.getChest(block, meta = block.func_176201_c(iblockstate));
            if (tChest == null || !tChest.isUsableWith(stack)) {
                return;
            }
            TileEntity tile = world.func_175625_s(chestPos);
            if (tChest.copyTileEntity()) {
                NBTTagCompound nbt = ItemChestTransporter.getTagCompound(stack).func_74775_l("ChestTile");
                tChest.modifyTileCompound((EntityLivingBase)player, nbt);
                world.func_175690_a(chestPos, TileEntity.func_190200_a((World)world, (NBTTagCompound)nbt));
            } else {
                IInventory chest = (IInventory)tile;
                this.moveItemsIntoChest(stack, chest);
            }
            ItemChestTransporter.getTagCompound(stack).func_74774_a("ChestType", (byte)0);
            tChest.preDestroyTransporter((EntityLivingBase)player, stack, tile);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
                if (this.type.maxDamage == 1) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
            }
        }
    }

    private BlockPos getChestCoords(World world, BlockPos pos, EnumFacing facing) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!(block == Blocks.field_150431_aC && (Integer)iblockstate.func_177229_b((IProperty)BlockSnow.field_176315_a) < 1 || block.func_176200_f((IBlockAccess)world, pos))) {
            pos = pos.func_177972_a(facing);
        }
        return pos;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean par5) {
        byte chestType = ItemChestTransporter.getTagCompound(stack).func_74771_c("ChestType");
        if (chestType != 0 && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
            this.addEffect(player, MobEffects.field_76421_d, 2);
            this.addEffect(player, MobEffects.field_76419_f, 3);
            this.addEffect(player, MobEffects.field_76430_j, -2);
            this.addEffect(player, MobEffects.field_76438_s, 0);
        }
    }

    private void addEffect(EntityPlayer player, Potion potion, int amplifier) {
        if (player.func_70660_b(potion) == null || player.func_70660_b(potion).func_76459_b() < 20) {
            player.func_70690_d(new PotionEffect(potion, 60, amplifier));
        }
    }

    @SubscribeEvent
    public void entityInteract(MinecartInteractEvent event) {
        if (event.isCanceled()) {
            return;
        }
        ItemStack stack = event.getItem();
        EntityMinecart minecart = event.getMinecart();
        if (stack == null || stack.func_77973_b() != this || minecart == null) {
            return;
        }
        byte chestType = ItemChestTransporter.getTagCompound(stack).func_74771_c("ChestType");
        EntityPlayer player = event.getPlayer();
        if (minecart instanceof EntityMinecartEmpty && !minecart.func_184207_aI() && ChestRegistry.isMinecartChest(chestType)) {
            EntityMinecart newMinecart = ChestRegistry.createMinecart(minecart.field_70170_p, chestType);
            if (!player.field_70170_p.field_72995_K) {
                this.replaceMinecart(minecart, newMinecart);
            }
            this.moveItemsIntoChest(stack, (IInventory)newMinecart);
            ItemChestTransporter.getTagCompound(stack).func_74774_a("ChestType", (byte)0);
            SoundType soundType = Blocks.field_150486_ae.func_185467_w();
            minecart.field_70170_p.func_184133_a(player, minecart.func_180425_c(), soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
                if (this.type.maxDamage == 1) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
            }
            event.setCanceled(true);
        } else if (ChestRegistry.isSupportedMinecart(minecart) && chestType == 0) {
            ItemChestTransporter.moveItemsIntoStack((IInventory)minecart, stack);
            ItemChestTransporter.getTagCompound(stack).func_74774_a("ChestType", (byte)ChestRegistry.getChestType(minecart));
            SoundType soundType = Blocks.field_150486_ae.func_185467_w();
            minecart.field_70170_p.func_184133_a(player, minecart.func_180425_c(), soundType.func_185845_c(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
            if (!player.field_70170_p.field_72995_K) {
                EntityMinecartEmpty newMinecart = new EntityMinecartEmpty(minecart.field_70170_p);
                this.replaceMinecart(minecart, (EntityMinecart)newMinecart);
            }
            event.setCanceled(true);
        }
    }

    private void replaceMinecart(EntityMinecart old, EntityMinecart now) {
        now.func_70107_b(old.field_70165_t, old.field_70163_u, old.field_70161_v);
        now.field_70125_A = old.field_70125_A;
        now.field_70127_C = old.field_70127_C;
        now.field_70177_z = old.field_70177_z;
        now.field_70126_B = old.field_70126_B;
        old.field_70170_p.func_72838_d((Entity)now);
        old.func_70106_y();
    }

    public boolean func_77651_p() {
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean flag) {
        byte chestType = ItemChestTransporter.getTagCompound(stack).func_74771_c("ChestType");
        if (chestType != 0) {
            TransportableChest chest;
            int numItems = 0;
            NBTTagList nbtList = stack.func_77978_p().func_150295_c("Items", 10);
            for (int i = 0; i < nbtList.func_74745_c(); ++i) {
                ItemStack itemstack;
                NBTTagCompound nbtTagCompound = nbtList.func_150305_b(i);
                NBTBase nbt = nbtTagCompound.func_74781_a("Slot");
                int j = nbt instanceof NBTTagByte ? nbtTagCompound.func_74771_c("Slot") & 0xFF : nbtTagCompound.func_74765_d("Slot");
                if (j < 0 || (itemstack = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound)) == null) continue;
                numItems += itemstack.field_77994_a;
            }
            if (numItems > 0) {
                list.add("Contains " + numItems + " items");
            }
            if ((chest = ChestRegistry.dvToChest.get(chestType)) != null) {
                chest.addInformation(stack, player, list, flag);
            }
        }
    }

    static boolean isChestAt(World world, BlockPos pos) {
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        int meta = block.func_176201_c(iblockstate);
        return ChestRegistry.isChest(block, meta);
    }

    static int getChestType(Block block, int metadata) {
        TransportableChest chest = ChestRegistry.getChest(block, metadata);
        return chest != null ? chest.getTransporterDV() : 0;
    }

    private ItemStack createChestStack(ItemStack transporter, int damage) {
        return ChestRegistry.dvToChest.containsKey(damage) ? ChestRegistry.dvToChest.get(damage).createChestStack(transporter) : null;
    }

    static void moveItemsIntoStack(IInventory chest, ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList nbtList = new NBTTagList();
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            if (chest.func_70301_a(i) == null) continue;
            NBTTagCompound nbtTabCompound2 = new NBTTagCompound();
            nbtTabCompound2.func_74777_a("Slot", (short)i);
            chest.func_70301_a(i).func_77946_l().func_77955_b(nbtTabCompound2);
            chest.func_70299_a(i, null);
            nbtList.func_74742_a((NBTBase)nbtTabCompound2);
        }
        stack.func_77978_p().func_74782_a("Items", (NBTBase)nbtList);
    }

    private void moveItemsIntoChest(ItemStack stack, IInventory chest) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagList nbtList = stack.func_77978_p().func_150295_c("Items", 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = nbtList.func_150305_b(i);
            NBTBase nbt = nbtTagCompound.func_74781_a("Slot");
            int j = nbt instanceof NBTTagByte ? nbtTagCompound.func_74771_c("Slot") & 0xFF : nbtTagCompound.func_74765_d("Slot");
            if (j < 0 || j >= chest.func_70302_i_()) continue;
            chest.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound).func_77946_l());
        }
        stack.func_77978_p().func_82580_o("Items");
    }

    public static NBTTagCompound getTagCompound(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }
}

