/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.hammercore.client.model.file;

import com.mrdimka.hammercore.client.model.file.ModelPart;
import com.mrdimka.hammercore.common.utils.IOUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Set;

public class ModelFile
implements Serializable {
    public int textureWidth;
    public int textureHeight;
    public Set<ModelPart> parts;

    public byte[] write() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.write(baos);
        return baos.toByteArray();
    }

    public void write(OutputStream stream) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(this);
            out.close();
            stream.write(IOUtils.deflaterCompress(baos.toByteArray()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static ModelFile read(File file) {
        try {
            FileInputStream i = new FileInputStream(file);
            ModelFile f = ModelFile.read(i);
            i.close();
            return f;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static ModelFile read(URL url) {
        try {
            return ModelFile.read(url.openStream());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static ModelFile read(InputStream data) {
        try {
            data = new ByteArrayInputStream(IOUtils.deflaterUncompress(IOUtils.pipeOut(data)));
            ObjectInputStream ois = new ObjectInputStream(data);
            ModelFile f = (ModelFile)ois.readObject();
            ois.close();
            return f;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static ModelFile read(byte[] data) {
        return ModelFile.read(new ByteArrayInputStream(data));
    }
}

