/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.style.stylesheet;

import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.shadowfacts.shadowmc.ui.style.stylesheet.Stylesheet;
import net.shadowfacts.shadowmc.ui.style.stylesheet.StylesheetParser;

public enum Token {
    INCLUDE(Pattern.compile("@include ([\\w\\-_]+):([\\w\\-_]+)"), s -> true, (matcher, lines, stylesheet) -> {
        String id = matcher.group(1) + ":" + matcher.group(2);
        StylesheetParser.parse(StylesheetParser.load(id), stylesheet);
    }, false),
    ID(Pattern.compile("#([\\w\\d\\-_]+)( \\{)?"), s -> s.equals("}"), (matcher, lines, stylesheet) -> {
        String id = matcher.group(1);
        for (int i = 0; i < lines.length; ++i) {
            stylesheet.addIDRule(id, StylesheetParser.parseRule(lines[i]));
        }
    }, true),
    CLASS(Pattern.compile("\\.([\\w\\d\\-_]+)( \\{)?"), s -> s.equals("}"), (matcher, lines, stylesheet) -> {
        String clazz = matcher.group(1);
        for (int i = 0; i < lines.length; ++i) {
            stylesheet.addClassRule(clazz, StylesheetParser.parseRule(lines[i]));
        }
    }, true),
    TYPE(Pattern.compile("([\\w\\d\\-_]+)( \\{)?"), s -> s.equals("}"), (matcher, lines, stylesheet) -> {
        String type = matcher.group(1);
        for (int i = 0; i < lines.length; ++i) {
            stylesheet.addTypeRule(type, StylesheetParser.parseRule(lines[i]));
        }
    }, true);

    public final Pattern startLine;
    public final Predicate<String> stop;
    public final TokenHandler handler;
    public final boolean removeOneMore;

    private Token(Pattern startLine, Predicate<String> stop, TokenHandler handler, boolean removeOneMore) {
        this.startLine = startLine;
        this.stop = stop;
        this.handler = handler;
        this.removeOneMore = removeOneMore;
    }

    public static interface TokenHandler {
        public void handle(Matcher var1, String[] var2, Stylesheet var3);
    }
}

