/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.moreBees.Genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlleleBeeSpeciesBuilder;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IJubilanceProvider;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeBranchDefinition;
import forestry.apiculture.genetics.BeeVariation;
import forestry.apiculture.genetics.IBeeDefinition;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.core.PluginCore;
import forestry.core.genetics.IBranchDefinition;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import java.awt.Color;
import java.util.Arrays;
import java.util.Locale;
import lach_01298.moreBees.Genetics.BeeBranches;
import lach_01298.moreBees.Genetics.WitherSkullJubilance;
import lach_01298.moreBees.Register;
import lach_01298.moreBees.item.MoreBeesItems;
import lach_01298.moreBees.util.Config;
import lach_01298.moreBees.util.LoadMods;
import lach_01298.moreBees.util.MathUtil;
import lach_01298.moreBees.util.OreDicPreferences;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.text.WordUtils;

public enum BeeSpecies implements IBeeDefinition
{
    ROCK(BeeBranches.ROCK, "Rock", true, new Color(0x6D6D6D), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).setTemperature(EnumTemperature.NORMAL).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeOre);
        }

        @Override
        protected void registerMutations() {
        }
    }
    ,
    HARDENED(BeeBranches.ROCK, "Hardened", true, new Color(0x464646), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.35f)).setTemperature(EnumTemperature.NORMAL).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(RockBee, CultivatedBee, this.getTemplate(), MathUtil.maxInt((int)(10.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    OBSIDIAN(BeeBranches.ROCK, "Obsidian", false, new Color(2367025), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.4f)).addProduct(new ItemStack(Blocks.field_150343_Z), Float.valueOf(0.1f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(HardenedBee, SteadfastBee, this.getTemplate(), MathUtil.maxInt((int)(10.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    LAPIS(BeeBranches.ROCK, "Lapis", false, new Color(2246556), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(new ItemStack(Items.field_151100_aR, 1, 4), Float.valueOf(0.1f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(ObsidianBee, ImperialBee, this.getTemplate(), MathUtil.maxInt((int)(8.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    DIRT(BeeBranches.EARTH, "Dirt", true, new Color(7951674), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombDirt), Float.valueOf(0.4f)).setTemperature(EnumTemperature.NORMAL).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        }

        @Override
        protected void registerMutations() {
            for (int i = 0; i < hiveBees.length; ++i) {
                BeeManager.beeMutationFactory.createMutation(RockBee, hiveBees[i], this.getTemplate(), MathUtil.maxInt((int)(15.0f * Config.mutationMultipler), 100));
            }
        }
    }
    ,
    CLAY(BeeBranches.EARTH, "Clay", true, new Color(0xA7ABBB), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombDirt), Float.valueOf(0.3f)).addProduct(new ItemStack(Items.field_151119_aD), Float.valueOf(1.0f)).addProduct(new ItemStack(Items.field_151119_aD), Float.valueOf(0.5f)).addProduct(new ItemStack(Items.field_151119_aD), Float.valueOf(0.5f)).addProduct(new ItemStack(Items.field_151119_aD), Float.valueOf(0.5f)).setTemperature(EnumTemperature.NORMAL).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(DirtBee, hiveBees[1], this.getTemplate(), MathUtil.maxInt((int)(15.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    REDSAND(BeeBranches.EARTH, "RedSand", false, new Color(10966560), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombDirt), Float.valueOf(0.3f)).addProduct(new ItemStack((Block)Blocks.field_150354_m), Float.valueOf(0.4f)).addProduct(new ItemStack((Block)Blocks.field_150354_m, 1, 1), Float.valueOf(0.7f)).addProduct(new ItemStack((Block)Blocks.field_150354_m, 2, 1), Float.valueOf(0.3f)).addProduct(new ItemStack((Block)Blocks.field_150354_m, 1, 1), Float.valueOf(0.2f)).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(DirtBee, hiveBees[3], this.getTemplate(), MathUtil.maxInt((int)(15.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    QUARTZ(BeeBranches.CRYSTAL, "Quartz", false, new Color(0xF4F6F6), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombCrystal), Float.valueOf(0.3f)).addProduct(new ItemStack(Items.field_151128_bU), Float.valueOf(0.2f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeRedstone);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(LapisBee, SinisterBee, this.getTemplate(), MathUtil.maxInt((int)(10.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    CERTUS(BeeBranches.CRYSTAL, "Certus", false, new Color(0xF6FEFF), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableCertusQuartz) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombCrystal), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustCertusQuartz", 1), Float.valueOf(0.2f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeRedstone);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(QuartzBee, IndustriousBee, this.getTemplate(), MathUtil.maxInt((int)(10.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    REDSTONE(BeeBranches.CRYSTAL, "Redstone", false, new Color(0xAA0404), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombCrystal), Float.valueOf(0.3f)).addProduct(new ItemStack(Items.field_151137_ax), Float.valueOf(0.2f)).addProduct(new ItemStack(Items.field_151137_ax), Float.valueOf(0.15f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeRedstone);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(ObsidianBee, SteadfastBee, this.getTemplate(), MathUtil.maxInt((int)(8.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    EMERALD(BeeBranches.CRYSTAL, "Emerald", false, new Color(4906099), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombCrystal), Float.valueOf(0.3f)).addSpecialty(new ItemStack((Item)MoreBeesItems.EmeraldFrag), Float.valueOf(0.15f)).setJubilanceProvider(BeeManager.jubilanceFactory.getRequiresResource(new IBlockState[]{Blocks.field_150475_bE.func_176223_P(), Blocks.field_150412_bA.func_176223_P()})).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeEmerald);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(RedstoneBee, ImperialBee, this.getTemplate(), MathUtil.maxInt((int)(5.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    DIAMOND(BeeBranches.CRYSTAL, "Diamond", false, new Color(6155509), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombCrystal), Float.valueOf(0.3f)).addSpecialty(new ItemStack((Item)MoreBeesItems.DiamondFrag), Float.valueOf(0.15f)).setJubilanceProvider(BeeManager.jubilanceFactory.getRequiresResource(new IBlockState[]{Blocks.field_150484_ah.func_176223_P(), Blocks.field_150482_ag.func_176223_P()})).setHasEffect().setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeDiamond);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(EmeraldBee, QuartzBee, this.getTemplate(), MathUtil.maxInt((int)(2.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    RUBY(BeeBranches.CRYSTAL, "Ruby", false, new Color(0xFF0000), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableRuby) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombCrystal), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("gemRuby", 1), Float.valueOf(0.1f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(RedstoneBee, ImperialBee, this.getTemplate(), MathUtil.maxInt((int)(7.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    SAPPHIRE(BeeBranches.CRYSTAL, "Sapphire", false, new Color(22776), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableSapphire) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombCrystal), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("gemSapphire", 1), Float.valueOf(0.1f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(LapisBee, ImperialBee, this.getTemplate(), MathUtil.maxInt((int)(7.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    SULFUR(BeeBranches.CRYSTAL, "Sulfur", false, new Color(15333376), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableSulfur) {
                beeSpecies.addProduct(PluginApiculture.items.beeComb.get(EnumHoneyComb.SIMMERING, 1), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustSulfur", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(RedstoneBee, FiendishBee, this.getTemplate(), MathUtil.maxInt((int)(15.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    APATITE(BeeBranches.CRYSTAL, "Apatite", false, new Color(4959985), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombCrystal), Float.valueOf(0.3f)).addProduct(new ItemStack((Item)PluginCore.items.apatite), Float.valueOf(0.1f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(RedstoneBee, LapisBee, this.getTemplate(), MathUtil.maxInt((int)(10.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    METALLIC(BeeBranches.METAL, "Metallic", true, new Color(0x999999), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombMetallic), Float.valueOf(0.25f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(ObsidianBee, FiendishBee, this.getTemplate(), MathUtil.maxInt((int)(10.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    IRON(BeeBranches.METAL, "Iron", false, new Color(0xD9D9D9), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombMetallic), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustIron", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(MetallicBee, IndustriousBee, this.getTemplate(), MathUtil.maxInt((int)(10.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    COPPER(BeeBranches.METAL, "Copper", false, new Color(10970160), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombMetallic), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustCopper", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(MetallicBee, IndustriousBee, this.getTemplate(), MathUtil.maxInt((int)(10.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    TIN(BeeBranches.METAL, "Tin", false, new Color(0xE8E8E8), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombMetallic), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustTin", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(MetallicBee, IndustriousBee, this.getTemplate(), MathUtil.maxInt((int)(10.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    ALUMINIUM(BeeBranches.METAL, "Aluminium", false, new Color(0xF6F6F6), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableAluminium) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombMetallic), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustAluminum", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(MetallicBee, IndustriousBee, this.getTemplate(), MathUtil.maxInt((int)(10.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    GOLD(BeeBranches.METAL, "Gold", false, new Color(15652925), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombMetallic), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustGold", 1), Float.valueOf(0.1f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(MetallicBee, ImperialBee, this.getTemplate(), MathUtil.maxInt((int)(8.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    SILVER(BeeBranches.METAL, "Silver", false, new Color(0xF4F6F6), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableSilver) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombMetallic), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustSilver", 1), Float.valueOf(0.12f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(GoldBee, TinBee, this.getTemplate(), MathUtil.maxInt((int)(8.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    LEAD(BeeBranches.METAL, "Lead", false, new Color(14014905), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableLead) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombMetallic), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustLead", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(MetallicBee, ObsidianBee, this.getTemplate(), MathUtil.maxInt((int)(8.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    COBALT(BeeBranches.METAL, "Cobalt", false, new Color(1925816), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableTinkers) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombMetallic), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("nuggetCobalt", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(DemonicBee, TinBee, this.getTemplate(), MathUtil.maxInt((int)(8.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    ARDITE(BeeBranches.METAL, "Ardite", false, new Color(11019543), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableTinkers) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombMetallic), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("nuggetArdite", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(DemonicBee, CopperBee, this.getTemplate(), MathUtil.maxInt((int)(8.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    OSMIUM(BeeBranches.METAL, "Osmium", false, new Color(9807284), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableOsmium) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombMetallic), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustOsmium", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.NORMAL);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(CopperBee, IndustriousBee, this.getTemplate(), MathUtil.maxInt((int)(10.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    RADIOACTIVE(BeeBranches.RADIOACTIVE, "Radioactive", true, new Color(4092428), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.items.beeComb.get(EnumHoneyComb.SIMMERING, 1), Float.valueOf(0.3f)).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.NORMAL);
            if (LoadMods.enableUranium && !LoadMods.enableIC2Classic) {
                beeSpecies.addProduct(OreDicPreferences.get("oreUranium", 1), Float.valueOf(0.05f));
            } else if (LoadMods.enableIC2Classic) {
                beeSpecies.addProduct(OreDicPreferences.get("dropUranium", 1), Float.valueOf(0.05f));
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeUranium);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(LeadBee, AustereBee, this.getTemplate(), MathUtil.maxInt((int)(8.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    RESONATING(BeeBranches.RADIOACTIVE, "Resonating", true, new Color(0xFF6565), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableResonating) {
                beeSpecies.addProduct(PluginApiculture.items.beeComb.get(EnumHoneyComb.SIMMERING, 1), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("oreResonating", 1), Float.valueOf(0.05f)).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.NORMAL);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeUranium);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(RadioactiveBee, RedstoneBee, this.getTemplate(), MathUtil.maxInt((int)(8.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    YELLORITE(BeeBranches.RADIOACTIVE, "Yellorite", true, new Color(14151424), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableYellorite) {
                beeSpecies.addProduct(PluginApiculture.items.beeComb.get(EnumHoneyComb.SIMMERING, 1), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("oreYellorite", 1), Float.valueOf(0.05f)).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.NORMAL);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeUranium);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(RadioactiveBee, RedstoneBee, this.getTemplate(), MathUtil.maxInt((int)(8.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    URANIUM(BeeBranches.RADIOACTIVE, "Uranium", false, new Color(6995987), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableIC2 && !LoadMods.enableIC2Classic) {
                beeSpecies.addProduct(PluginApiculture.items.beeComb.get(EnumHoneyComb.SIMMERING, 1), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("crushedUranium", 1), Float.valueOf(0.15f)).setHasEffect().setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
            } else if (LoadMods.enableIC2Classic) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombRock), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dropUranium", 1), Float.valueOf(0.15f)).setHasEffect().setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NEVER_SLEEPS, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(RadioactiveBee, ApocalypticBee, this.getTemplate(), MathUtil.maxInt((int)(5.0f * Config.mutationMultipler), 100)).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        }
    }
    ,
    PRISMARINE(BeeBranches.AQUATIC, "Prismarine", true, new Color(6531997), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.items.beeComb.get(EnumHoneyComb.HONEY, 1), Float.valueOf(0.3f)).addProduct(new ItemStack(Items.field_179563_cD, 2), Float.valueOf(0.2f)).addProduct(new ItemStack(Items.field_179562_cC, 2), Float.valueOf(0.2f)).setHasEffect().setTemperature(EnumTemperature.NORMAL).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeWater);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(ObsidianBee, ClayBee, this.getTemplate(), MathUtil.maxInt((int)(15.0f * Config.mutationMultipler), 100)).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.OCEAN});
        }
    }
    ,
    APOCALYPTIC(BeeBranches.APOCALYTIC, "Apocalyptic", true, new Color(13332996), new Color(8588557)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.items.beeComb.get(EnumHoneyComb.SIMMERING, 1), Float.valueOf(0.3f)).addSpecialty(new ItemStack(Items.field_151065_br), Float.valueOf(0.2f)).addSpecialty(new ItemStack(Items.field_151016_H), Float.valueOf(0.2f)).addSpecialty(new ItemStack(Items.field_151073_bk), Float.valueOf(0.05f)).setJubilanceProvider(BeeManager.jubilanceFactory.getRequiresResource(new IBlockState[]{Blocks.field_150335_W.func_176223_P()})).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_3);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectCreeper);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeTNT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(AustereBee, DemonicBee, this.getTemplate(), MathUtil.maxInt((int)(5.0f * Config.mutationMultipler), 100)).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        }
    }
    ,
    WITHER(BeeBranches.WITHER, "Withering", false, new Color(0xC1C1C1), new Color(0x3C3C3C)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombWither), Float.valueOf(0.3f)).addSpecialty(new ItemStack(Items.field_151144_bL, 1, 1), Float.valueOf(0.05f)).setJubilanceProvider((IJubilanceProvider)new WitherSkullJubilance()).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_3);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(ApocalypticBee, DemonicBee, this.getTemplate(), MathUtil.maxInt((int)(5.0f * Config.mutationMultipler), 100)).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        }
    }
    ,
    NETHERSTAR(BeeBranches.WITHER, "Wither", false, new Color(0xC1C1C1), new Color(0x3C3C3C)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombWither), Float.valueOf(0.35f)).addSpecialty(new ItemStack((Item)MoreBeesItems.NetherFrag), Float.valueOf(0.03f)).setJubilanceProvider((IJubilanceProvider)new WitherSkullJubilance()).setHasEffect().setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_3);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(WitherBee, EnderBee, this.getTemplate(), MathUtil.maxInt((int)(2.0f * Config.mutationMultipler), 100)).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        }
    }
    ,
    SLIMEY(BeeBranches.Slime, "Slimey", true, new Color(8243315), new Color(8243315)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombSlime), Float.valueOf(0.7f)).setTemperature(EnumTemperature.NORMAL).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)Register.FlowerTypeSlime);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)Register.effectSlimey);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(RockBee, BoggyBee, this.getTemplate(), MathUtil.maxInt((int)(30.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    BLUESLIMEY(BeeBranches.Slime, "BlueSlimey", true, new Color(8243315), new Color(7653575)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableTinkers) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombSlime), Float.valueOf(0.55f)).addProduct(OreDicPreferences.get("slimeballBlue", 1), Float.valueOf(0.55f)).setTemperature(EnumTemperature.NORMAL).setHumidity(EnumHumidity.DAMP);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(SlimeyBee, PrismarineBee, this.getTemplate(), MathUtil.maxInt((int)(30.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    PURPLESLIMEY(BeeBranches.Slime, "PurpleSlimey", false, new Color(8243315), new Color(12278527)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableTinkers) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombSlime), Float.valueOf(0.55f)).addProduct(OreDicPreferences.get("slimeballPurple", 1), Float.valueOf(0.55f)).setTemperature(EnumTemperature.NORMAL).setHumidity(EnumHumidity.DAMP);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            System.out.println(BlueSlimeyBee);
            BeeManager.beeMutationFactory.createMutation(BlueSlimeyBee, RedstoneBee, this.getTemplate(), MathUtil.maxInt((int)(8.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    MAGMASLIMEY(BeeBranches.Slime, "MagmaSlimey", false, new Color(8243315), new Color(16755529)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableTinkers) {
                beeSpecies.addProduct(new ItemStack((Item)MoreBeesItems.CombSlime), Float.valueOf(0.55f)).addProduct(OreDicPreferences.get("slimeballMagma", 1), Float.valueOf(0.55f)).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(SlimeyBee, FiendishBee, this.getTemplate(), MathUtil.maxInt((int)(10.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    STRINGY((IBranchDefinition)BeeBranchDefinition.TROPICAL, "Stringy", false, new Color(0x6D6D6D), new Color(0xE5E5E5)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(PluginApiculture.items.beeComb.get(EnumHoneyComb.SILKY, 1), Float.valueOf(0.3f)).addProduct(PluginApiculture.items.beeComb.get(EnumHoneyComb.STRINGY, 1), Float.valueOf(0.3f)).addProduct(new ItemStack(Items.field_151007_F, 1), Float.valueOf(0.7f)).setTemperature(EnumTemperature.WARM).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(TropicalBee, DiligentBee, this.getTemplate(), MathUtil.maxInt((int)(10.0f * Config.mutationMultipler), 100));
        }
    }
    ,
    DRACONIC((IBranchDefinition)BeeBranchDefinition.END, "Draconic", true, new Color(4984448), new Color(8588557)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            if (LoadMods.enableDraconium) {
                beeSpecies.addProduct(PluginApiculture.items.beeComb.get(EnumHoneyComb.MYSTERIOUS, 1), Float.valueOf(0.3f)).addProduct(OreDicPreferences.get("dustDraconium", 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.COLD).setHumidity(EnumHumidity.ARID);
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
        }

        @Override
        protected void registerMutations() {
            BeeManager.beeMutationFactory.createMutation(AustereBee, EnderBee, this.getTemplate(), MathUtil.maxInt((int)(5.0f * Config.mutationMultipler), 100)).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        }
    };

    private static final IAlleleBeeSpecies[] hiveBees;
    private static IAlleleBeeSpecies SteadfastBee;
    private static IAlleleBeeSpecies CultivatedBee;
    private static IAlleleBeeSpecies SinisterBee;
    private static IAlleleBeeSpecies FiendishBee;
    private static IAlleleBeeSpecies IndustriousBee;
    private static IAlleleBeeSpecies ImperialBee;
    private static IAlleleBeeSpecies AustereBee;
    private static IAlleleBeeSpecies DemonicBee;
    private static IAlleleBeeSpecies EnderBee;
    private static IAlleleBeeSpecies BoggyBee;
    private static IAlleleBeeSpecies DiligentBee;
    private static IAlleleBeeSpecies TropicalBee;
    private static IAlleleBeeSpecies RockBee;
    private static IAlleleBeeSpecies HardenedBee;
    private static IAlleleBeeSpecies ObsidianBee;
    private static IAlleleBeeSpecies LapisBee;
    private static IAlleleBeeSpecies QuartzBee;
    private static IAlleleBeeSpecies RedstoneBee;
    private static IAlleleBeeSpecies EmeraldBee;
    private static IAlleleBeeSpecies DirtBee;
    private static IAlleleBeeSpecies ClayBee;
    private static IAlleleBeeSpecies MetallicBee;
    private static IAlleleBeeSpecies LeadBee;
    private static IAlleleBeeSpecies GoldBee;
    private static IAlleleBeeSpecies TinBee;
    private static IAlleleBeeSpecies RadioactiveBee;
    private static IAlleleBeeSpecies ApocalypticBee;
    private static IAlleleBeeSpecies WitherBee;
    private static IAlleleBeeSpecies SlimeyBee;
    private static IAlleleBeeSpecies BlueSlimeyBee;
    private static IAlleleBeeSpecies PrismarineBee;
    private static IAlleleBeeSpecies CopperBee;
    private final IBranchDefinition branch;
    private final IAlleleBeeSpecies species;
    private IAllele[] template;
    private IBeeGenome genome;

    private BeeSpecies(IBranchDefinition branch, String binomial, boolean dominant, Color primary, Color secondary) {
        String lowercaseName = this.toString().toLowerCase(Locale.ENGLISH);
        String species = "species" + WordUtils.capitalize((String)lowercaseName);
        String ID = "morebees." + species;
        String description = "morebees.description." + species;
        String name = "for.bees.species." + lowercaseName;
        this.branch = branch;
        IAlleleBeeSpeciesBuilder speciesBuilder = BeeManager.beeFactory.createSpecies(ID, dominant, "Lach_01298", name, description, branch.getBranch(), binomial, primary.getRGB(), secondary.getRGB());
        if (this.isSecret()) {
            speciesBuilder.setIsSecret();
        }
        this.setSpeciesProperties(speciesBuilder);
        this.species = speciesBuilder.build();
    }

    protected abstract void setSpeciesProperties(IAlleleBeeSpeciesBuilder var1);

    protected abstract void setAlleles(IAllele[] var1);

    protected abstract void registerMutations();

    protected boolean isSecret() {
        return false;
    }

    public static void initBees() {
        block24: for (BeeSpecies bee : BeeSpecies.values()) {
            switch (bee) {
                case DIAMOND: {
                    if (!Config.diamondBees) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case NETHERSTAR: {
                    if (!Config.netherStarBees) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case WITHER: {
                    if (!Config.witherBees) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case APOCALYPTIC: {
                    if (!Config.apocalypticBees) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case LEAD: {
                    if (!LoadMods.enableLead) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case SILVER: {
                    if (!LoadMods.enableSilver) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case RADIOACTIVE: {
                    if (!Config.radioactiveBees) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case RESONATING: {
                    if (!LoadMods.enableResonating || !Config.resonatingBees) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case YELLORITE: {
                    if (!LoadMods.enableYellorite || !Config.yelloriteBees) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case URANIUM: {
                    if (!LoadMods.enableIC2 || !Config.uranicBees) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case ALUMINIUM: {
                    if (!LoadMods.enableAluminium) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case RUBY: {
                    if (!LoadMods.enableRuby) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case SAPPHIRE: {
                    if (!LoadMods.enableSapphire) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case SULFUR: {
                    if (!LoadMods.enableSulfur) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case CERTUS: {
                    if (!LoadMods.enableCertusQuartz || !Config.certusQuartzBees) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case COBALT: {
                    if (!LoadMods.enableTinkers || !Config.tinkersMetalBees) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case ARDITE: {
                    if (!LoadMods.enableTinkers || !Config.tinkersMetalBees) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case OSMIUM: {
                    if (!LoadMods.enableOsmium) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case DRACONIC: {
                    if (!LoadMods.enableDraconium || !Config.draconicBees) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case BLUESLIMEY: {
                    if (!LoadMods.enableTinkers || !Config.tinkersSlimeBees) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case MAGMASLIMEY: {
                    if (!LoadMods.enableTinkers || !Config.tinkersSlimeBees) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                case PURPLESLIMEY: {
                    if (!LoadMods.enableTinkers || !Config.tinkersSlimeBees) continue block24;
                    bee.init();
                    bee.registerMutations();
                    continue block24;
                }
                default: {
                    bee.init();
                    bee.registerMutations();
                }
            }
        }
    }

    public static void preInit() {
    }

    private void init() {
        this.template = this.branch.getTemplate();
        AlleleHelper.instance.set(this.template, (Enum)EnumBeeChromosome.SPECIES, (IAllele)this.species);
        this.setAlleles(this.template);
        this.genome = BeeManager.beeRoot.templateAsGenome(this.template);
        BeeManager.beeRoot.registerTemplate(this.template);
    }

    public final IAllele[] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    public final IBeeGenome getGenome() {
        return this.genome;
    }

    public final IBee getIndividual() {
        return new Bee(this.genome);
    }

    public final ItemStack getMemberStack(EnumBeeType beeType) {
        IBee bee = this.getIndividual();
        return BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)beeType);
    }

    public final IBeeDefinition getRainResist() {
        return new BeeVariation.RainResist((IBeeDefinition)this);
    }

    static {
        hiveBees = new IAlleleBeeSpecies[]{(IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesForest"), (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesMarshy"), (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesMeadows"), (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesModest"), (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesTropical"), (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesWintry")};
        SteadfastBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesSteadfast");
        CultivatedBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesCultivated");
        SinisterBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesSinister");
        FiendishBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesFiendish");
        IndustriousBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesIndustrious");
        ImperialBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesImperial");
        AustereBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesAustere");
        DemonicBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesDemonic");
        EnderBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesEnded");
        BoggyBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesBoggy");
        DiligentBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesDiligent");
        TropicalBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesTropical");
        RockBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesRock");
        HardenedBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesHardened");
        ObsidianBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesObsidian");
        LapisBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesLapis");
        QuartzBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesQuartz");
        RedstoneBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesRedstone");
        EmeraldBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesEmerald");
        DirtBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesDirt");
        ClayBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesClay");
        MetallicBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesMetallic");
        LeadBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesLead");
        GoldBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesGold");
        TinBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesTin");
        RadioactiveBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesRadioactive");
        ApocalypticBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesApocalyptic");
        WitherBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesWither");
        SlimeyBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesSlimey");
        BlueSlimeyBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesBlueslimey");
        PrismarineBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesPrismarine");
        CopperBee = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("morebees.speciesCopper");
    }
}

