/*
 * Decompiled with CFR 0.152.
 */
package assets.recipehandler;

import assets.recipehandler.CraftingHandler;
import assets.recipehandler.RecipeMod;
import com.google.common.util.concurrent.ListenableFuture;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;

public final class ChangePacket {
    public static final String CHANNEL = "recipemod:key";
    private ItemStack itemstack;
    private int slot;
    private int index;

    public ChangePacket() {
    }

    public ChangePacket(int slot, ItemStack stack, int recipeIndex) {
        this.slot = slot;
        this.itemstack = stack;
        this.index = recipeIndex;
    }

    public ChangePacket fromBytes(ByteBuf buf) {
        this.slot = buf.readInt();
        this.itemstack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.index = buf.readInt();
        return this;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.itemstack);
        buf.writeInt(this.index);
    }

    ChangePacket handle(final EntityPlayerMP player) {
        if (this.itemstack != null && this.slot >= 0 && this.index >= 0) {
            ListenableFuture future = player.field_71133_b.func_175586_a((Callable)new Callable<ChangePacket>(){

                @Override
                public ChangePacket call() {
                    InventoryCrafting crafting = CraftingHandler.getCraftingMatrix(player.field_71070_bA);
                    if (crafting != null) {
                        Slot result;
                        CraftingHandler.setRecipeIndex(ChangePacket.this.index);
                        ItemStack itr = CraftingHandler.findMatchingRecipe(crafting, player.field_70170_p);
                        if (ItemStack.func_77989_b((ItemStack)itr, (ItemStack)ChangePacket.this.itemstack) && (result = CraftingHandler.getResultSlot(player.field_71070_bA, ChangePacket.this.slot)) != null) {
                            result.func_75215_d(ChangePacket.this.itemstack.func_77946_l());
                            return new ChangePacket(ChangePacket.this.slot, ChangePacket.this.itemstack, ChangePacket.this.index);
                        }
                    }
                    return null;
                }
            });
            try {
                return (ChangePacket)future.get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public FMLProxyPacket toProxy(Side side) {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        this.toBytes((ByteBuf)buf);
        FMLProxyPacket proxy = new FMLProxyPacket(buf, CHANNEL);
        proxy.setTarget(side);
        return proxy;
    }

    public Runnable getRun() {
        return new Runnable(){

            @Override
            public void run() {
                Slot result = CraftingHandler.getResultSlot(RecipeMod.registry.getPlayer().field_71070_bA, ChangePacket.this.slot);
                if (result != null) {
                    result.func_75215_d(ChangePacket.this.itemstack);
                }
            }
        };
    }
}

