/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.render;

import com.enderio.core.common.util.Log;
import java.util.HashSet;
import java.util.Set;
import org.lwjgl.opengl.GL11;

public class GlState {
    private final Set<String> before = GlState.getGLStates();
    private final String location;
    static String[] glStates = new String[]{"GL_ALPHA_TEST", "GL_AUTO_NORMAL", "GL_BLEND", "GL_CLIP_PLANE0", "GL_CLIP_PLANE1", "GL_CLIP_PLANE2", "GL_CLIP_PLANE3", "GL_CLIP_PLANE4", "GL_CLIP_PLANE5", "GL_COLOR_ARRAY", "GL_COLOR_LOGIC_OP", "GL_COLOR_MATERIAL", "GL_CULL_FACE", "GL_DEPTH_TEST", "GL_DITHER", "GL_FOG", "GL_INDEX_ARRAY", "GL_INDEX_LOGIC_OP", "GL_LIGHT0", "GL_LIGHT1", "GL_LIGHT2", "GL_LIGHT3", "GL_LIGHT4", "GL_LIGHT5", "GL_LIGHT6", "GL_LIGHT7", "GL_LIGHTING", "GL_LINE_SMOOTH", "GL_LINE_STIPPLE", "GL_MAP1_COLOR_4", "GL_MAP1_INDEX", "GL_MAP1_NORMAL", "GL_MAP1_TEXTURE_COORD_1", "GL_MAP1_TEXTURE_COORD_2", "GL_MAP1_TEXTURE_COORD_3", "GL_MAP1_TEXTURE_COORD_4", "GL_MAP1_VERTEX_3", "GL_MAP1_VERTEX_4", "GL_MAP2_COLOR_4", "GL_MAP2_INDEX", "GL_MAP2_NORMAL", "GL_MAP2_TEXTURE_COORD_1", "GL_MAP2_TEXTURE_COORD_2", "GL_MAP2_TEXTURE_COORD_3", "GL_MAP2_TEXTURE_COORD_4", "GL_MAP2_VERTEX_3", "GL_MAP2_VERTEX_4", "GL_NORMAL_ARRAY", "GL_NORMALIZE", "GL_POINT_SMOOTH", "GL_POLYGON_OFFSET_FILL", "GL_POLYGON_OFFSET_LINE", "GL_POLYGON_OFFSET_POINT", "GL_POLYGON_SMOOTH", "GL_POLYGON_STIPPLE", "GL_SCISSOR_TEST", "GL_STENCIL_TEST", "GL_TEXTURE_1D", "GL_TEXTURE_2D", "GL_TEXTURE_COORD_ARRAY", "GL_TEXTURE_GEN_Q", "GL_TEXTURE_GEN_R", "GL_TEXTURE_GEN_S", "GL_TEXTURE_GEN_T", "GL_VERTEX_ARRAY"};
    public static int[] glCaps;

    public GlState(String location) {
        this.location = location;
    }

    private static void initGLStates() {
        glCaps = new int[glStates.length];
        for (int i = 0; i < glStates.length; ++i) {
            GlState.glCaps[i] = -1;
            try {
                GlState.glCaps[i] = GL11.class.getField(glStates[i]).getInt(null);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static Set<String> getGLStates() {
        if (glCaps == null) {
            GlState.initGLStates();
        }
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < glCaps.length; ++i) {
            if (glCaps[i] == -1 || !GL11.glIsEnabled((int)glCaps[i])) continue;
            result.add(glStates[i]);
        }
        return result;
    }

    public void finish() {
        Set<String> after = GlState.getGLStates();
        if (!this.before.equals(after)) {
            HashSet<String> added = new HashSet<String>();
            HashSet<String> removed = new HashSet<String>();
            for (String string : this.before) {
                if (after.contains(string)) continue;
                removed.add(string);
            }
            for (String string : after) {
                if (this.before.contains(string)) continue;
                added.add(string);
            }
            Log.error("GL flag corruption at " + this.location + ": Lost " + removed + " gained " + added);
        }
    }

    public void dump() {
        Log.info("GL flags at " + this.location + ": " + this.before);
    }
}

