/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.TeslaUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public final class WorldUtil {
    public static boolean doItemInteraction(int slotExtract, int slotInsert, TileEntity extract, TileEntity insert, EnumFacing extractSide, EnumFacing insertSide) {
        if (extract.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, extractSide) && insert.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, insertSide)) {
            ItemStack remaining;
            IItemHandler extractCap = (IItemHandler)extract.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, extractSide);
            IItemHandler insertCap = (IItemHandler)insert.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, insertSide);
            ItemStack theoreticalExtract = extractCap.extractItem(slotExtract, Integer.MAX_VALUE, true);
            if (StackUtil.isValid(theoreticalExtract) && !ItemStack.func_77989_b((ItemStack)(remaining = insertCap.insertItem(slotInsert, theoreticalExtract, false)), (ItemStack)theoreticalExtract)) {
                int toExtract = !StackUtil.isValid(remaining) ? StackUtil.getStackSize(theoreticalExtract) : StackUtil.getStackSize(theoreticalExtract) - StackUtil.getStackSize(remaining);
                extractCap.extractItem(slotExtract, toExtract, false);
                return true;
            }
        }
        return false;
    }

    public static void doEnergyInteraction(TileEntity tileFrom, TileEntity tileTo, EnumFacing sideTo, int maxTransfer) {
        if (maxTransfer > 0) {
            if (tileFrom instanceof IEnergyProvider && tileTo instanceof IEnergyReceiver) {
                IEnergyReceiver handlerTo = (IEnergyReceiver)tileTo;
                IEnergyProvider handlerFrom = (IEnergyProvider)tileFrom;
                int drain = handlerFrom.extractEnergy(sideTo, maxTransfer, true);
                if (drain > 0 && handlerTo.canConnectEnergy(sideTo.func_176734_d())) {
                    int filled = handlerTo.receiveEnergy(sideTo.func_176734_d(), drain, false);
                    handlerFrom.extractEnergy(sideTo, filled, false);
                }
            } else if (ActuallyAdditions.teslaLoaded) {
                TeslaUtil.doWrappedTeslaRFInteraction(tileFrom, tileTo, sideTo, maxTransfer);
            }
        }
    }

    public static void doFluidInteraction(TileEntity tileFrom, TileEntity tileTo, EnumFacing sideTo, int maxTransfer) {
        if (maxTransfer > 0) {
            if (tileFrom instanceof net.minecraftforge.fluids.IFluidHandler && tileTo instanceof net.minecraftforge.fluids.IFluidHandler) {
                net.minecraftforge.fluids.IFluidHandler handlerTo = (net.minecraftforge.fluids.IFluidHandler)tileTo;
                net.minecraftforge.fluids.IFluidHandler handlerFrom = (net.minecraftforge.fluids.IFluidHandler)tileFrom;
                FluidStack drain = handlerFrom.drain(sideTo, maxTransfer, false);
                if (drain != null && handlerTo.canFill(sideTo.func_176734_d(), drain.getFluid())) {
                    int filled = handlerTo.fill(sideTo.func_176734_d(), drain.copy(), true);
                    handlerFrom.drain(sideTo, filled, true);
                }
            } else if (tileFrom.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, sideTo) && tileTo.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, sideTo.func_176734_d())) {
                IFluidHandler handlerFrom = (IFluidHandler)tileFrom.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, sideTo);
                IFluidHandler handlerTo = (IFluidHandler)tileTo.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, sideTo.func_176734_d());
                FluidStack drain = handlerFrom.drain(maxTransfer, false);
                if (drain != null) {
                    int filled = handlerTo.fill(drain.copy(), true);
                    handlerFrom.drain(filled, true);
                }
            }
        }
    }

    public static boolean hasBlocksInPlacesGiven(BlockPos[] positions, Block block, int meta, World world) {
        for (BlockPos pos : positions) {
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() == block && block.func_176201_c(state) == meta) continue;
            return false;
        }
        return true;
    }

    public static ItemStack useItemAtSide(EnumFacing side, World world, BlockPos pos, ItemStack stack) {
        if (world instanceof WorldServer && StackUtil.isValid(stack) && pos != null) {
            BlockPos offsetPos = pos.func_177972_a(side);
            IBlockState state = world.func_180495_p(offsetPos);
            Block block = state.func_177230_c();
            boolean replaceable = block.func_176200_f((IBlockAccess)world, offsetPos);
            if (replaceable && !(block instanceof IFluidBlock) && !(block instanceof BlockLiquid)) {
                Block fluidBlock;
                Fluid theFluid;
                FluidStack fluid = null;
                if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
                    fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
                } else if (stack.func_77973_b() instanceof IFluidContainerItem) {
                    fluid = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
                }
                if (fluid != null && fluid.amount >= 1000 && (theFluid = fluid.getFluid()) != null && (fluidBlock = theFluid.getBlock()) != null && fluidBlock.func_176196_c(world, offsetPos) && world.func_180501_a(offsetPos, fluidBlock.func_176223_P(), 2)) {
                    return stack.func_77973_b().getContainerItem(stack);
                }
            }
            if (replaceable && stack.func_77973_b() == Items.field_151137_ax) {
                world.func_180501_a(offsetPos, Blocks.field_150488_af.func_176223_P(), 2);
                return StackUtil.addStackSize(stack, -1);
            }
            if (replaceable && stack.func_77973_b() instanceof IPlantable && ((IPlantable)stack.func_77973_b()).getPlant((IBlockAccess)world, offsetPos).func_177230_c().func_176196_c(world, offsetPos) && world.func_180501_a(offsetPos, ((IPlantable)stack.func_77973_b()).getPlant((IBlockAccess)world, offsetPos), 2)) {
                return StackUtil.addStackSize(stack, -1);
            }
            try {
                if (world instanceof WorldServer) {
                    FakePlayer fake = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
                    stack.func_179546_a((EntityPlayer)fake, world, offsetPos, fake.func_184600_cs(), side.func_176734_d(), 0.5f, 0.5f, 0.5f);
                    return stack;
                }
            }
            catch (Exception e) {
                ModUtil.LOGGER.error("Something that places Blocks at " + offsetPos.func_177958_n() + ", " + offsetPos.func_177956_o() + ", " + offsetPos.func_177952_p() + " in World " + world.field_73011_w.getDimension() + " threw an Exception! Don't let that happen again!", (Throwable)e);
            }
        }
        return stack;
    }

    public static void dropItemAtSide(EnumFacing side, World world, BlockPos pos, ItemStack stack) {
        BlockPos coords = pos.func_177972_a(side);
        EntityItem item = new EntityItem(world, (double)coords.func_177958_n() + 0.5, (double)coords.func_177956_o() + 0.5, (double)coords.func_177952_p() + 0.5, stack);
        item.field_70159_w = 0.0;
        item.field_70181_x = 0.0;
        item.field_70179_y = 0.0;
        world.func_72838_d((Entity)item);
    }

    public static EnumFacing getDirectionBySidesInOrder(int side) {
        switch (side) {
            case 0: {
                return EnumFacing.UP;
            }
            case 1: {
                return EnumFacing.DOWN;
            }
            case 2: {
                return EnumFacing.NORTH;
            }
            case 3: {
                return EnumFacing.EAST;
            }
            case 4: {
                return EnumFacing.SOUTH;
            }
        }
        return EnumFacing.WEST;
    }

    public static EnumFacing getDirectionByPistonRotation(int meta) {
        return EnumFacing.values()[meta];
    }

    public static ArrayList<Material> getMaterialsAround(World world, BlockPos pos) {
        ArrayList<Material> blocks = new ArrayList<Material>();
        blocks.add(world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH)).func_185904_a());
        blocks.add(world.func_180495_p(pos.func_177972_a(EnumFacing.EAST)).func_185904_a());
        blocks.add(world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH)).func_185904_a());
        blocks.add(world.func_180495_p(pos.func_177972_a(EnumFacing.WEST)).func_185904_a());
        return blocks;
    }

    public static boolean addToInventory(IInventory inventory, List<ItemStack> stacks, boolean actuallyDo, boolean shouldAlwaysWork) {
        return WorldUtil.addToInventory(inventory, stacks, EnumFacing.UP, actuallyDo, shouldAlwaysWork);
    }

    public static boolean addToInventory(IInventory inventory, List<ItemStack> stacks, EnumFacing side, boolean actuallyDo, boolean shouldAlwaysWork) {
        return WorldUtil.addToInventory(inventory, 0, inventory.func_70302_i_(), stacks, side, actuallyDo, shouldAlwaysWork);
    }

    public static boolean addToInventory(IInventory inventory, int start, int end, List<ItemStack> stacks, EnumFacing side, boolean actuallyDo, boolean shouldAlwaysWork) {
        ItemStack[] backupSlots = null;
        if (!actuallyDo) {
            backupSlots = new ItemStack[inventory.func_70302_i_()];
            for (int i = 0; i < backupSlots.length; ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (!StackUtil.isValid(stack)) continue;
                backupSlots[i] = stack.func_77946_l();
            }
        }
        int working = 0;
        block1: for (ItemStack stackToPutIn : stacks) {
            for (int i = start; i < end; ++i) {
                if (!shouldAlwaysWork && (inventory instanceof ISidedInventory && !((ISidedInventory)inventory).func_180462_a(i, stackToPutIn, side) || !inventory.func_94041_b(i, stackToPutIn))) continue;
                ItemStack stackInQuestion = inventory.func_70301_a(i);
                if (!StackUtil.isValid(stackToPutIn) || StackUtil.isValid(stackInQuestion) && (!ItemUtil.canBeStacked(stackInQuestion, stackToPutIn) || stackInQuestion.func_77976_d() < StackUtil.getStackSize(stackInQuestion) + StackUtil.getStackSize(stackToPutIn))) continue;
                if (!StackUtil.isValid(stackInQuestion)) {
                    inventory.func_70299_a(i, stackToPutIn.func_77946_l());
                } else {
                    inventory.func_70299_a(i, StackUtil.addStackSize(stackInQuestion, StackUtil.getStackSize(stackToPutIn)));
                }
                ++working;
                continue block1;
            }
        }
        if (!actuallyDo) {
            for (int i = 0; i < backupSlots.length; ++i) {
                inventory.func_70299_a(i, backupSlots[i]);
            }
        }
        return working >= stacks.size();
    }

    public static int findFirstFilledSlot(ItemStack[] slots) {
        for (int i = 0; i < slots.length; ++i) {
            if (!StackUtil.isValid(slots[i])) continue;
            return i;
        }
        return 0;
    }

    public static RayTraceResult getNearestPositionWithAir(World world, EntityPlayer player, int reach) {
        return WorldUtil.getMovingObjectPosWithReachDistance(world, player, reach, false, false, true);
    }

    private static RayTraceResult getMovingObjectPosWithReachDistance(World world, EntityPlayer player, double distance, boolean p1, boolean p2, boolean p3) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        double d0 = player.field_70165_t;
        double d1 = player.field_70163_u + (double)player.func_70047_e();
        double d2 = player.field_70161_v;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3d vec31 = vec3.func_72441_c((double)f6 * distance, (double)f5 * distance, (double)f7 * distance);
        return world.func_147447_a(vec3, vec31, p1, p2, p3);
    }

    public static RayTraceResult getNearestBlockWithDefaultReachDistance(World world, EntityPlayer player) {
        return WorldUtil.getNearestBlockWithDefaultReachDistance(world, player, false, true, false);
    }

    public static RayTraceResult getNearestBlockWithDefaultReachDistance(World world, EntityPlayer player, boolean stopOnLiquids, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        return WorldUtil.getMovingObjectPosWithReachDistance(world, player, player instanceof EntityPlayerMP ? ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() : 5.0, stopOnLiquids, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock);
    }

    public static boolean playerHarvestBlock(ItemStack stack, World world, EntityPlayer player, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!world.field_72995_K) {
            world.func_180498_a(player, 2001, pos, Block.func_176210_f((IBlockState)state));
        } else {
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_176208_a(world, pos, state, player);
            if (block.removedByPlayer(state, world, pos, player, false)) {
                block.func_176206_d(world, pos, state);
            }
            if (!world.field_72995_K && player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            }
            return true;
        }
        stack.func_179548_a(world, state, pos, player);
        if (!world.field_72995_K) {
            if (player instanceof EntityPlayerMP) {
                EntityPlayerMP playerMp = (EntityPlayerMP)player;
                int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerMp.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMp, (BlockPos)pos);
                if (xp == -1) {
                    return false;
                }
                TileEntity tileEntity = world.func_175625_s(pos);
                if (block.removedByPlayer(state, world, pos, player, true)) {
                    block.func_176206_d(world, pos, state);
                    block.func_180657_a(world, player, pos, state, tileEntity, stack);
                    block.func_180637_b(world, pos, xp);
                }
                playerMp.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
                return true;
            }
        } else {
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
            }
            if (StackUtil.getStackSize(stack) <= 0 && stack == player.func_184614_ca()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)stack, (EnumHand)EnumHand.MAIN_HAND);
                player.func_184611_a(EnumHand.MAIN_HAND, null);
            }
            if (ConfigBoolValues.ENABLE_DRILL_DIGGING_PACKET.isEnabled()) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, mc.field_71476_x.field_178784_b));
            }
            return true;
        }
        return false;
    }

    public static float fireFakeHarvestEventsForDropChance(List<ItemStack> drops, World world, BlockPos pos) {
        if (!world.field_72995_K && world instanceof WorldServer) {
            FakePlayer fake = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
            IBlockState state = world.func_180495_p(pos);
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (EntityPlayer)fake);
            if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                return ForgeEventFactory.fireBlockHarvesting(drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)fake);
            }
        }
        return 0.0f;
    }
}

