/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.gen;

import de.ellpeck.actuallyadditions.mod.misc.DungeonLoot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.storage.loot.ILootContainer;

public class WorldGenLushCaves {
    public boolean generate(World world, Random rand, BlockPos position, StructureBoundingBox blockRegion) {
        this.generateCave(world, position, rand, blockRegion);
        return true;
    }

    private void generateCave(World world, BlockPos center, Random rand, StructureBoundingBox chunkRegion) {
        int spheres = rand.nextInt(5) + 3;
        StructureBoundingBox spheresBox = new StructureBoundingBox(chunkRegion);
        spheresBox.field_78897_a -= 7;
        spheresBox.field_78896_c -= 7;
        spheresBox.field_78893_d += 7;
        spheresBox.field_78892_f += 7;
        for (int i = 0; i <= spheres; ++i) {
            this.makeSphereWithGrassFloor(world, center.func_177982_a(rand.nextInt(11) - 5, rand.nextInt(7) - 3, rand.nextInt(11) - 5), rand.nextInt(3) + 5, spheresBox);
        }
        this.genTreesAndTallGrass(world, center, 11, spheres * 3, rand, chunkRegion);
    }

    private void genTreesAndTallGrass(World world, BlockPos center, int radius, int amount, Random rand, StructureBoundingBox box) {
        ArrayList<BlockPos> possiblePoses = new ArrayList<BlockPos>();
        for (double x = (double)(-radius); x < (double)radius; x += 1.0) {
            for (double y = (double)(-radius); y < (double)radius; y += 1.0) {
                for (double z = (double)(-radius); z < (double)radius; z += 1.0) {
                    BlockPos pos;
                    if (!(rand.nextDouble() >= 0.5) || !box.func_175898_b((Vec3i)(pos = center.func_177963_a(x, y, z))) || world.func_180495_p(pos).func_177230_c() != Blocks.field_150349_c) continue;
                    possiblePoses.add(pos);
                }
            }
        }
        if (!possiblePoses.isEmpty()) {
            boolean chestGenDone = false;
            for (int i = 0; i <= amount; ++i) {
                Collections.shuffle(possiblePoses);
                BlockPos pos = (BlockPos)possiblePoses.get(0);
                if (rand.nextBoolean()) {
                    WorldGenTrees trees;
                    boolean genChest = false;
                    if (rand.nextBoolean()) {
                        if (rand.nextBoolean()) {
                            trees = new WorldGenBigTree(false);
                        } else {
                            trees = new WorldGenShrub(Blocks.field_150364_r.func_176223_P(), Blocks.field_150362_t.func_176223_P());
                            genChest = true;
                        }
                    } else {
                        trees = new WorldGenTrees(false);
                    }
                    trees.func_180709_b(world, rand, pos.func_177984_a());
                    if (chestGenDone || !genChest) continue;
                    BlockPos chestPos = pos.func_177982_a(MathHelper.func_76136_a((Random)rand, (int)-2, (int)2), MathHelper.func_76136_a((Random)rand, (int)3, (int)8), MathHelper.func_76136_a((Random)rand, (int)-2, (int)2));
                    IBlockState state = world.func_180495_p(chestPos);
                    if (state != null && state.func_177230_c().isLeaves(state, (IBlockAccess)world, chestPos)) {
                        world.func_175656_a(chestPos, Blocks.field_150486_ae.func_176223_P());
                        TileEntity chest = world.func_175625_s(chestPos);
                        if (chest instanceof TileEntityChest) {
                            ((TileEntityChest)chest).func_189404_a(DungeonLoot.LUSH_CAVES, rand.nextLong());
                        }
                    }
                    chestGenDone = true;
                    continue;
                }
                Blocks.field_150349_c.func_176474_b(world, rand, pos, world.func_180495_p(pos));
            }
        }
    }

    private void makeSphereWithGrassFloor(World world, BlockPos center, int radius, StructureBoundingBox boundingBox) {
        BlockPos pos;
        double x;
        for (x = (double)(-radius); x < (double)radius; x += 1.0) {
            for (double y = (double)(-radius); y < (double)radius; y += 1.0) {
                for (double z = (double)(-radius); z < (double)radius; z += 1.0) {
                    if (!(Math.sqrt(x * x + y * y + z * z) < (double)radius) || !boundingBox.func_175898_b((Vec3i)(pos = center.func_177963_a(x, y, z))) || this.checkIndestructable(world, pos)) continue;
                    world.func_175698_g(pos);
                }
            }
        }
        for (x = (double)(-radius); x < (double)radius; x += 1.0) {
            for (double z = (double)(-radius); z < (double)radius; z += 1.0) {
                for (double y = (double)(-radius); y <= -3.0; y += 1.0) {
                    pos = center.func_177963_a(x, y, z);
                    if (!boundingBox.func_175898_b((Vec3i)pos)) continue;
                    IBlockState state = world.func_180495_p(pos);
                    BlockPos posUp = pos.func_177984_a();
                    IBlockState stateUp = world.func_180495_p(posUp);
                    if (this.checkIndestructable(world, pos) || this.checkIndestructable(world, posUp) || state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || !stateUp.func_177230_c().isAir(stateUp, (IBlockAccess)world, posUp)) continue;
                    world.func_175656_a(pos, Blocks.field_150349_c.func_176223_P());
                }
            }
        }
    }

    private boolean checkIndestructable(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ILootContainer) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state != null) {
            Block block = state.func_177230_c();
            if (block == Blocks.field_150364_r || block == Blocks.field_150362_t || block == Blocks.field_150329_H) {
                return true;
            }
            if (block != null && (block.isAir(state, (IBlockAccess)world, pos) || (float)block.getHarvestLevel(state) >= 0.0f)) {
                return false;
            }
        }
        return true;
    }
}

