/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.net;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.item.ItemChestSackEmpty;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketStorageSack
implements IMessage,
IMessageHandler<PacketStorageSack, IMessage> {
    private BlockPos pos;

    public PacketStorageSack() {
    }

    public PacketStorageSack(BlockPos mouseover) {
        this.pos = mouseover;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        int x = tags.func_74762_e("x");
        int y = tags.func_74762_e("y");
        int z = tags.func_74762_e("z");
        this.pos = new BlockPos(x, y, z);
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("x", this.pos.func_177958_n());
        tags.func_74768_a("y", this.pos.func_177956_o());
        tags.func_74768_a("z", this.pos.func_177952_p());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    public IMessage onMessage(PacketStorageSack message, MessageContext ctx) {
        PacketStorageSack.checkThreadAndEnqueue(message, ctx);
        return null;
    }

    private static void checkThreadAndEnqueue(final PacketStorageSack message, final MessageContext ctx) {
        if (ctx.side.isServer() && message != null && message.pos != null) {
            IThreadListener thread = ModCyclic.proxy.getThreadFromContext(ctx);
            thread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Item chest_sack;
                    BlockPos position = message.pos;
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    World world = player.func_130014_f_();
                    TileEntity tile = world.func_175625_s(position);
                    IBlockState state = world.func_180495_p(position);
                    NBTTagCompound tileData = new NBTTagCompound();
                    tile.func_189515_b(tileData);
                    NBTTagCompound itemData = new NBTTagCompound();
                    itemData.func_74778_a("blockname", state.func_177230_c().func_149739_a());
                    itemData.func_74782_a("tile", (NBTBase)tileData);
                    itemData.func_74768_a("block", Block.func_149682_b((Block)state.func_177230_c()));
                    itemData.func_74768_a("blockstate", state.func_177230_c().func_176201_c(state));
                    EnumHand hand = EnumHand.MAIN_HAND;
                    ItemStack held = player.func_184586_b(hand);
                    if (held == null || !(held.func_77973_b() instanceof ItemChestSackEmpty)) {
                        hand = EnumHand.OFF_HAND;
                        held = player.func_184586_b(hand);
                    }
                    if (held != null && held.field_77994_a > 0 && held.func_77973_b() instanceof ItemChestSackEmpty && (chest_sack = ((ItemChestSackEmpty)held.func_77973_b()).getFullSack()) != null) {
                        ItemStack drop = new ItemStack(chest_sack);
                        drop.func_77982_d(itemData);
                        UtilItemStack.dropItemStackInWorld(world, player.func_180425_c(), drop);
                        UtilPlaceBlocks.destroyBlock(world, position);
                        if (!player.field_71075_bZ.field_75098_d && held.field_77994_a > 0) {
                            --held.field_77994_a;
                            if (held.field_77994_a == 0) {
                                held = null;
                                player.func_184611_a(hand, null);
                            }
                        }
                    }
                }
            });
        }
    }
}

