/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.net;

import com.lothrazar.cyclicmagic.item.tool.ItemToolRandomize;
import com.lothrazar.cyclicmagic.util.UtilPlaceBlocks;
import com.lothrazar.cyclicmagic.util.UtilWorld;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRandomize
implements IMessage,
IMessageHandler<PacketRandomize, IMessage> {
    private BlockPos pos;
    private ItemToolRandomize.ActionType actionType;
    private EnumFacing side;

    public PacketRandomize() {
    }

    public PacketRandomize(BlockPos mouseover, EnumFacing s, ItemToolRandomize.ActionType t) {
        this.pos = mouseover;
        this.actionType = t;
        this.side = s;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tags = ByteBufUtils.readTag((ByteBuf)buf);
        int x = tags.func_74762_e("x");
        int y = tags.func_74762_e("y");
        int z = tags.func_74762_e("z");
        this.pos = new BlockPos(x, y, z);
        int s = tags.func_74762_e("s");
        this.side = EnumFacing.values()[s];
        int t = tags.func_74762_e("t");
        this.actionType = ItemToolRandomize.ActionType.values()[t];
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("x", this.pos.func_177958_n());
        tags.func_74768_a("y", this.pos.func_177956_o());
        tags.func_74768_a("z", this.pos.func_177952_p());
        tags.func_74768_a("t", this.actionType.ordinal());
        tags.func_74768_a("s", this.side.ordinal());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMessage onMessage(PacketRandomize message, MessageContext ctx) {
        if (ctx.side.isServer() && message != null && message.pos != null) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World worldObj = player.func_130014_f_();
            List<Object> places = new ArrayList();
            int xMin = message.pos.func_177958_n();
            int yMin = message.pos.func_177956_o();
            int zMin = message.pos.func_177952_p();
            int xMax = message.pos.func_177958_n();
            int yMax = message.pos.func_177956_o();
            int zMax = message.pos.func_177952_p();
            boolean isVertical = message.side == EnumFacing.UP || message.side == EnumFacing.DOWN;
            int offsetRadius = 0;
            switch (message.actionType) {
                case X3: {
                    offsetRadius = 1;
                    break;
                }
                case X5: {
                    offsetRadius = 2;
                    break;
                }
                case X7: {
                    offsetRadius = 3;
                    break;
                }
                case X9: {
                    offsetRadius = 4;
                    break;
                }
            }
            if (offsetRadius > 0) {
                if (isVertical) {
                    xMin -= offsetRadius;
                    xMax += offsetRadius;
                    zMin -= offsetRadius;
                    zMax += offsetRadius;
                } else if (message.side == EnumFacing.EAST || message.side == EnumFacing.WEST) {
                    zMin -= offsetRadius;
                    zMax += offsetRadius;
                    yMin -= offsetRadius;
                    yMax += offsetRadius;
                } else {
                    xMin -= offsetRadius;
                    xMax += offsetRadius;
                    yMin -= offsetRadius;
                    yMax += offsetRadius;
                }
                places = UtilWorld.getPositionsInRange(message.pos, xMin, xMax, yMin, yMax, zMin, zMax);
            }
            ArrayList<BlockPos> rpos = new ArrayList<BlockPos>();
            ArrayList<IBlockState> rstates = new ArrayList<IBlockState>();
            for (BlockPos p : places) {
                if (worldObj.func_175625_s(p) != null || worldObj.func_175623_d(p) || !worldObj.isSideSolid(p, message.side) || worldObj.func_180495_p(p) == null) continue;
                rpos.add(p);
                rstates.add(worldObj.func_180495_p(p));
            }
            Collections.shuffle(rpos, worldObj.field_73012_v);
            ArrayList<BlockPos> arrayList = rpos;
            synchronized (arrayList) {
                for (int i = 0; i < rpos.size(); ++i) {
                    BlockPos swapPos = (BlockPos)rpos.get(i);
                    IBlockState swapState = (IBlockState)rstates.get(i);
                    worldObj.func_175655_b(swapPos, false);
                    UtilPlaceBlocks.placeStateSafe(worldObj, (EntityPlayer)player, swapPos, swapState);
                }
            }
        }
        return null;
    }
}

