/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.food;

import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.item.BaseItem;
import com.lothrazar.cyclicmagic.registry.ReflectionRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.HorseType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHorseUpgrade
extends BaseItem
implements IHasRecipe {
    public static int HEARTS_MAX;
    public static int SPEED_MAX;
    public static int JUMP_MAX;
    private static final double SPEED_AMT = 0.004;
    private static final double JUMP_AMT = 0.008;
    private ItemStack recipeItem;
    private HorseUpgradeType upgradeType;

    public ItemHorseUpgrade(HorseUpgradeType type, ItemStack rec) {
        this.recipeItem = rec;
        this.upgradeType = type;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        Item carrot = stack.func_77973_b();
        tooltip.add(UtilChat.lang(carrot.func_77667_c(stack) + ".effect"));
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{Items.field_151172_bF, this.recipeItem});
    }

    public static void onHorseInteract(EntityHorse horse, EntityPlayer player, ItemStack held, ItemHorseUpgrade heldItem) {
        boolean success = false;
        block0 : switch (heldItem.upgradeType) {
            case HEALTH: {
                float mh = (float)horse.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111126_e();
                if (!(mh < (float)(2 * HEARTS_MAX))) break;
                horse.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(mh + 2.0f));
                success = true;
                break;
            }
            case JUMP: {
                double jump;
                double newjump;
                if (ReflectionRegistry.horseJumpStrength == null || !(UtilEntity.getJumpTranslated(newjump = (jump = horse.func_110148_a(ReflectionRegistry.horseJumpStrength).func_111126_e()) + 0.008) < (double)JUMP_MAX)) break;
                horse.func_110148_a(ReflectionRegistry.horseJumpStrength).func_111128_a(newjump);
                success = true;
                break;
            }
            case SPEED: {
                double speed = horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
                double newSpeed = speed + 0.004;
                if (!(UtilEntity.getSpeedTranslated(newSpeed) < (double)SPEED_MAX)) break;
                horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(newSpeed);
                success = true;
                break;
            }
            case TYPE: {
                switch (horse.func_184781_cZ()) {
                    case HORSE: {
                        horse.func_184778_a(HorseType.ZOMBIE);
                        success = true;
                        break block0;
                    }
                    case ZOMBIE: {
                        horse.func_184778_a(HorseType.SKELETON);
                        success = true;
                        break block0;
                    }
                    case SKELETON: {
                        horse.func_184778_a(HorseType.HORSE);
                        success = true;
                        break block0;
                    }
                    case DONKEY: {
                        break block0;
                    }
                    case MULE: {
                        break block0;
                    }
                }
                break;
            }
            case VARIANT: {
                int var = horse.func_110202_bQ();
                int varReduced = 0;
                int varNew = 0;
                while (var - 256 > 0) {
                    varReduced += 256;
                    var -= 256;
                }
                switch (var) {
                    case 4: {
                        varNew = 3;
                        break;
                    }
                    case 3: {
                        varNew = 6;
                        break;
                    }
                    case 6: {
                        varNew = 2;
                        break;
                    }
                    case 2: {
                        varNew = 1;
                        break;
                    }
                    case 1: {
                        varNew = 5;
                        break;
                    }
                    case 5: {
                        varNew = 0;
                        break;
                    }
                    case 0: {
                        varNew = 4;
                    }
                }
                horse.func_110235_q(varNew += varReduced);
                success = true;
                break;
            }
        }
        if (success) {
            if (!player.field_71075_bZ.field_75098_d) {
                --held.field_77994_a;
            }
            UtilParticle.spawnParticle(horse.func_130014_f_(), EnumParticleTypes.SMOKE_LARGE, horse.func_180425_c());
            UtilSound.playSound(player, horse.func_180425_c(), SoundEvents.field_187711_cp, SoundCategory.NEUTRAL);
            horse.func_110227_p(true);
        }
    }

    public static enum HorseUpgradeType {
        HEALTH,
        JUMP,
        SPEED,
        TYPE,
        VARIANT;

    }
}

