/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.food;

import com.lothrazar.cyclicmagic.IHasConfig;
import com.lothrazar.cyclicmagic.IHasRecipe;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.net.PacketSyncPlayerHealth;
import com.lothrazar.cyclicmagic.registry.CapabilityRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFoodHeart
extends ItemFood
implements IHasRecipe,
IHasConfig {
    private static final int numFood = 2;
    private static final int numHearts = 1;
    private static int maxHearts = 20;

    public ItemFoodHeart() {
        super(2, false);
        this.func_77848_i();
    }

    private boolean isPlayerMaxHearts(EntityPlayer player) {
        return UtilEntity.getMaxHealth((EntityLivingBase)player) / 2.0 >= (double)maxHearts;
    }

    protected void func_77849_c(ItemStack par1ItemStack, World world, EntityPlayer player) {
        CapabilityRegistry.IPlayerExtendedProperties prop = CapabilityRegistry.getPlayerProperties(player);
        if (this.isPlayerMaxHearts(player)) {
            UtilSound.playSound(player, SoundRegistry.buzzp);
            return;
        }
        int newVal = UtilEntity.incrementMaxHealth((EntityLivingBase)player, 2);
        prop.setMaxHealth(newVal);
        UtilSound.playSound(player, SoundRegistry.fill);
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{Items.field_185164_cV, Items.field_179558_bo, Items.field_151158_bO, Items.field_151045_i, Items.field_151105_aU, Blocks.field_150475_bE, new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()), Items.field_151153_ao, Items.field_151170_bI});
    }

    @SubscribeEvent
    public void onPlayerWarp(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilityRegistry.IPlayerExtendedProperties props = CapabilityRegistry.getPlayerProperties(event.player);
        if (props.getMaxHealth() > 0 && event.player instanceof EntityPlayerMP) {
            ModCyclic.network.sendTo((IMessage)new PacketSyncPlayerHealth(props.getMaxHealth()), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        CapabilityRegistry.IPlayerExtendedProperties src = CapabilityRegistry.getPlayerProperties(event.getOriginal());
        CapabilityRegistry.IPlayerExtendedProperties dest = CapabilityRegistry.getPlayerProperties(event.getEntityPlayer());
        dest.setDataFromNBT(src.getDataAsNBT());
        if (src.getMaxHealth() > 0) {
            UtilEntity.setMaxHealth((EntityLivingBase)event.getEntityPlayer(), src.getMaxHealth());
        }
    }

    @Override
    public void syncConfig(Configuration config) {
        maxHearts = config.getInt("HeartContainerMax", "modpacks", 20, 10, 100, "Maximum number of heart containers you can get by eating heart containers.  Does not limit the /sethearts command");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(UtilChat.lang(this.func_77658_a() + ".tooltip"));
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (this.isPlayerMaxHearts(playerIn)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        return super.func_77659_a(itemStackIn, worldIn, playerIn, hand);
    }
}

