/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.command;

import com.lothrazar.cyclicmagic.command.BaseCommand;
import com.lothrazar.cyclicmagic.util.UtilChat;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CommandRecipe
extends BaseCommand
implements ICommand {
    public static final String name = "searchrecipe";

    public CommandRecipe(boolean op) {
        super(name, op);
    }

    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        World world = sender.func_130014_f_();
        if (!(sender instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        ItemStack held = player.field_71071_by.func_70448_g();
        if (held == null && world.field_72995_K) {
            UtilChat.addChatMessage(player, "command.recipes.empty");
            return;
        }
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        boolean foundSomething = false;
        for (IRecipe recipe : recipes) {
            ShapedRecipes r;
            ItemStack recipeResult = recipe.func_77571_b();
            if (recipeResult == null || recipeResult.func_77973_b() == null || held.func_77973_b() != recipeResult.func_77973_b() || held.func_77960_j() != recipeResult.func_77960_j()) continue;
            if (recipe instanceof ShapedRecipes) {
                r = (ShapedRecipes)recipe;
                boolean isInventory = r.field_77577_c < 3 || r.field_77576_b < 3;
                UtilChat.addChatMessage(player, "command.recipes.found");
                CommandRecipe.addChatShapedRecipe(player, CommandRecipe.getRecipeInput(recipe), isInventory);
                foundSomething = true;
                continue;
            }
            if (recipe instanceof ShapedOreRecipe) {
                r = (ShapedOreRecipe)recipe;
                ItemStack[] recipeItems = CommandRecipe.getRecipeInput(recipe);
                boolean isInventory = false;
                int sum = 0;
                for (Field f : ShapedOreRecipe.class.getDeclaredFields()) {
                    f.setAccessible(true);
                    if (f.getType() != Integer.TYPE) continue;
                    try {
                        sum += f.getInt(r);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                isInventory = (sum -= 6) == 4;
                UtilChat.addChatMessage(player, "command.recipes.found");
                CommandRecipe.addChatShapedRecipe(player, recipeItems, isInventory);
                foundSomething = true;
                continue;
            }
            if (!(recipe instanceof ShapelessRecipes) && !(recipe instanceof ShapelessOreRecipe)) continue;
            UtilChat.addChatMessage(player, "command.recipes.found");
            CommandRecipe.addChatShapelessRecipe(player, CommandRecipe.getRecipeInput(recipe));
            foundSomething = true;
        }
        if (!foundSomething) {
            UtilChat.addChatMessage(player, "command.recipes.notfound");
        }
    }

    public static ItemStack[] getRecipeInput(IRecipe recipe) {
        ItemStack[] recipeItems;
        block14: {
            block15: {
                boolean doorShape;
                block13: {
                    recipeItems = null;
                    if (!(recipe instanceof ShapedRecipes)) break block13;
                    ShapedRecipes r = (ShapedRecipes)recipe;
                    recipeItems = r.field_77574_d;
                    break block14;
                }
                if (!(recipe instanceof ShapedOreRecipe)) break block15;
                ShapedOreRecipe r = (ShapedOreRecipe)recipe;
                recipeItems = new ItemStack[r.getInput().length];
                for (int i = 0; i < r.getInput().length; ++i) {
                    Object o = r.getInput()[i];
                    if (o == null) continue;
                    if (o instanceof ItemStack) {
                        recipeItems[i] = (ItemStack)o;
                        continue;
                    }
                    List c = (List)o;
                    if (c == null || c.size() <= 0) continue;
                    recipeItems[i] = (ItemStack)c.get(0);
                }
                boolean bl = doorShape = r.getInput().length == 6;
                if (!doorShape) break block14;
                ItemStack[] backup = recipeItems;
                recipeItems = new ItemStack[9];
                for (int inew = 0; inew < recipeItems.length; ++inew) {
                    if (inew == 2 || inew == 5 || inew == 8) {
                        recipeItems[inew] = null;
                        continue;
                    }
                    int iold = inew;
                    if (inew > 5) {
                        iold = inew - 2;
                    } else if (inew > 2) {
                        iold = inew - 1;
                    }
                    recipeItems[inew] = backup[iold];
                }
                break block14;
            }
            if (recipe instanceof ShapelessRecipes) {
                ShapelessRecipes r = (ShapelessRecipes)recipe;
                recipeItems = new ItemStack[r.field_77579_b.size()];
                for (int i = 0; i < r.field_77579_b.size(); ++i) {
                    Object o = r.field_77579_b.get(i);
                    if (o == null || !(o instanceof ItemStack)) continue;
                    recipeItems[i] = (ItemStack)o;
                }
            } else if (recipe instanceof ShapelessOreRecipe) {
                ShapelessOreRecipe r = (ShapelessOreRecipe)recipe;
                recipeItems = new ItemStack[r.getInput().size()];
                for (int i = 0; i < r.getInput().size(); ++i) {
                    Object o = r.getInput().get(i);
                    if (o == null) continue;
                    if (o instanceof ItemStack) {
                        recipeItems[i] = (ItemStack)o;
                        continue;
                    }
                    List c = (List)o;
                    if (c == null || c.size() <= 0) continue;
                    recipeItems[i] = (ItemStack)c.get(0);
                }
            }
        }
        return recipeItems;
    }

    public static void addChatShapelessRecipe(EntityPlayer player, ItemStack[] recipeItems) {
        for (int i = 0; i < recipeItems.length; ++i) {
            ItemStack is = recipeItems[i];
            UtilChat.addChatMessage(player, " - " + is.func_82833_r());
        }
    }

    public static void addChatShapedRecipe(EntityPlayer player, ItemStack[] recipeItems, boolean isInventory) {
        int size = isInventory ? 4 : 9;
        if (recipeItems.length > size) {
            size = 9;
        }
        String[] grid = new String[size];
        for (int i = 0; i < grid.length; ++i) {
            grid[i] = "- ";
        }
        HashMap<String, String> namenumbers = new HashMap<String, String>();
        for (int i = 0; i < size; ++i) {
            if (i >= recipeItems.length || recipeItems[i] == null) continue;
            String name = recipeItems[i].func_82833_r();
            if (namenumbers.containsKey(name)) {
                namenumbers.put(name, (String)namenumbers.get(name) + ", " + i);
            } else {
                namenumbers.put(name, "" + i);
            }
            if (i >= grid.length) continue;
            grid[i] = i + " ";
        }
        if (isInventory) {
            UtilChat.addChatMessage(player, grid[0] + grid[1]);
            UtilChat.addChatMessage(player, grid[2] + grid[3]);
        } else {
            UtilChat.addChatMessage(player, grid[0] + grid[1] + grid[2]);
            UtilChat.addChatMessage(player, grid[3] + grid[4] + grid[5]);
            UtilChat.addChatMessage(player, grid[6] + grid[7] + grid[8]);
        }
        for (Map.Entry entry : namenumbers.entrySet()) {
            String item = (String)entry.getKey();
            String nums = (String)entry.getValue();
            UtilChat.addChatMessage(player, item + " : " + nums);
        }
    }
}

